#include "ui_main.h"
#include "ui_startlevel.h"
#include "ui_collections.h"
#include "ui_game.h"
#include "game.h"

#include <QDebug>
#include <QApplication>

#include <QWidget>
#include <QObject>

int main(int argc, char** argv)
{
    QApplication app(argc, argv);

    QWidget mainWindow;

    Ui::Main ui;
    ui.setupUi(&mainWindow);

    Ui::StartLevel startUi;
    startUi.setupUi(ui.startWidget);
    QObject::connect(startUi.quitButton, SIGNAL(clicked()), &app, SLOT(quit()));

    Ui::LevelCollections levelUi;
    levelUi.setupUi(ui.collectionWidget);
    QObject::connect(levelUi.quitButton, SIGNAL(clicked()), &app, SLOT(quit()));

    Ui::Game gameUi;
    gameUi.setupUi(ui.gameWidget);

    GameField field(gameUi.gameTable);
    AvailablePieces pieces(gameUi.pieceTable);
    QStringList levelCollections;
    levelCollections << "intro" << "basic"; // TODO: read from fs
    GameController controller(&pieces, &field, gameUi.timeLabel, gameUi.doneButton);
    LevelSwitcher switcher(&controller,
                           ui.collectionWidget, levelUi.levelList, levelUi.startButton,
                           ui.startWidget, startUi.startTitle,
                           startUi.startLabel, startUi.startButton,
                           ui.gameWidget, gameUi.levelLabel, gameUi.scoreLabel, levelCollections);

    mainWindow.show();

    return app.exec();
}
