// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef EVESETTINGSDIALOG_H
#define EVESETTINGSDIALOG_H

#include <QDialog>
#include "evemodel.h"
#include <QtMaemo5>
#include <QtGui>
#include <QSharedPointer>

class QNetworkReply;
class EveCharacter;
namespace Ui {
    class EveSettingsDialog;
}

class EveSettingsDialog : public QDialog {
    Q_OBJECT
public:
    EveSettingsDialog(QWidget *parent = 0);

    int selectedCharacter();
    QSharedPointer<EveModel> model() { return m_model; }
    void setModel(QSharedPointer<EveModel> &model);
protected:
    void changeEvent(QEvent *e);
public slots:
    void tryLoadCharacters();
    void charactersLoaded();
    void characterSelected();
    void donePressed();
private:
    QSharedPointer<EveModel> m_model;
    QNetworkReply *m_reply;
    EveCharacter *m_selection;
    QLineEdit *userIdEdit;
    QLineEdit *apiKeyEdit;
    QMaemo5ValueButton *characterPicker;
    QMaemo5ListPickSelector *characterSelector;
    QStandardItemModel *characterModel;
    QVBoxLayout *m_layout;

};

#endif // EVESETTINGSDIALOG_H
