// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef EVEMODEL_H
#define EVEMODEL_H

#include "eveaccount.h"
#include <QObject>
#include <QString>
#include <QNetworkAccessManager>
#include <QNetworkReply>
class EveModel : public QObject
{
    Q_OBJECT
public:
    explicit EveModel(QObject *parent = 0);
    void setApiKey(QString aKey) { m_apiKey = aKey; }
    QString apiKey() const { return m_apiKey; }

    void setUserId(int aId) { m_userId = aId; }
    int userId() const { return m_userId; }
    QList<EveCharacter> &characters() { return m_characters; }

    EveCharacter *selectedCharacter();
    void setSelected( int index ) { m_selectedIndex = index; }
    int selectedIndex() { return m_selectedIndex; }
signals:
    void accountsReady();

public slots:
    void fetchAccounts();
    bool loadSettings();
    void saveSettings();

private slots:
    void replyReady();
    void networkError(QNetworkReply::NetworkError);
private:
    QString m_apiKey;
    int m_userId;
    QNetworkAccessManager mgr;
    QNetworkReply *m_reply;
    QList<EveCharacter> m_characters;
    int m_selectedIndex;
};

#endif // EVEMODEL_H
