// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef EVEACCOUNT_H
#define EVEACCOUNT_H

#include <QObject>
#include <QIODevice>
#include <QXmlStreamReader>
#include <QPixmap>
#include <QNetworkReply>
#include <QNetworkAccessManager>

#include "eveskilltraining.h"
class EveCharacter : public QObject
{
    Q_OBJECT
public:
    explicit EveCharacter(QObject *parent = 0);
    EveCharacter(const EveCharacter &aOther);
    EveCharacter &operator=(const EveCharacter&other);
    ~EveCharacter();
    bool fromXml(QXmlStreamReader &xml);
    bool fetchImage();
signals:
    void imageLoaded();
public slots:
    void imageReady();
public:
    QString name;
    QString corpName;
    int characterId;
    int corpId;
    QPixmap *characterIcon;
    EveSkillTraining currentSkill;
private:
    QNetworkReply *m_reply;
    QNetworkAccessManager mgr;
};

#endif // EVEACCOUNT_H
