#include <QtCore/QCoreApplication>
#include <QtTest/QtTest>
#include "eveaccount.h"
#include "evemodel.h"
#include "eveskilltraining.h"
#include "skilltree.h"
#include "widget.h"
#include <QFile>
#include <QSettings>
class EveModelTest: public QObject
{
    Q_OBJECT
private slots:
    void testXml();
    void testSkills();
    void testSkillTree();
    void testSave();
};

void EveModelTest::testXml()
{
    EveModel model;
    model.fetchAccounts();
    QSignalSpy spy(&model,SIGNAL(accountsReady()));
    QTest::qWait(1000);
    QCOMPARE(spy.length(),1);
    QCOMPARE(model.characters().length(),2);
    EveCharacter e;
    foreach (e,model.characters()) {
        qDebug() << e.name << ":" << e.characterId;
    }
    e = model.characters()[0];
    qDebug() << "e assigned";
    QSignalSpy imagespy(&e,SIGNAL(imageLoaded()));
    qDebug() << "spy installed";
    e.fetchImage();
    qDebug() << "fetchImage called";
    QTest::qWait(3000);
    qDebug() << "waited";
    qDebug() << e.characterIcon;
    QVERIFY(imagespy.length() == 1);
    qDebug() << "Test done";
}

void EveModelTest::testSkills()
{
    EveModel model;

    model.fetchAccounts();
    QTest::qWait(1000);
    EveCharacter e = model.characters()[0];
    EveSkillTraining skill;
    skill.setCharacter(&e);
    skill.setAccount(&model);
    skill.fetchInfo();
    QTest::qWait(1000);
    qDebug() << skill.startTime
            << skill.endTime
            << skill.typeId
            << skill.startSkillpoints
            << skill.destSkillpoints
            << skill.level;
}

void EveModelTest::testSkillTree()
{
    SkillTree stree;
    QSignalSpy spy(&stree,SIGNAL(skillsLoaded()));
    stree.loadSkills();
    QTest::qWait(5000);
    QCOMPARE(spy.count(),1);
    QCOMPARE(stree.skillName(3442),QString("Drone Interfacing"));
    stree.save();
    QVERIFY(QFile::exists("/var/tmp/skillCache"));
    QFile::remove("/var/tmp/skillCache");
}

void EveModelTest::testSave()
{
    EveModel model;
    model.loadSettings();
    // Verify that the unsaved data is doesn't exist
    QVERIFY(model.apiKey().isNull());
    QVERIFY(model.userId() == 0);
    QVERIFY(model.selectedCharacter() == NULL);
    model.setApiKey("f");
    model.setUserId(1);
    model.fetchAccounts();
    QTest::qWait(1000);
    model.saveSettings();
    EveModel result;
    result.loadSettings();
    QCOMPARE(result.apiKey(),QString("1"));
    QCOMPARE(result.userId(),1);
    QVERIFY(result.selectedCharacter() == NULL);
    QSettings temp("net.korjaussarja","evehomescreen");
    temp.clear();
}

QTEST_MAIN(EveModelTest)

#include "main.moc"
