// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "evesettingsdialog.h"
#include <QtDebug>
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    m_settings(new EveSettingsDialog(this))
{
    ui->setupUi(this);
    connect(ui->fetchButton,SIGNAL(pressed()),this,SLOT(settingsRequested()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::settingsRequested()
{
    int result = m_settings->exec();
    if (result == QDialog::Accepted) {
        m_selectedCharacter = m_settings->selectedCharacter();

        if (m_selectedCharacter > 0 && m_selectedCharacter < m_model->chara ) {
            qDebug() << "Selected character:" << m_character->name;
            connect(m_character,SIGNAL(imageLoaded()),this,SLOT(setLabelImage()));
            m_character->fetchImage();

            skill.setCharacter(m_character);
            skill.setAccount(m_settings->model().data());
            connect(&skill, SIGNAL(finished()),this,SLOT(setSkillTraining()));
            skill.fetchInfo();
        }
    }
}

void MainWindow::setLabelImage()
{
    ui->iconLabel->setPixmap(*(m_character->characterIcon));
}

void MainWindow::setSkillTraining()
{
    ui->trainingLabel->setText(QString("Skill ready at %1").arg(skill.endTime.toString(Qt::SystemLocaleShortDate)));
}

