#include <ethos/ethos.h>
#include <ethos/ethos-manager.h>
#include <string.h>

static void
test1 (void)
{
	g_assert (ethos_manager_new ());
}

static void
test2 (void)
{
	EthosManager *manager = ethos_manager_new ();
	gchar *plugin_dirs[] = { "c-plugins", NULL };
	ethos_manager_set_app_name (manager, "Test");
	ethos_manager_set_plugin_dirs (manager, plugin_dirs);
	ethos_manager_initialize (manager);
	g_assert_cmpint (g_list_length (ethos_manager_get_plugin_loaders (manager)), == , 1);
	g_assert_cmpint (g_list_length (ethos_manager_get_plugin_info (manager)), == , 1);

	/*
	GList *iter;
	for (iter = ethos_manager_get_plugin_info (manager); iter; iter = iter->next) {
		g_print ("=====================\n"
		         "ID............: %s\n"
		         "Name..........: %s\n"
		         "Dependencies..: %s\n"
		         "Website.......: %s\n"
		         "Copyright.....: %s\n",
		         ethos_plugin_info_get_id (iter->data),
		         ethos_plugin_info_get_name (iter->data),
		         ethos_plugin_info_get_dependencies (iter->data),
		         ethos_plugin_info_get_website (iter->data),
		         ethos_plugin_info_get_authors (iter->data));
	}
	*/
}

static void
test3_cb (gpointer data, gpointer user_data)
{
	gboolean *initialized = user_data;
	*initialized = TRUE;
}

static void
test3 (void)
{
	gboolean initialized = FALSE;
	EthosManager *manager = ethos_manager_new ();
	gchar *plugin_dirs[] = { "c-plugins", NULL };
	ethos_manager_set_app_name (manager, "Test");
	ethos_manager_set_plugin_dirs (manager, plugin_dirs);
	g_signal_connect (manager, "initialized", G_CALLBACK (test3_cb), &initialized);
	ethos_manager_initialize (manager);
	g_assert (initialized == TRUE);
}

static void
test4 (void)
{
	EthosManager *manager = ethos_manager_new ();
	gchar *plugin_dirs[] = { "manager-dep", NULL };
	ethos_manager_set_app_name (manager, "Test");
	ethos_manager_set_plugin_dirs (manager, plugin_dirs);
	ethos_manager_initialize (manager);
	g_assert_cmpint (g_list_length (ethos_manager_get_plugin_info (manager)), == , 2);
}

static void
test5 (void)
{
	EthosManager *manager = ethos_manager_new ();
	gchar *plugin_dirs[] = { "c-plugins", NULL };
	ethos_manager_set_app_name (manager, "Test");
	ethos_manager_set_plugin_dirs (manager, plugin_dirs);
	ethos_manager_initialize (manager);
	GList *list;
	GList *iter;
	gboolean found = FALSE;
	list = ethos_manager_get_plugin_info (manager);
	for (iter = list; iter; iter = iter->next) {
		found = TRUE;
		gchar *name, *loader, *authors, *module, *website, *deps;
		g_object_get (iter->data,
		              "name", &name,
		              "loader", &loader,
		              "authors", &authors,
		              "module", &module,
		              "website", &website,
		              "dependencies", &deps,
		              NULL);
		g_assert_cmpstr (name, ==, "Sample");
		g_assert_cmpstr (loader, ==, NULL);
		g_assert_cmpstr (authors, ==, "Ethos Authors");
		g_assert_cmpstr (module, ==, "sample");
		g_assert_cmpstr (website, ==, "http://example.com");
		g_assert_cmpstr (deps, ==, "");
	}
	g_assert (found);
}

gint
main (gint   argc,
      gchar *argv[])
{
	g_type_init ();
	g_test_init (&argc, &argv, NULL);

	g_setenv ("ETHOS_PLUGIN_LOADERS_DIR",
	          C_PLUGIN_LOADER_DIR, TRUE);

	g_test_add_func ("/EthosManager/new", test1);
	g_test_add_func ("/EthosManager/initialize", test2);
	g_test_add_func ("/EthosManager/initialized", test3);
	g_test_add_func ("/EthosManager/dependencies", test4);
	g_test_add_func ("/EthosManager/properties", test5);

	return g_test_run ();
}
