/* ethos.c
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#include <glib.h>
#include <gmodule.h>
#include <string.h>

#include "ethos.h"

/*
typedef enum
{
	DEP_NONE = 0,
	DEP_LT   = 1 << 0,
	DEP_GT   = 1 << 1,
	DEP_EQL  = 1 << 2,
	DEP_LTE  = DEP_LT | DEP_EQL,
	DEP_GTE  = DEP_GT | DEP_EQL,
} DepOperator;

typedef struct
{
	gchar       *name;
	gfloat       ver;
	DepOperator  op;
} Dep;

typedef struct
{
	EthosPluginInfo *info;
	GList           *deps;
	GError          *error;
} Item;

static GList*
ethos_get_deps (EthosPluginInfo *info)
{
	const gchar *name = NULL;
	const gchar *data = NULL;
	GList       *deps = NULL;
	GScanner    *scanner;
	Dep         *dep;

	data = ethos_plugin_info_get_dependencies (info);
	if (!data || g_utf8_strlen (data, -1) == 0)
		return NULL;

	name = ethos_plugin_info_get_id (info);
	scanner = g_scanner_new (NULL);
	g_scanner_input_text (scanner, data, strlen (data));

	if (g_scanner_get_next_token (scanner) != G_TOKEN_IDENTIFIER) {
		g_warning ("%s: Invalid Dependencies", name);
		goto cleanup;
	}

	do {
		gboolean has_oper = TRUE;
		dep = g_slice_new0 (Dep);
		dep->name = g_strdup (g_scanner_cur_value (scanner).v_string);

		// check for first of two possible operator tokens
		switch (g_scanner_peek_next_token (scanner)) {
		case '=':
			dep->op = DEP_EQL;
			break;
		case '<':
			dep->op = DEP_LT;
			break;
		case '>':
			dep->op = DEP_GT;
			break;
		default:
			has_oper = FALSE;
			break;
		}

		if (has_oper) {
			g_scanner_get_next_token (scanner);

			// check for the second possible operator token 
			switch (g_scanner_peek_next_token (scanner)) {
			case '=':
				dep->op |= DEP_EQL;
				break;
			case '<':
				dep->op |= DEP_LT;
				break;
			case '>':
				dep->op |= DEP_GT;
				break;
			default:
				has_oper = FALSE;
				break;
			}

			if (has_oper)
				g_scanner_get_next_token (scanner);

			if (g_scanner_get_next_token (scanner) != G_TOKEN_FLOAT) {
				g_warning ("Invalid Dependency");
				break;
			}

			dep->ver = g_scanner_cur_value (scanner).v_float;
		}

		deps = g_list_append (deps, dep);
	}
	while (g_scanner_get_next_token (scanner) == G_TOKEN_IDENTIFIER);

cleanup:
	g_scanner_destroy (scanner);
	return deps;
}

static void
ethos_build_deps (void)
{
	Item  *item;
	GList *iter;

	_plugin_deps = g_hash_table_new (g_str_hash, g_str_equal);

	for (iter = _plugin_infos; iter; iter = iter->next) {
		item = g_slice_new0 (Item);
		item->info = iter->data;
		item->deps = ethos_get_deps (iter->data);
		//g_hash_table_insert (_plugin_deps, (gpointer)ethos_plugin_info_get_id (iter->data), item);
	}
}

gboolean
ethos_load (EthosPluginInfo *info)
{
	static GHashTable *loading = NULL;
	EthosPluginLoader *loader;
	Dep               *dep;
	GList             *deps, *iter;
	gboolean           success = FALSE;

	// if it is already loaded, we dont need to do anything 
	if (g_object_get_data (G_OBJECT (info), "__ethos_plugin") != NULL)
		return TRUE;

	if (G_UNLIKELY (!loading))
		loading = g_hash_table_new (g_str_hash, g_str_equal);

	if (g_hash_table_lookup (loading, ethos_plugin_info_get_id (info))) {
		g_warning ("Circular dependency found with %s",
		           ethos_plugin_info_get_id (info));
		goto cleanup;
	}

	g_hash_table_insert (loading,
	                     (gpointer)ethos_plugin_info_get_id (info),
	                     info);

	Item *item = g_hash_table_lookup (_plugin_deps, ethos_plugin_info_get_id (info));
	deps = item->deps;
	g_assert (item != NULL);

	for (iter = deps; iter; iter = iter->next) {
		dep = iter->data;
		EthosPluginInfo *dep_info = g_hash_table_lookup (_plugin_infos_hash, dep->name);
		if (!dep_info) {
			g_warning ("Cannot load plugin %s because dependency "
			           "%s is missing",
			           ethos_plugin_info_get_id (info),
			           dep->name);
			goto cleanup;
		}
		if (!ethos_load (dep_info)) {
			g_warning ("Aborting the load of %s because "
			           "of dependencies",
			           ethos_plugin_info_get_id (info));
			goto cleanup;
		}
	}

	// get the loader for the plugin
	loader = get_loader (ethos_plugin_info_get_loader (info));

	if (!loader) {
		g_warning ("Plugin loader %s requested by %s is not supported",
		           ethos_plugin_info_get_loader (info),
		           ethos_plugin_info_get_id (info));
		goto cleanup;
	}

	EthosPlugin *plugin;
	GError      *error = NULL;

	if (!(plugin = ethos_plugin_loader_load (loader, info, &error))) {
		g_warning ("%s: %s",
		           ethos_plugin_info_get_id (info),
		           error ? error->message : "Could not load plugin");
		if (error)
			g_error_free (error);
		goto cleanup;
	}

	ethos_plugin_activate (plugin);
	_loaded_plugins = g_list_prepend (_loaded_plugins, plugin);
	g_object_set_data (G_OBJECT (info), "__ethos_plugin", plugin);

	success = TRUE;

cleanup:
	g_hash_table_remove (loading, ethos_plugin_info_get_id (info));
	return success;
}
*/
