/* ethos-1.0.vapi
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

using GLib;

[CCode (cheader_filename = "ethos/ethos.h")]
namespace Ethos {
	public void register_plugin (Ethos.Plugin plugin);

	[CCode (cname = "EthosError")]
	public errordomain EthosError {
		FILE_NOT_FOUND,
		INVALID_KEY_FILE,
		PLUGIN,
	}

	public class PluginInfo: Object {
		public PluginInfo ();

		public bool load_from_file (string group, string filename) throws EthosError;
		public bool load_from_key_file (string group, KeyFile key_file) throws EthosError;
		public bool load_from_data (string group, string data, size_t length) throws EthosError;

		public string id { get; set; }
		public bool active { get; }
		public string filename { get; set; }
		public string name { get; }
		public string module { get; }
		public string loader { get; }
		public string[] authors { get; }
		public string description { get; }
		public string copyright { get; }
		public string website { get; }
		public string dependencies { get; }
		public string icon_name { get; }
		public string version { get; }

		public uint get_iage ();

		public bool has_errors ();
		public List<GLib.Error> get_errors ();
	}

	public class Plugin: Object {
		public signal void activated ();
		public signal void deactivated ();

		public void activate ();
		public void deactivate ();
	}

	public interface PluginLoader: Object {
		public virtual weak string get_name ();
		public virtual void initialize ();
		public virtual void unload ();
		public virtual Ethos.Plugin? load (Ethos.PluginInfo plugin_info) throws EthosError;
		public virtual void gc ();
	}

	public class Manager: Object {
		public signal void initialized ();
		public signal void plugin_loaded (Ethos.PluginInfo plugin_info);
		public signal void plugin_unloaded (Ethos.PluginInfo plugin_info);

		public virtual void initialize ();
		public void set_app_name (string app_name);
		public void set_plugin_dirs (string* plugin_dirs);
		public weak string* get_plugin_dirs ();
		public GLib.List<Ethos.PluginInfo> get_plugin_info ();
		public bool load_plugin (Ethos.PluginInfo plugin_info) throws EthosError;
		public bool unload_plugin (Ethos.PluginInfo plugin_info) throws EthosError;
		public GLib.List<Ethos.PluginLoader> get_plugin_loaders ();
		public Ethos.Plugin? get_plugin (Ethos.PluginInfo plugin_info);
	}
}
