#include <glib.h>
#include <gmodule.h>
#include <ethos/ethos.h>
#include <ethos/ethos-ui.h>

#define EXAMPLE_TYPE_PLUGIN		(example_plugin_get_type ())
#define EXAMPLE_PLUGIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), EXAMPLE_TYPE_PLUGIN, ExamplePlugin))
#define EXAMPLE_PLUGIN_CONST(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), EXAMPLE_TYPE_PLUGIN, ExamplePlugin const))
#define EXAMPLE_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), EXAMPLE_TYPE_PLUGIN, ExamplePluginClass))
#define EXAMPLE_IS_PLUGIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXAMPLE_TYPE_PLUGIN))
#define EXAMPLE_IS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), EXAMPLE_TYPE_PLUGIN))
#define EXAMPLE_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), EXAMPLE_TYPE_PLUGIN, ExamplePluginClass))

typedef struct _ExamplePlugin		ExamplePlugin;
typedef struct _ExamplePluginClass	ExamplePluginClass;
typedef struct _ExamplePluginPrivate	ExamplePluginPrivate;

struct _ExamplePlugin
{
	EthosPlugin parent;

	ExamplePluginPrivate *priv;
};

struct _ExamplePluginClass
{
	EthosPluginClass parent_class;
};

GType        example_plugin_get_type (void) G_GNUC_CONST;
EthosPlugin* example_plugin_new      (void);

struct _ExamplePluginPrivate
{
	gpointer dummy;
};

static void
destroy (GtkWidget *widget)
{
	gtk_widget_destroy (gtk_widget_get_toplevel (widget));
}

static void
configure (EthosUIConfigurable *configurable,
           GtkWidget           *parent)
{
	GtkWidget *window,
		  *button;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_transient_for (GTK_WINDOW (window), GTK_WINDOW (parent));
	gtk_widget_show (window);

	button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	gtk_container_add (GTK_CONTAINER (window), button);
	gtk_widget_show (button);

	g_signal_connect (G_OBJECT (button),
	                  "clicked",
	                  G_CALLBACK (destroy),
	                  NULL);
}

static void
configurable_init (gpointer iface)
{
	EthosUIConfigurableIface *ciface = iface;
	ciface->configure = configure;
}

G_DEFINE_TYPE_EXTENDED (ExamplePlugin, example_plugin, ETHOS_TYPE_PLUGIN,
                        0,
                        G_IMPLEMENT_INTERFACE (ETHOS_UI_TYPE_CONFIGURABLE,
                                               configurable_init));

static void
example_plugin_finalize (GObject *object)
{
	G_OBJECT_CLASS (example_plugin_parent_class)->finalize (object);
}

static void activated (EthosPlugin *plugin)
{
}

static void deactivated (EthosPlugin *plugin)
{
}

static void
example_plugin_class_init (ExamplePluginClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	EthosPluginClass *plugin_class = ETHOS_PLUGIN_CLASS (klass);
	
	object_class->finalize = example_plugin_finalize;
	plugin_class->activated = activated;
	plugin_class->deactivated = deactivated;

	g_type_class_add_private (object_class, sizeof(ExamplePluginPrivate));
}

static void
example_plugin_init (ExamplePlugin *self)
{
	self->priv = G_TYPE_INSTANCE_GET_PRIVATE (self, EXAMPLE_TYPE_PLUGIN, ExamplePluginPrivate);
}

EthosPlugin*
example_plugin_new ()
{
	return g_object_new (EXAMPLE_TYPE_PLUGIN, NULL);
}

G_MODULE_EXPORT EthosPlugin*
ethos_plugin_register (void)
{
	return example_plugin_new ();
}
