
#include "basic.h"
#include <gtk/gtk.h>
#include <ethos/ethos.h>
#include <stdio.h>




struct _BasicExamplePrivate {
	EthosManager* manager;
	GtkWindow* window;
	GtkButton* button;
};

#define BASIC_EXAMPLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BASIC_TYPE_EXAMPLE, BasicExamplePrivate))
enum  {
	BASIC_EXAMPLE_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
static void __lambda0 (BasicExample* self);
static void ___lambda0_ethos_manager_initialized (EthosManager* _sender, gpointer self);
static void __lambda1 (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self);
static void ___lambda1_ethos_manager_plugin_loaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self);
static void __lambda2 (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self);
static void ___lambda2_ethos_manager_plugin_unloaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self);
static void __lambda3 (BasicExample* self);
static void ___lambda3_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * basic_example_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer basic_example_parent_class = NULL;
static void basic_example_finalize (GObject* obj);



void basic_main (char** args, int args_length1) {
	BasicExample* example;
	gtk_init (&args_length1, &args);
	example = basic_example_new ();
	basic_example_run (example);
	(example == NULL) ? NULL : (example = (g_object_unref (example), NULL));
}


int main (int argc, char ** argv) {
	g_type_init ();
	basic_main (argv, argc);
	return 0;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


void basic_example_run (BasicExample* self) {
	g_return_if_fail (self != NULL);
	ethos_manager_initialize (self->priv->manager);
	{
		GList* loader_collection;
		GList* loader_it;
		loader_collection = ethos_manager_get_plugin_loaders (self->priv->manager);
		for (loader_it = loader_collection; loader_it != NULL; loader_it = loader_it->next) {
			EthosPluginLoader* _tmp2;
			EthosPluginLoader* loader;
			_tmp2 = NULL;
			loader = (_tmp2 = (EthosPluginLoader*) loader_it->data, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2));
			{
				const char* _tmp0;
				char* name;
				_tmp0 = NULL;
				name = (_tmp0 = ethos_plugin_loader_get_name (loader), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
				if (name == NULL) {
					char* _tmp1;
					_tmp1 = NULL;
					name = (_tmp1 = g_strdup ("default"), name = (g_free (name), NULL), _tmp1);
				}
				g_debug ("basic.vala:40: Loaded loader %s", name);
				(loader == NULL) ? NULL : (loader = (g_object_unref (loader), NULL));
				name = (g_free (name), NULL);
			}
		}
		(loader_collection == NULL) ? NULL : (loader_collection = (_g_list_free_g_object_unref (loader_collection), NULL));
	}
	gtk_main ();
}


BasicExample* basic_example_construct (GType object_type) {
	BasicExample * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


BasicExample* basic_example_new (void) {
	return basic_example_construct (BASIC_TYPE_EXAMPLE);
}


static void __lambda0 (BasicExample* self) {
	fprintf (stdout, "Ethos was initialized\n");
}


static void ___lambda0_ethos_manager_initialized (EthosManager* _sender, gpointer self) {
	__lambda0 (self);
}


static void __lambda1 (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self) {
	g_return_if_fail (_ != NULL);
	g_return_if_fail (plugin_info != NULL);
	fprintf (stdout, "%s plugin was loaded\n", ethos_plugin_info_get_id (plugin_info));
}


static void ___lambda1_ethos_manager_plugin_loaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self) {
	__lambda1 (_sender, plugin_info, self);
}


static void __lambda2 (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self) {
	g_return_if_fail (_ != NULL);
	g_return_if_fail (plugin_info != NULL);
	fprintf (stdout, "%s plugin was unloaded\n", ethos_plugin_info_get_id (plugin_info));
}


static void ___lambda2_ethos_manager_plugin_unloaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self) {
	__lambda2 (_sender, plugin_info, self);
}


static void __lambda3 (BasicExample* self) {
	gtk_main_quit ();
}


static void ___lambda3_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda3 (self);
}


static GObject * basic_example_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	BasicExampleClass * klass;
	GObjectClass * parent_class;
	BasicExample * self;
	klass = BASIC_EXAMPLE_CLASS (g_type_class_peek (BASIC_TYPE_EXAMPLE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = BASIC_EXAMPLE (obj);
	{
		EthosManager* _tmp0;
		GtkWindow* _tmp1;
		GtkButton* _tmp2;
		_tmp0 = NULL;
		self->priv->manager = (_tmp0 = g_object_new (ETHOS_TYPE_MANAGER, NULL), (self->priv->manager == NULL) ? NULL : (self->priv->manager = (g_object_unref (self->priv->manager), NULL)), _tmp0);
		g_signal_connect (self->priv->manager, "initialized", (GCallback) ___lambda0_ethos_manager_initialized, self);
		g_signal_connect (self->priv->manager, "plugin-loaded", (GCallback) ___lambda1_ethos_manager_plugin_loaded, self);
		g_signal_connect (self->priv->manager, "plugin-unloaded", (GCallback) ___lambda2_ethos_manager_plugin_unloaded, self);
		_tmp1 = NULL;
		self->priv->window = (_tmp1 = g_object_ref_sink ((GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL)), (self->priv->window == NULL) ? NULL : (self->priv->window = (g_object_unref (self->priv->window), NULL)), _tmp1);
		gtk_window_set_title (self->priv->window, "Vala Example");
		gtk_widget_show ((GtkWidget*) self->priv->window);
		_tmp2 = NULL;
		self->priv->button = (_tmp2 = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_QUIT)), (self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL)), _tmp2);
		g_signal_connect (self->priv->button, "clicked", (GCallback) ___lambda3_gtk_button_clicked, self);
		gtk_container_add ((GtkContainer*) self->priv->window, (GtkWidget*) self->priv->button);
		gtk_widget_show ((GtkWidget*) self->priv->button);
	}
	return obj;
}


static void basic_example_class_init (BasicExampleClass * klass) {
	basic_example_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BasicExamplePrivate));
	G_OBJECT_CLASS (klass)->constructor = basic_example_constructor;
	G_OBJECT_CLASS (klass)->finalize = basic_example_finalize;
}


static void basic_example_instance_init (BasicExample * self) {
	self->priv = BASIC_EXAMPLE_GET_PRIVATE (self);
}


static void basic_example_finalize (GObject* obj) {
	BasicExample * self;
	self = BASIC_EXAMPLE (obj);
	(self->priv->manager == NULL) ? NULL : (self->priv->manager = (g_object_unref (self->priv->manager), NULL));
	(self->priv->window == NULL) ? NULL : (self->priv->window = (g_object_unref (self->priv->window), NULL));
	(self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL));
	G_OBJECT_CLASS (basic_example_parent_class)->finalize (obj);
}


GType basic_example_get_type (void) {
	static GType basic_example_type_id = 0;
	if (basic_example_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (BasicExampleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_example_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicExample), 0, (GInstanceInitFunc) basic_example_instance_init, NULL };
		basic_example_type_id = g_type_register_static (G_TYPE_OBJECT, "BasicExample", &g_define_type_info, 0);
	}
	return basic_example_type_id;
}




