/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
 */
 /**
  * @file estardict-gui-infoPage.c
  * @author Luca Vaudano
  */
#include "estardict-gui-infoPage.h"
#include "estardict-gui-logic.h"
#include "../include/config.h"
#include "i18n.h"


/**
 * @brief Create about frame
 */
Evas_Object* createAboutFrame() {
    Evas_Object *frame, *en;
    gchar* version = g_try_malloc(VERSION_SIZE);
    gchar* description = g_try_malloc(DESCRIPTION_LENGHT);
    gchar* theme = g_try_malloc(PATH_MAX);

    //snprintf(theme, sizeof(theme), DEFAULT_THEME, ROOT_DIR);
    //elm_theme_extension_add(NULL, theme);

    frame = elm_frame_add(win);
    elm_object_text_set(frame, PACKAGE_STRING);
    evas_object_size_hint_align_set(frame, EVAS_HINT_FILL, 0);
    evas_object_show(frame);

    snprintf(version, 1024, COPYRIGHT, VERSION);
    description = g_strconcat(BRIEF_DESCRIPTION, version, DESCRIPTION, NULL);

    en = elm_entry_add(win);
    //elm_object_style_set(en, "estardict");
    elm_entry_editable_set(en, EINA_FALSE);
    elm_entry_line_wrap_set(en, EINA_TRUE);
    evas_object_size_hint_align_set(en, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_entry_entry_set(en, description);
    evas_object_show(en);

    elm_object_content_set(frame, en);
    
    g_free(version);
    g_free(description);
    g_free(theme);
    
    return frame;
}


/**
 * @brief Create first usage frame
 */
Evas_Object* createFirstUsageFrame() {
    Evas_Object *frame, *en;
    gchar* description;

    frame = elm_frame_add(win);
    elm_object_text_set(frame, PACKAGE_STRING);
    evas_object_size_hint_align_set(frame, EVAS_HINT_FILL, 0);
    evas_object_show(frame);

    description = TIPS_ON_STARTUP;

    en = elm_entry_add(win);
    elm_entry_editable_set(en, EINA_FALSE);
    elm_entry_line_wrap_set(en, EINA_TRUE);
    evas_object_size_hint_align_set(en, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_entry_entry_set(en, description);
    evas_object_show(en);

    elm_object_content_set(frame, en);
    return frame;
}


/**
 * @brief Create about page, if needed
 *
 * @param Type Type of page (About page, first usage page, ...)
 */
void createInfoPage(Type type) {
    g_debug("-> %s %s()", __FILE__, __FUNCTION__);
    Evas_Object *sc, *bx, *bt, *frame;

    // Box Window with scroller and quit button
    infoBox = elm_box_add(win);
    elm_box_horizontal_set(infoBox, EINA_FALSE);
    evas_object_size_hint_weight_set(infoBox, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(infoBox, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_win_resize_object_add(win, infoBox);
    evas_object_show(infoBox);

    // Scroller
    sc = elm_scroller_add(win);
    evas_object_size_hint_weight_set(sc, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(sc, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_box_pack_end(infoBox, sc);
    evas_object_show(sc);

    // OK button
    bt = elm_button_add(win);
    elm_object_text_set(bt, BUTTON_OK);
    evas_object_size_hint_align_set(bt, EVAS_HINT_FILL, 0);
    elm_box_pack_end(infoBox, bt);
    evas_object_show(bt);
    evas_object_smart_callback_add(bt, "clicked", promoteDefinitionPage, NULL);

    // Box inside scroller
    bx = elm_box_add(win);
    elm_box_horizontal_set(bx, EINA_FALSE);
    evas_object_size_hint_weight_set(bx, EVAS_HINT_EXPAND, -1);
    elm_object_content_set(sc, bx);
    evas_object_show(bx);

    // Frame for information section
    if ( type == ABOUT) {
        g_debug("type about");
        frame = createAboutFrame();
        elm_box_pack_end(bx, frame);
    } else {
        if ( type == FIRST_USAGE) {
            g_debug("type first usage");
            frame = createFirstUsageFrame();
            elm_box_pack_end(bx, frame);
        }
    }
}
