#ifndef _ESTARDICT_CONFIG_H
#define _ESTARDICT_CONFIG_H
/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
*    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License along
*    with this program; if not, write to the Free Software Foundation, Inc.,
*    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
*/
 /**
  * @file estardict-config.h
  * @author Luca Vaudano
  */
/*********
 * HEADERS
 *********/
// GLIB
#include <glib.h>

// Enlightenment Elementary
#include <Elementary.h>

/******
 * DEFINITIONS
 ******/
#define CONFIGURATION_FILE "config.eet"
#define CONFIGURATION_VERSION 1
#define DICTIONARY_PATH_DEFAULT_VALUE ""
#define SOUND_DICTIONARY_PATH_DEFAULT_VALUE ""
#define PLAYER_DEFAULT_VALUE "/usr/bin/aplay"
#define SUGGESTED_WORD_NUMBER_DEFAULT_VALUE 3
#define SUGGESTED_WORD_SHOW_DEFAULT_VALUE 1

/**
 * Estardict properties
 */
typedef struct {
   unsigned int version;
   const gchar *player;
   unsigned int suggestedWordsNumber;
   gboolean suggestedWordsVisible;
   Eina_List *dictionaries;
   Eina_List *soundDictionaries;
} EstardictProperties;

/**
 * Dictionary properties
 */
typedef struct {
   const gchar *dictionaryPath;
} DictionaryProperties;


/**** **
 * DATA STRUCTURES
 *******/

/****
 * METHODS
 ******/
gboolean closeConfigFile();
gboolean initializeConfiguration();
Eina_List* getDictionaries();
const gchar* getSoundDictionary();
gchar* getPlayer();
gboolean getSuggestedWordShow();
gboolean setDictionaries(Eina_List *dictionaryList);
gboolean setSoundDictionary(gchar* soundDictionaryPath);
gboolean setPlayer(gchar* playerFile);
gboolean setSuggestedWordShow(gboolean suggestedWordShow);


#endif
