#ifndef _ESTARDICT_GUI_H
#define _ESTARDICT_GUI_H
/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
*    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License along
*    with this program; if not, write to the Free Software Foundation, Inc.,
*    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
*/
 /**
  * @file estardict-gui.h
  * @author Luca Vaudano
  */ 
/*********
 * HEADERS
 *********/
// GLIB
#include <glib.h>

// Enlightenment Elementary
#include <Elementary.h>

/******
 * DEFINITIONS
 ******/
Evas_Object *win;

#define SCREEN_WIDTH 480
#define SCREEN_HEIGHT 480

#define ROOT_DIR "/usr/share/estardict/"

#define DICTIONARIES_FRAME_LABEL i18n("Dictionaries")
#define ADD_BUTTON_LABEL i18n("Add")
#define REMOVE_BUTTON_LABEL i18n("Remove")

#define SOUND_DICTIONARY_FRAME_LABEL i18n("Sound dictionary PATH")
#define PLAYER_FRAME_LABEL i18n("Player FILE NAME")
#define SAVE_BUTTON_LABEL i18n("Save")
#define QUIT_BUTTON_LABEL i18n("Quit")
#define ABOUT_BUTTON_LABEL i18n("About")

#define BRIEF_DESCRIPTION i18n("eStarDict is a offline dictionaries reader.")
#define COPYRIGHT "\
<br><br>\
<b>Version</b> %s<br>\
<b>Copyright</b> 2010, Luca Vaudano<br>\
<b>Licensed</b> under the GNU GPL v3<br>\
<br><br>\
"
#define DESCRIPTION i18n("\
The objective of this application is creating a graphics user interface that emphasizes simplicity and lightness.\
<br><br>\
As development focuses on keeping weight down to a minimum, only the most essential features are implemented.\
It should be simple to use, requires few libraries and starts up quickly.\
<br><br>\
The main target is the openmoko Freerunner cellphone and secondly the netbook.\
<br><br>\
* Supports dictionaries in StarDict formats.\
<br>\
* Voice capability\
")

#define TIPS_ON_STARTUP i18n("\
<b>1.</><br>\
Download from the Web a dictionary. For example:<br>\
<em>http://xdxf.revdanica.com/down/index.php</><br>\
Download option must be StarDict</><br>\
<br>\
<b>2.</><br>\
Unzip the dictionary where you want. For example<br>\
<em>bunzip2 stardict-longman-2.4.2.tar.bz2</><br>\
then<br>\
<em>tar xvf stardict-longman-2.4.2.tar</><br>\
Pay attention you need all these files.<br>\
<br>\
<b>3.</><br>\
Optionally, download and unzip the english sound dictionary.<br>\
<em>https://sourceforge.net/projects/<br>\
dictsestardict/files/soundDictionary</><br>\
<br>\
<b>4.</><br>\
Configure the dictionaries from the GUI.<br>\
First icon on the left.\
")

#define BUTTON_OK i18n("OK")
#define SUGGESTED_WORD_FRAME_LABEL i18n("Suggested words")
#define SHOW_SUGGESTED_WORD i18n("Show suggested words")
#define YES i18n("Yes")
#define NO i18n("No")

#define DICTIONARIES_ICON "%s/images/crystalClear/dictionaries.png"
#define SETTINGS_ICON "%s/images/micro/settings.png"
#define SPEAKER_ICON "%s/images/crystalClear/speaker.png"
#define CLEAR_ICON "%s/images/crystalClear/clear.png"
#define SEARCH_ICON "%s/images/crystalClear/search.png"
#define FOLDER_ICON "%s/images/crystalClear/folder.png"
#define QUIT_ICON "%s/images/crystalClear/quit.png"
#define INFO_ICON "%s/images/crystalClear/info.png"
#define ADD_ICON "%s/images/crystalClear/edit_add.png"
#define REMOVE_ICON "%s/images/crystalClear/edit_remove.png"


/**** **
 * DATA STRUCTURES
 *******/

/****
 * METHODS
 ******/
Evas_Object* createMainWindow();

#endif