#ifndef _ESTARDICT_ENGINE_H
#define _ESTARDICT_ENGINE_H
/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
*    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License along
*    with this program; if not, write to the Free Software Foundation, Inc.,
*    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
*/
 /**
  * @file engine.h
  * @author Luca Vaudano
  */ 
/*********
 * HEADERS
 *********/
// GLIB
#include <glib.h>
#include <glib/gstdio.h>

// Standard GNU C
#include <string.h>

// Standard gzip support library
#include <zlib.h>

// For ntohl
#include <arpa/inet.h>

/******
 * DEFINITIONS
 ******/
 
 // Errors
typedef enum _ESTARDICT_ENGINE_ERROR {
    ESTARDICT_ENGINE_ERROR_NO_ERROR,
    ESTARDICT_ENGINE_ERROR_FIRST_LINE_IFO,
    ESTARDICT_ENGINE_ERROR_SECOND_LINE_IFO,
    ESTARDICT_ENGINE_ERROR_OPEN_DIRECTORY,
    ESTARDICT_ENGINE_ERROR_MANDATORY_FILES_NOT_PRESENT,
    ESTARDICT_ENGINE_ERROR_READING_IDX,
    ESTARDICT_ENGINE_ERROR_OPEN_IDX,
    ESTARDICT_ENGINE_ERROR_64BIT_DICTIONARY_NOT_SUPPORTED,
    ESTARDICT_ENGINE_ERROR_DICTIONARY_FORMAT_NOT_SUPPORTED,
    ESTARDICT_ENGINE_ERROR_MEMORY_ERROR_DEFINITION,
    ESTARDICT_ENGINE_ERROR_OPEN_DICT,
    ESTARDICT_ENGINE_ERROR_SEEKING_DICT,
    ESTARDICT_ENGINE_ERROR_READING_DICT,
    ESTARDICT_ENGINE_ERROR_PARSING_DEFINITION,
    ESTARDICT_ENGINE_ERROR_MEMORY_ERROR_INFO
} ESTARDICT_ENGINE_ERROR;

// Warnings
//#define ESTARDICT_ENGINE_WARNINGS_IDXSIZE_NO_MATCH 1
//#define ESTARDICT_ENGINE_WARNINGS_WORD_COUNT_NO_MATCH 2

typedef enum _ESTARDICT_ENGINE_WARNING {
    ESTARDICT_ENGINE_WARNINGS_IDXSIZE_NO_MATCH,
    ESTARDICT_ENGINE_WARNINGS_WORD_COUNT_NO_MATCH
} ESTARDICT_ENGINE_WARNING;

#define COORDINATES_BUFFER_LENGTH 64*1024
#define COORDINATES_BLOCK 270
#define _MIN(a,b)	((a)<(b))?(a):(b)

/**** **
 * DATA STRUCTURES
 *******/
/** StarDict info */
struct _StarDictInfo {
    
    // Path
    gchar* path;
    
    // Files info
	gchar* ifoFileName;
	gchar* idxFileName;
	gboolean idxCompressed;
	gchar* dictFileName;
	gboolean dictCompressed;
    FILE* idxFile;
    gzFile dictFile;
    
    // IFO info
	gchar* bookname;
	glong wordcount;
	glong idxfilesize;
    glong idxoffsetbits;
	gchar* sametypesequence;
    
    // Warnings, could be more than one
    GList* warnings;
};

typedef struct _StarDictInfo StarDictInfo;

/** Word list item for idx file*/
struct _WordCoordinates {
        glong offset; // not allowed idxoffsetbits=64
        glong size;
};
typedef struct _WordCoordinates WordCoordinates;

// Error
ESTARDICT_ENGINE_ERROR estardictEngineError;

/****
 * METHODS
 ******/
StarDictInfo* loadDictionary(gchar* path);
char* getDefinition(StarDictInfo* starDictInfo, gchar* word);
void freeData(StarDictInfo* starDictInfo);
GArray* getWordList(StarDictInfo* starDictInfo, gchar* prefix, gint maxNumSuggestedWords);

#endif
