#ifndef _ESTARDICT_GUI_LOGIC_H
#define _ESTARDICT_GUI_LOGIC_H
/*-*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
*    Copyright (C) 2009 Luca Vaudano vaudano@gmail.com
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License along
*    with this program; if not, write to the Free Software Foundation, Inc.,
*    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.Warning
*/
 /**
  * @file estardict-gui-logic.h
  * @author Luca Vaudano
  */
/*********
 * HEADERS
 *********/
// GLIB
#include <glib.h>
#include <stdlib.h>

/******
 * DEFINITIONS
 ******/
#define DIALOG_SELECT_DICTIONARY i18n("You have to select the dictionary directory.")
#define DIALOG_SELECT_SOUND_DICTIONARY i18n("You have to select a dictionary.<br>The directory should contain folders<br>a, b, c and so on.")
#define DIALOG_SELECT_PLAYER i18n("You have to select a executable file.")
#define DIALOG_MUST_SELECT_PLAYER i18n("You have to select the sound player.")
#define DIALOG_MUST_SELECT_SOUND_DICTIONARY i18n("You have to select the sound dictionary<br>directory.")
#define DIALOG_ERROR_PLAYING_FILE i18n("Error during playing the file...")
#define DIALOG_WORD_NOT_FOUND i18n("Word not found.")
#define DIALOG_ERROR_MEMORY i18n("Memory error.")
#define DIALOG_ERROR_OPEN_DICT_FILE i18n("Error open DICT file.")
#define DIALOG_ERROR_SEEKING_DICT_FILE i18n("Error seeking on DICT file.")
#define DIALOG_ERROR_READING_DICT_FILE i18n("Error reading DICT file.")
#define DIALOG_ERROR_PARSING_DEFINITION i18n("Error parsing definition.")
#define DIALOG_MUST_SELECT_DICTIONARY i18n("You have to set the dictionary directory.")
#define DIALOG_DICTIONARY_NOT_LOADED i18n("Dictionary not loaded.")
#define DIALOG_IFO_NOT_VALID i18n("IFO file has not valid format.")
#define DIALOG_NO_OPEN_DICTIONARY_DIR i18n("Cannot open dictionary directory.")
#define DIALOG_NO_MANDATORY_FILES i18n("Mandatory files not present.")
#define DIALOG_ERROR_READING_IDX_FILE i18n("Error reading IDX file.")
#define DIALOG_ERROR_OPEN_IDX_FILE i18n("Error open IDX file.")
#define DIALOG_DICTIONARY_NOT_SUPPORTED i18n("Dictionary format not supported yet.")
#define DIALOG_NO_64BIT_DICTIONARY i18n("eStarDict doesn't work with 64bit dictionary.")
#define DIALOG_ERROR_LOADING_DICTIONARY i18n("Error loading the dictionary.")
#define DIALOG_ERROR_LOADING_CONFIGURATION i18n("Error loading the configuration.")
#define DIALOG_ERROR_LOADING_PLAYER i18n("Error loading the player.")

// TODO put in the settings screen
#define MAX_NUMBER_SUGGESTED_WORDS 2

/**** **
 * DATA STRUCTURES
 *******/

/****
 * METHODS
 ******/
void destroy();
void promoteDefinitionPage();
void promoteDictionariesPage();
void promoteSettingsPage();
void promoteAboutPage();
void promoteFirstUsagePage();
void addDictionary(void *data, Evas_Object *obj, void *event_info);
void saveDictionaries(void *data, Evas_Object *obj, void *event_info);
void quitDictionaries(void *data, Evas_Object *obj, void *event_info);
void addSoundDictionary(void *data, Evas_Object *obj, void *event_info);
void addPlayer(void *data, Evas_Object *obj, void *event_info);
void savePlayer(void *data, Evas_Object *obj, void *event_info);
void speak(void *data, Evas_Object *obj, void *event_info);
void clearWord(void *data, Evas_Object *obj, void *event_info);
void searchWord(void *data, Evas_Object *obj, void *event_info);
void init();
void freeAllData();
void showSuggestedWords(void *data, Evas_Object *obj, void *event_info);
void suggestedWordToggleChanged(void *data, Evas_Object *obj, void *event_info);

#endif
