#ifndef _ESPEAKTIME_CONFIG_H
#define _ESPEAKTIME_CONFIG_H

#include <gconf/gconf-client.h>

struct espeaktime_settings {
	gchar *voice;
	gchar *effect;
	gchar *text;
	gint amplitude;
	gint pitch;
	gint speed;
	gboolean ignore_silent;
};

extern void cfg_read(GConfClient *client, struct espeaktime_settings *cfg);
extern void cfg_write(GConfClient *client, struct espeaktime_settings *cfg);
extern void cfg_speak(struct espeaktime_settings *cfg, gboolean test_mode);
extern void cfg_free(struct espeaktime_settings *cfg);

#endif

