/*
 * Play media file via gstreamer, optionally setting pulseaudio
 * properties on it.  Inspired by qwerty12's code from:
 * http://talk.maemo.org/showthread.php?t=50266&page=2
 */

#include <gst/gst.h>
#include <pulse/pulseaudio.h>
#include <pulse/glib-mainloop.h>

static GMainLoop *loop;
static GstElement *sound_player, *pulsesink;

static gboolean bus_call(GstBus *bus, GstMessage *msg, gpointer data)
{
	GMainLoop *loop = data;
	gchar *debug;
	GError *error;

	switch (GST_MESSAGE_TYPE(msg)) {
	case GST_MESSAGE_EOS:
		g_main_loop_quit(loop);
		break;
	case GST_MESSAGE_ERROR:
		gst_message_parse_error(msg, &error, &debug);
		g_free (debug);

		g_printerr("Error: %s\n", error->message);
		g_error_free(error);
		g_main_loop_quit(loop);
		break;
	default:
		break;
	}

	return TRUE;
}

int main(int argc, char *argv[])
{
	GstBus *bus;
	pa_proplist *proplist = NULL;

	if (argc < 2) {
		g_printerr("Usage: %s <uri> [<event-id>]\n", argv[0]);
		return 1;
	}

	gst_init(&argc, &argv);
	loop = g_main_loop_new(NULL, FALSE);

	if (argc > 2) {
		proplist = pa_proplist_new();
		pa_proplist_sets(proplist, PA_PROP_EVENT_ID, argv[2]);
		pa_proplist_sets(proplist, "module-stream-restore.id", "x-maemo-applet-profiles");
	}

	sound_player = gst_element_factory_make("playbin2", "eSpeakTime");
	pulsesink = gst_element_factory_make("pulsesink", NULL);
	if (proplist)
		g_object_set(G_OBJECT(pulsesink), "proplist", proplist, NULL);

	bus = gst_pipeline_get_bus(GST_PIPELINE(sound_player));
	gst_bus_add_watch(bus, bus_call, loop);
	gst_object_unref(bus);

	g_object_set(sound_player, "audio-sink", pulsesink, "uri", argv[1], NULL);
	gst_element_set_state(sound_player, GST_STATE_PLAYING);

	g_main_loop_run(loop);
	return 0;
}
