﻿# coding=utf-8
import hildon
import i18n
_ = i18n.language.gettext

class LangSelector(object):

	currentlang = ""
	
	def __init__(self):
	# Create a HildonTouchSelector with a single text column
	 self._lang_selector = hildon.TouchSelector(text = True)

	# Add items to the language selector control
	 self._lang_selector.append_text(_("eSpeakUI_Language_af"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_bs"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ca"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_cs"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_cy"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_de"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_el"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_en"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ensc"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_enuk"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_enuknorth"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_enukrp"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_enukwmids"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_enus"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_enwi"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_eo"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_es"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_esla"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_fi"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_fr"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_frbe"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_grc"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_hi"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_hr"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_hu"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_id"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_is"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_it"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ku"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_la"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_lv"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_mk"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_nci"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_nl"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_no"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_pap"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_pl"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_pt"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ptpt"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ro"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ru"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_sk"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_sr"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_sv"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_sw"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_ta"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_tr"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_vi"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_zh"))
	 self._lang_selector.append_text(_("eSpeakUI_Language_zhyue"))
	 self._lang_selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
	
	def getSelectorControl(self):
		return self._lang_selector

	# Define the method to be called when user selects an item
	def setLanguage(self,pickerBtnText):
	 languages = {
		_("eSpeakUI_Language_af"): self._setaf,
		_("eSpeakUI_Language_bs"): self._setbs,
		_("eSpeakUI_Language_ca"): self._setca,
		_("eSpeakUI_Language_cs"): self._setcs,
		_("eSpeakUI_Language_cy"): self._setcy,
		_("eSpeakUI_Language_de"): self._setde,
		_("eSpeakUI_Language_el"): self._setel,
		_("eSpeakUI_Language_en"): self._seten,
		_("eSpeakUI_Language_ensc"): self._setensc,
		_("eSpeakUI_Language_enuk"): self._setenuk,
		_("eSpeakUI_Language_enuknorth"): self._setenuknorth,
		_("eSpeakUI_Language_enukrp"): self._setenukrp,
		_("eSpeakUI_Language_enukwmids"): self._setenukwmids,
		_("eSpeakUI_Language_enus"): self._setenus,
		_("eSpeakUI_Language_enwi"): self._setenwi,
		_("eSpeakUI_Language_eo"): self._seteo,
		_("eSpeakUI_Language_es"): self._setes,
		_("eSpeakUI_Language_esla"): self._setesla,
		_("eSpeakUI_Language_fi"): self._setfi,
		_("eSpeakUI_Language_fr"): self._setfr,
		_("eSpeakUI_Language_frbe"): self._setfrbe,
		_("eSpeakUI_Language_grc"): self._setgrc,
		_("eSpeakUI_Language_hi"): self._sethi,
		_("eSpeakUI_Language_hr"): self._sethr,
		_("eSpeakUI_Language_hu"): self._sethu,
		_("eSpeakUI_Language_id"): self._setid,
		_("eSpeakUI_Language_is"): self._setis,
		_("eSpeakUI_Language_it"): self._setit,
		_("eSpeakUI_Language_ku"): self._setku,
		_("eSpeakUI_Language_la"): self._setla,
		_("eSpeakUI_Language_lv"): self._setlv,
		_("eSpeakUI_Language_mk"): self._setmk,
		_("eSpeakUI_Language_nci"): self._setnci,
		_("eSpeakUI_Language_nl"): self._setnl,
		_("eSpeakUI_Language_no"): self._setno,
		_("eSpeakUI_Language_pap"): self._setpap,
		_("eSpeakUI_Language_pl"): self._setpl,
		_("eSpeakUI_Language_pt"): self._setpt,
		_("eSpeakUI_Language_ptpt"): self._setptpt,
		_("eSpeakUI_Language_ro"): self._setro,
		_("eSpeakUI_Language_ru"): self._setru,
		_("eSpeakUI_Language_sk"): self._setsk,
		_("eSpeakUI_Language_sr"): self._setsr,
		_("eSpeakUI_Language_sv"): self._setsv,
		_("eSpeakUI_Language_sw"): self._setsw,
		_("eSpeakUI_Language_ta"): self._setta,
		_("eSpeakUI_Language_tr"): self._settr,
		_("eSpeakUI_Language_vi"): self._setvi,
		_("eSpeakUI_Language_zh"): self._setzh,
		_("eSpeakUI_Language_zhyue"): self._setzhyue
	 }
	 
	 languages.get(pickerBtnText,self._seten)() # set default language as English
	 return self._selectedLang

	# Based on the item selection, set the selectedLang property accordingly
	def _setaf(self):
	 	self._selectedLang = "af"
	def _setbs(self):
	 	self._selectedLang = "bs"
	def _setca(self):
	 	self._selectedLang = "ca"
	def _setcs(self):
	 	self._selectedLang = "cs"
	def _setcy(self):
	 	self._selectedLang = "cy"
	def _setde(self):
	 	self._selectedLang = "de"
	def _setel(self):
	 	self._selectedLang = "el"
	def _seten(self):
	 	self._selectedLang = "en"
	def _setensc(self):
	 	self._selectedLang = "en-sc"
	def _setenuk(self):
	 	self._selectedLang = "en-uk"
	def _setenuknorth(self):
	 	self._selectedLang = "en-uk-north"
	def _setenukrp(self):
	 	self._selectedLang = "en-uk-rp"
	def _setenukwmids(self):
	 	self._selectedLang = "en-uk-wmids"
	def _setenus(self):
	 	self._selectedLang = "en-us"
	def _setenwi(self):
	 	self._selectedLang = "en-wi"
	def _seteo(self):
	 	self._selectedLang = "eo"
	def _setes (self):
	 	self._selectedLang = "es "
	def _setesla(self):
	 	self._selectedLang = "es-la"
	def _setfi(self):
	 	self._selectedLang = "fi"
	def _setfr(self):
	 	self._selectedLang = "fr"
	def _setfrbe(self):
	 	self._selectedLang = "fr-be"
	def _setgrc(self):
	 	self._selectedLang = "grc"
	def _sethi(self):
	 	self._selectedLang = "hi"
	def _sethr(self):
	 	self._selectedLang = "hr"
	def _sethu(self):
	 	self._selectedLang = "hu"
	def _setid(self):
	 	self._selectedLang = "id"
	def _setis(self):
	 	self._selectedLang = "is"  
	def _setit(self):
	 	self._selectedLang = "it"
	def _setku(self):
	 	self._selectedLang = "ku"
	def _setla(self):
	 	self._selectedLang = "la"
	def _setlv(self):
	 	self._selectedLang = "lv"
	def _setmk(self):
	 	self._selectedLang = "mk" 
	def _setnci(self):
	 	self._selectedLang = "nci" 
	def _setnl(self):
	 	self._selectedLang = "nl"
	def _setno(self):
	 	self._selectedLang = "no"
	def _setpap(self):
	 	self._selectedLang = "pap"  
	def _setpl(self):
	 	self._selectedLang = "pl"
	def _setpt(self):
	 	self._selectedLang = "pt"
	def _setptpt(self):
	 	self._selectedLang = "pt-pt"
	def _setro(self):
	 	self._selectedLang = "ro"
	def _setru(self):
	 	self._selectedLang = "ru" 
	def _setsk(self):
	 	self._selectedLang = "sk"
	def _setsr(self):
	 	self._selectedLang = "sr"
	def _setsv(self):
	 	self._selectedLang = "sv"
	def _setsw(self):
	 	self._selectedLang = "sw"
	def _setta(self):
	 	self._selectedLang = "ta"
	def _settr(self):
	 	self._selectedLang = "tr"
	def _setvi(self):
	 	self._selectedLang = "vi" 
	def _setzh(self):
	 	self._selectedLang = "zh"
	def _setzhyue(self):
	 	self._selectedLang = "zh-yue"

	 