#!/usr/bin/env python
# coding=utf-8

# eSpeak GUI Client v0.1
# Author: Amanda Lam
# E-mail: amanda.hoic@gmail.com

# Import libraries
import sys
import gtk
import hildon
import os
import gettext
import i18n
import gobject
import string
import xml.dom.minidom
import xml.parsers.expat
# By using apt-cache search, the following packages are required:
# python2.5-gtk2, python2.5-hildon, python-gobject, python-xml,
# espeak, libespeak, espeak-data, espeak-extra-data

# Import methods from external library files
from portrait import FremantleRotation
from LangSelector import LangSelector
from AmpSelector import AmpSelector
from PitchSelector import PitchSelector
from SpeedSelector import SpeedSelector
from WordGapSelector import WordGapSelector

_ = i18n.language.gettext

textresult = ""

# The method that takes in the buttons as arguments for reading their final selected values, and then pass the actual arguments to espeak.
def speak(widget, LangPickerButton, LangSelectorObj, AmpPickerButton, PitchPickerButton, SpeedPickerButton, WordGapPickerButton):
 currentlang = LangSelectorObj.setLanguage(LangPickerButton.get_value())
 currentAmp = AmpPickerButton.get_value()
 currentPitch = PitchPickerButton.get_value()
 currentSpeed = SpeedPickerButton.get_value()
 currentWordGap = WordGapPickerButton.get_value()
 
 global textresult
 global isNowFullScreen
 
 textresult = textresult.replace("\"","").replace("'","").replace("\\","")
 espeakcmd = "espeak -v " + currentlang + " -a " + currentAmp + " -p " + currentPitch + " -s " + currentSpeed + " -g " + currentWordGap + " \"" + textresult + "\"" 
 print espeakcmd
 os.system(espeakcmd)

# The method that pastes text to the TextView control from the clipboard.
def pasteText(widget, TextArea, LangPickerButton, LangSelectorObj, AmpPickerButton, PitchPickerButton, SpeedPickerButton, WordGapPickerButton):
 clip = gtk.Clipboard()
 data = clip.wait_for_contents('UTF8_STRING')
 text = data.get_text()
 buffer = TextArea.get_buffer()
 buffer.set_text(buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter(), False) + text)
 TextArea.set_buffer(buffer)

 # The method that clears the TextView control content.
def clearText(widget, TextArea, LangPickerButton, LangSelectorObj, AmpPickerButton, PitchPickerButton, SpeedPickerButton, WordGapPickerButton): 
 text = ""
 buffer = TextArea.get_buffer()
 buffer.set_text(text)
 TextArea.set_buffer(buffer)
 
# The method that toggles between full screen mode and window mode, by setting a global variable value 
def fullScreen(FullScreenButton, window):
 global isNowFullScreen
 if isNowFullScreen == False:
   window.fullscreen()   
   isNowFullScreen = True
   RestoreImage = gtk.Image()
   RestoreImage.set_from_file("/opt/eSpeakGUI/Restore.png")
   RestoreImage.show()
   FullScreenButton.set_image(RestoreImage)
   FullScreenButton.show_all()   
 else:
	if isNowFullScreen == True:
		window.unfullscreen()		
		isNowFullScreen = False
		FullScreenImage = gtk.Image()
		FullScreenImage.set_from_file("/opt/eSpeakGUI/FullScreen.png")
		FullScreenImage.show()
		FullScreenButton.set_image(FullScreenImage)
		FullScreenButton.show_all()

# The method that opens a text file and displays its contents in the TextView control.
def openFile(OpenButton, window, textview):
 filename = None
# Alternative approach: use the traditional gtk.FileChooserDialog,
# but this will trade off the hildon look-and-feel
 
# fileChooser = gtk.FileChooserDialog("Open File", window,gtk.FILE_CHOOSER_ACTION_OPEN,(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
 fileChooser = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_OPEN)
        
 response = fileChooser.run()
 if response == gtk.RESPONSE_OK: filename = fileChooser.get_filename()
 
 fileChooser.destroy()        

 try:
	# get the file contents
	fin = open(filename, "r")
	text = fin.read()
	fin.close()
            
	# disable the text view while loading the buffer with the text
	textview.set_sensitive(False)
	buffer = textview.get_buffer()
	buffer.set_text(text)
	textview.set_sensitive(True)
                      
 except:
    # error loading file, show message to user    
	dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window, _("eSpeakGUI_OpenFileFailed") + filename ) 
	response = dialog.run()
	dialog.destroy()	

# The method that displays the Save file dialog and then calls the espeak -w option to export the speech output to the filename specified in the save file dialog
def saveAsWav(widget, TextArea, LangPickerButton, LangSelectorObj, AmpPickerButton, PitchPickerButton, SpeedPickerButton, WordGapPickerButton):
 filename = None
 fileChooser = gobject.new(hildon.FileChooserDialog, action=gtk.FILE_CHOOSER_ACTION_SAVE)        
 response = fileChooser.run()
 if response == gtk.RESPONSE_OK: filename = fileChooser.get_filename() 
 fileChooser.destroy()        
 
 if filename != None:
	currentlang = LangSelectorObj.setLanguage(LangPickerButton.get_value())
	currentAmp = AmpPickerButton.get_value()
	currentPitch = PitchPickerButton.get_value()
	currentSpeed = SpeedPickerButton.get_value()
	currentWordGap = WordGapPickerButton.get_value()
 
	global textresult
	textresult = textresult.replace("\"","").replace("'","").replace("\\","")
	espeakcmd = "espeak -v " + currentlang + " -a " + currentAmp + " -p " + currentPitch + " -s " + currentSpeed + " -g " + currentWordGap + " -w " + filename + ".wav \"" + textresult + "\"" 
	print espeakcmd
	os.system(espeakcmd)

# This method displays the about dialog.
def aboutProduct(AboutButton,window):
 dialog = hildon.Note(hildon.NOTE_TYPE_INFORMATION_THEME, window,_("eSpeakGUI_AboutProduct") ) 
 response = dialog.run()
 dialog.destroy()

# This method returns a default setting XML string
def getDefaultSettingsXML():
 defaultSettingsXML = "<?xml version=\"1.0\"?><Settings><LanguageText>" + _("eSpeakGUI_DefaultLanguageText") + "</LanguageText><LanguageSelectedIndex>7</LanguageSelectedIndex><Amplitude>100</Amplitude><Pitch>50</Pitch><Speed>170</Speed><WordGap>10</WordGap></Settings>"
 return defaultSettingsXML

# This method writes the default settings to the actual XML file
def writeDefaultSettingsXML():
 settingsDOM = xml.dom.minidom.parseString(getDefaultSettingsXML())
 settingsFile = open("/home/user/MyDocs/.eSpeakGUI/settings.xml", "w")
 settingsFile.write(settingsDOM.toxml("UTF-8"))
 settingsFile.close()

# This method writes the currently selected settings to the actual XML file 
def writeSettingsXML(window,LanguageText, LanguageSelectedIndex, Amplitude, Pitch, Speed, WordGap):
 SettingsXML = "<?xml version=\"1.0\"?><Settings><LanguageText>" + LanguageText +"</LanguageText><LanguageSelectedIndex>" + str(LanguageSelectedIndex) + "</LanguageSelectedIndex><Amplitude>" + str(Amplitude) + "</Amplitude><Pitch>" + str(Pitch) + "</Pitch><Speed>" + str(Speed) + "</Speed><WordGap>" + str(WordGap) + "</WordGap></Settings>" 
 settingsFile = open("/home/user/MyDocs/.eSpeakGUI/settings.xml", "w")
 settingsFile.write(SettingsXML)
 settingsFile.close() 

# This method is called when program exits. It writes the currently selected settings to the actual XML file then quit the program.
def writeSettingsAndQuit(window, window2, LangPickerButton, LangSelector, AmpPickerButton, PitchPickerButton, SpeedPickerButton, WordGapPickerButton):  
 writeSettingsXML(window, LangPickerButton.get_value(), str(LangSelector.get_active(0)), str(AmpPickerButton.get_value()), str(PitchPickerButton.get_value()), str(SpeedPickerButton.get_value()), str(WordGapPickerButton.get_value())) 
 gtk.main_quit(None)

# This method takes in the setting XML DOM object and the name of a node, and then returns the value of that node.
def getKeyValue(settingsDOM, key):
 returnValue = ""
 for node in settingsDOM.getElementsByTagName(key)[0].childNodes:
  if node.nodeType == node.TEXT_NODE:
   returnValue = returnValue + node.data
 return returnValue
 
# This method creates the program menu and defines its buttons. 
def create_menu(window, textview):
 menu = hildon.AppMenu()   
 OpenButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
 OpenButton.set_label(_("eSpeakGUI_OpenButtonLabel"))   
 OpenButton.connect("clicked", openFile, window, textview)   
 
 AboutButton = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
 AboutButton.set_label(_("eSpeakGUI_AboutProductButtonLabel"))   
 AboutButton.connect("clicked", aboutProduct, window)    

 menu.append(OpenButton)   
 menu.append(AboutButton)   
 menu.show_all()
 return menu

# This method is called whether the text in TextView control changes, and assign the text in TextView to the textresult global variable for later manipulation.
def text_changed(buffer):
 start = buffer.get_start_iter()   
 end = buffer.get_end_iter() 
 global textresult
 textresult = buffer.get_text(start, end, False) 

# This method creates a directory for the settings file under MyDocs/ , or returns true if it is already created
def makedir(dirname):
 if os.path.isdir(dirname):
  return True
 elif os.path.isfile(dirname):
  return False
 else:
  head, tail = os.path.split(dirname)
  if head and not os.path.isdir(head):
    makedir(head)
  if tail:
    os.mkdir(dirname)
  return True

# This method is called when the program starts. It defines all the visible controls of the program, their correlated events and event handlers etc.  
def main():
# Get an instance of HildonProgram. It is an object used to represent an
# application running in the Hildon framework.
 program = hildon.Program.get_instance()
 try:
	if makedir('/home/user/MyDocs/.eSpeakGUI') == True:
		settingsDOM = xml.dom.minidom.parse('/home/user/MyDocs/.eSpeakGUI/settings.xml') # parse the settings XML and returns the XML DOM object	
 except xml.parsers.expat.ExpatError: # displays error message in case of parse error
	writeDefaultSettingsXML()
	settingsDOM = xml.dom.minidom.parseString(getDefaultSettingsXML())
 except IOError: # displays error message in case of file I/O error
	writeDefaultSettingsXML()
	settingsDOM = xml.dom.minidom.parseString(getDefaultSettingsXML())
 
# Create a new hildon stackable window
 window = hildon.StackableWindow()
 scrolledwindow = gtk.ScrolledWindow(hadjustment=None, vadjustment=None)
 
 main_window = window
 app_name = _("eSpeakGUI_ApplicationName")
 app_version = "1.0"
 
# Support Portrait Mode, adopting gPodder's code
 initial_mode = FremantleRotation.AUTOMATIC
 rotation_object = FremantleRotation(app_name, main_window, app_version, initial_mode)

# Registers a window as belonging to the program.
 program.add_window(window)

# Define the vibile buttons of the program.
 speakButton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, _("eSpeakGUI_SpeakButtonLabel"))
 pasteTextButton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, _("eSpeakGUI_PasteTextButtonLabel"))
 clearTextButton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, _("eSpeakGUI_ClearTextButtonLabel"))
 saveAsWavButton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, _("eSpeakGUI_SaveAsWavButtonLabel"))
 FullScreenButton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "")
 imageButton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "")
 global isNowFullScreen
 isNowFullScreen = False
   
 # Create a horizontal box.
 hbox = gtk.HBox(False, 0)  

 # Create language selector object and control
 LangSelectorObj = LangSelector()
 lang_selector = LangSelectorObj.getSelectorControl()
  
 # Create picker button that takes the language selector object
 lang_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)     
 lang_selector.set_active(0,string.atoi(getKeyValue(settingsDOM,"LanguageSelectedIndex")))
 lang_picker_button.set_selector(lang_selector)   
 lang_picker_button.set_text(_("eSpeakGUI_LangPickerButtonLabel"),getKeyValue(settingsDOM, "LanguageText"))
 hbox.pack_start(lang_picker_button, True, True, 0)

# Create amplitude selector object and control 
 AmpSelectorObj = AmpSelector()
 amp_selector = AmpSelectorObj.getSelectorControl()
 
# Create picker button that takes the amplitude selector object
 amp_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)    
 amp_selector.set_active(0,string.atoi(getKeyValue(settingsDOM, "Amplitude")))
 amp_picker_button.set_selector(amp_selector)    
 amp_picker_button.set_text(_("eSpeakGUI_AmplitudeButtonLabel"),getKeyValue(settingsDOM, "Amplitude"))  
 hbox.pack_start(amp_picker_button, True, True, 0) 

# Create pitch selector object and control 
 PitchSelectorObj = PitchSelector()
 pitch_selector = PitchSelectorObj.getSelectorControl()
 
# Create picker button that takes the pitch selector object
 pitch_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)    
 pitch_selector.set_active(0,string.atoi(getKeyValue(settingsDOM, "Pitch")))
 pitch_picker_button.set_selector(pitch_selector)   
 pitch_picker_button.set_text(_("eSpeakGUI_PitchButtonLabel"),getKeyValue(settingsDOM, "Pitch")) 
 hbox.pack_start(pitch_picker_button, False, False, 0) 
 
# Create speed selector object and control 
 SpeedSelectorObj = SpeedSelector()
 speed_selector = SpeedSelectorObj.getSelectorControl()
 
# Create picker button that takes the speed selector object
 speed_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)    
 speed_selector.set_active(0,string.atoi(getKeyValue(settingsDOM, "Speed"))-80)
 speed_picker_button.set_selector(speed_selector)    
 speed_picker_button.set_text(_("eSpeakGUI_SpeedButtonLabel"),getKeyValue(settingsDOM, "Speed")) 
 hbox.pack_start(speed_picker_button, True, True, 0)  
 vbox = gtk.VBox(False, 0)
 vbox.pack_start(hbox, False, False, 0)

# Create word gap selector object and control 
 WordGapSelectorObj = WordGapSelector()
 wordgap_selector = WordGapSelectorObj.getSelectorControl()
 
# Create word gap button that takes the speed selector object
 wordgap_picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)    
 wordgap_selector.set_active(0,string.atoi(getKeyValue(settingsDOM, "WordGap")))
 wordgap_picker_button.set_selector(wordgap_selector)   
 wordgap_picker_button.set_text(_("eSpeakGUI_WordGapButtonLabel"),getKeyValue(settingsDOM, "WordGap")) 
 hbox.pack_start(wordgap_picker_button, True, True, 0)  
 hbox.pack_start(FullScreenButton, True, True, 0) 

# Define eSpeak icon button 
 eSpeakImage = gtk.Image()
 eSpeakImage.set_from_file("/opt/eSpeakGUI/eSpeakGUI.png")
 eSpeakImage.show()
 imageButton.set_image(eSpeakImage)
 imageButton.show_all()
 hbox.pack_start(imageButton, True, True, 0) 

# Define Full Screen button 
 FullScreenImage = gtk.Image()
 FullScreenImage.set_from_file("/opt/eSpeakGUI/FullScreen.png")
 FullScreenImage.show()
 FullScreenButton.set_image(FullScreenImage)
 FullScreenButton.show_all()

# Define TextView 
 textview = hildon.TextView() 
 textview.set_placeholder("")
 textview.set_wrap_mode(gtk.WRAP_CHAR)
 buffer = textview.get_buffer() 
 buffer.connect("changed",text_changed)
 scrolledwindow.add(textview) 
 
 hbox2 = gtk.HBox(False, 0)  
 hbox2.pack_start(scrolledwindow, True, True, 0)

# Define vertical box for action buttons 
 vbox2 = gtk.VBox(True ,0)
 vbox2.pack_start(pasteTextButton, True, True, 0)
 vbox2.pack_start(clearTextButton, True, True, 0)
 vbox2.pack_start(saveAsWavButton, True, True, 0)
 vbox2.pack_start(speakButton, True, True, 0)
 hbox2.pack_start(vbox2, False, False, 0) 
 
 vbox.pack_start(hbox2, True, True, 0) 
 
 window.set_title(_("eSpeakGUI_ApplicationName")) 
 window.add(vbox)
 
# Define the button events and their handlers.
 
 speakButton.connect("clicked", speak, lang_picker_button, LangSelectorObj, amp_picker_button, pitch_picker_button, speed_picker_button, wordgap_picker_button)
 pasteTextButton.connect("clicked", pasteText, textview, lang_picker_button, LangSelectorObj, amp_picker_button, pitch_picker_button, speed_picker_button, wordgap_picker_button)
 clearTextButton.connect("clicked", clearText, textview, lang_picker_button, LangSelectorObj, amp_picker_button, pitch_picker_button, speed_picker_button, wordgap_picker_button) 
 saveAsWavButton.connect("clicked", saveAsWav, textview, lang_picker_button, LangSelectorObj, amp_picker_button, pitch_picker_button, speed_picker_button, wordgap_picker_button) 
 FullScreenButton.connect("clicked", fullScreen, window)
 imageButton.connect("clicked", aboutProduct, window)
 
# When the window is given the "delete_event" signal (this is given by the
# window manager, usually by the "close" option, or on the titlebar), we
# ask it to call the delete_event () function as defined above.

 window.connect("delete_event",writeSettingsAndQuit,lang_picker_button, lang_selector, amp_picker_button, pitch_picker_button, speed_picker_button, wordgap_picker_button)
 
 menu = create_menu(window, textview)
 
 window.set_app_menu(menu)

# The final step is to display this newly created widget and all widgets it
# contains.
 window.show_all() 
 
# All GTK+ applications must have a gtk_main(). Control ends here and waits
# for an event to occur (like a key press or mouse event).
 gtk.main()
 if settingsDOM != None: settingsDOM.unlink()

if __name__ == "__main__":
 main()
 

