#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Found this one from:
# http://wiki.maemo.org/PyMaemo/Accessing_APIs_without_Python_bindings/More_examples

import sys
import gtk
import ctypes
import osso

class Contacts:
    def __init__(self):
        programname = "eSpeakCaller"
        osso_ctx = osso.Context(programname, "0.1")
        self.osso_abook = ctypes.CDLL('libosso-abook-1.0.so.0')
        self.glib = ctypes.CDLL('libglib-2.0.so.0')
        self.osso_abook.osso_abook_init_with_name(programname, hash(osso_ctx))
        self.ebook = ctypes.CDLL('libebook-1.2.so.5')
        err = ctypes.c_void_p()
        self.c_book = self.ebook.e_book_new_default_addressbook(ctypes.byref(err)) 
        if not self.ebook.e_book_open(self.c_book, 1, 0):
            raise "Couldn't load addressbook."   
                     
    # New function to get name based on number (0.7)
    # Now the code gets reeeeaaally ugly :b
    def get_name_from_number(self, number):
        if (len(number) == 0) :
            return "%blocked%"
        

        err = ctypes.c_void_p()
        
        # fuzzy search enabled to allow partial matches (refer to documentation)
        # http://maemo.org/api_refs/5.0/5.0-final/libosso-abook/libosso-abook-osso-abook-util.html#osso-abook-query-phone-number
        c_query = self.osso_abook.osso_abook_query_phone_number(number, 1)
        
        contacts = ctypes.c_void_p()
        if not self.ebook.e_book_get_contacts(self.c_book, c_query, ctypes.byref(contacts), err):
            raise "Couldn't get query results."
            return "%number%"
        
        #print "Contact with phone number %s:" % number
        ## http://maemo.org/api_refs/5.0/5.0-final/libebook/EContact.html#EContactField
        e_contact_get_const = self.ebook.e_contact_get_const
        e_contact_get_const.restype = ctypes.c_char_p        
        
        for i in self.glist(contacts):
            fname = e_contact_get_const(i, 4)
            if fname == None: fname = ""     
            tmpNick = e_contact_get_const(i, 7)
            if tmpNick == None: tmpNick = ""  
            tmpFName = e_contact_get_const(i, 5)
            if tmpFName == None: tmpFName = ""    
            tmpLName = e_contact_get_const(i, 6)
            if tmpLName == None: tmpLName = "" 
            tmpId = e_contact_get_const(i, 1)
            if tmpId == None: tmpId = ""
            
            if fname == "" and (tmpFName != "" or tmpLName != ""):
                fname = (tmpFName + " " + tmpLName).strip()
            
            if fname != "":
                self.glib.g_list_free(contacts)
                return [fname.decode("utf-8"), tmpFName.decode("utf-8"), tmpLName.decode("utf-8"), tmpNick.decode("utf-8"), tmpId]
    
        #print "No contacts found with phone number %s." % number
    
        self.glib.g_list_free(contacts)
        return "%number%" 
        
    
    def getContactNamesAndIds(self):
    
        c_query = self.ebook.e_book_query_any_field_contains("") # Find all names
        err = ctypes.c_void_p()
        
        contacts = ctypes.c_void_p()
        if not self.ebook.e_book_get_contacts(self.c_book, c_query, ctypes.byref(contacts), err):
            raise "Couldn't get query results."
        
        #print "Contacts found:"
        names = []
        
         ## http://maemo.org/api_refs/5.0/5.0-final/libebook/EContact.html#EContactField
        E_CONTACT_UID = 1              
        E_CONTACT_FULL_NAME = 4       
        E_CONTACT_GIVEN_NAME = 5       
        E_CONTACT_FAMILY_NAME = 6      
        E_CONTACT_NICKNAME = 7         
        E_CONTACT_PHONE_PRIMARY = 31
        e_contact_get_const = self.ebook.e_contact_get_const
        e_contact_get_const.restype = ctypes.c_char_p
        
        for i in self.glist(contacts):
            fname = e_contact_get_const(i, E_CONTACT_FULL_NAME)
            if fname == None: fname = ""
            tmpNick = e_contact_get_const(i, E_CONTACT_NICKNAME)
            if tmpNick == None: tmpNick = ""
            tmpFName = e_contact_get_const(i, E_CONTACT_GIVEN_NAME)
            if tmpFName == None: tmpFName = ""
            tmpLName = e_contact_get_const(i, E_CONTACT_FAMILY_NAME)
            if tmpLName == None: tmpLName = ""
            tmpId = e_contact_get_const(i, E_CONTACT_UID)
            if tmpLName == None: tmpLName = ""
            #tmpNo = e_contact_get_const(i, E_CONTACT_PHONE_PRIMARY)
            #if tmpNo == None: tmpNo = ""
            #print tmpNo
            if fname == "" and (tmpFName != "" or tmpLName != ""):
                fname = (tmpFName + " " + tmpLName).strip()
                
            if fname != "": 
                names.append([fname.decode("utf-8"), tmpId, "0123456789", tmpFName.decode("utf-8"), tmpLName.decode("utf-8"), tmpNick.decode("utf-8")])
        
        self.glib.g_list_free(contacts)
        return names
        
    
    
    def glist(self, addr):
        """ Implementation of GList. """
        size = self.glib.g_list_length(addr)
        class _GList(ctypes.Structure):
            _fields_ = [('data', ctypes.c_void_p)]
        for i in xrange(0, size):
            item = self.glib.g_list_nth(addr, i)
            yield _GList.from_address(item).data
          
# Daaamn I feel kinda dirty right now...

if __name__ == "__main__":
    #getContactNamesAndIds()
    import time
    t1 = time.clock()
    a = Contacts()
    print time.clock() - t1
    
    t1 = time.clock()
    #print a.getContactNamesAndIds()
    print a.get_name_from_number(str("563"))
    print time.clock() - t1
    