#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import time
import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
import sys
import os.path
import subprocess
import logging
import espeakcaller_contacts

cfgFileLoc = "~/.espeakcaller/"
cfgGeneral = "espeakcaller_general.conf"
cfgUnknown = "espeakcaller_unknown.conf"
cfgBlocked = "espeakcaller_blocked.conf"
cfgGlobal = "espeakcaller_global.conf"
_HEADPHONE_SYS = "/sys/devices/platform/gpio-switch/headphone/state"

class eSpeakCallerDaemon():
    def __init__(self):
        LogPath = os.path.expanduser(cfgFileLoc + "espeakcaller.log")
        logging.basicConfig(filename=LogPath,filemode='w',level=logging.DEBUG)
        self.logger = logging.getLogger('eSpeakCaller')
        self.contacts = espeakcaller_contacts.Contacts()
        self.incomingnumber = ""
        
        bus = dbus.SystemBus()
        sbus = dbus.SessionBus()
        
        bus.add_signal_receiver(self.handle_call, path='/com/nokia/csd/call', dbus_interface='com.nokia.csd.Call', signal_name='Coming')
        bus.add_signal_receiver(self.call_status, path=None, dbus_interface='com.nokia.csd.Call.Instance', signal_name='CallStatus')
        bus.add_signal_receiver(self.headset_state, path=None, dbus_interface='org.bluez.Headset', signal_name='PropertyChanged')
        
        self.bt_headset_connected = 0
        
    def Log(self, logText):
        #print logText
        self.logger.debug(logText)
            
    # Added: (0.8) Bluetooth headset support :)
    def headset_state(self,signal,state):
        if signal == 'State':
            if state == 'connected':
                self.bt_headset_connected = 1
            elif state == 'disconnected':
                self.bt_headset_connected = 0
                        
    #Check if headphones are connected.
    def headphones(self):
        self.loadsettings("global")
        if self.silenceSpeakers == 0:
            return False
        

        if self.bt_headset_connected == 1:
            return True
        
        HeadphoneSys = open(_HEADPHONE_SYS, "r")
        state = HeadphoneSys.read().strip()
        HeadphoneSys.close
        if (state == "disconnected"):
            return False
    
        elif (state == "connected"):
            return True
    
    #Run mixer command.
    def _amixer(self, name, value):
        #print "mixer", name, value
        os.system("amixer -Dhw:0 cset iface=MIXER,name='%s' %s >/dev/null" % (name, value))
        
        
    # Incoming phonecall...
    def handle_call(self, obj_path, callernumber):
        self.Log("Incoming phonecall from number: " + callernumber)
        self.incomingnumber = callernumber
        #print "Incoming call: " + callernumber
        
    def get_espeak_command(self, callernumber):
        try:    
            CallerNames = self.contacts.get_name_from_number(str(callernumber))
            eSpeakText = ""
            
            if CallerNames == "%number%": # Number not in phonebook :(
                self.Log("Number not found in phonebook")
                self.loadsettings("unknown")
                if self.Enabled == 1:
                    # Split numbers. Possible fix for
                    # "Phonenumber is over nine thouuusaaaannnddd!!!"-bug
                    tmpNum = " ".join(list(callernumber))
                    tmpNum = tmpNum.replace("(","")
                    tmpNum = tmpNum.replace(")","")    
                    eSpeakText = self.sayName.replace("%number%", tmpNum)
            elif CallerNames == "%blocked%": # Number withheld. Probably phonesalesdude.
                    self.Log("Number is private/witheld")
                    self.loadsettings("blocked")
                    if self.Enabled == 1:           
                        eSpeakText =  self.sayName
            else: #we got lucky and found name from phonebook :)
                self.Log("Found name: " + CallerNames[0])
                self.loadsettings(str(CallerNames[4]))
                if self.Enabled == 1:
                    if self.sayName.find("%nick%") != -1 and CallerNames[3] != "":  # Use nickname if available and wanted.
                        eSpeakText = self.sayName.replace("%nick%", CallerNames[3])
                        eSpeakText = eSpeakText.replace("%name%", "")
                        eSpeakText = eSpeakText.replace("%first%", "")
                        eSpeakText = eSpeakText.replace("%last%", "")
                    else: 
                        eSpeakText = self.sayName.replace("%name%", CallerNames[0])
                        eSpeakText = eSpeakText.replace("%nick%", "")            
                        eSpeakText = eSpeakText.replace("%first%", CallerNames[1])
                        eSpeakText = eSpeakText.replace("%last%", CallerNames[2])      
            
            if eSpeakText != "":
                # Added (0.4): Repeat option. (just quick hack really, but seems to do the trick)
                self.Log("Say text: " + eSpeakText)
                
                eSpeakText = (eSpeakText + '<break time="' + str(self.repeatTime) + 's"/>') * self.repeatCount 
                
                #eSpeakText = '<break time="2s"/>' + eSpeakText       
                return self.myCommand.replace("%text%", eSpeakText).encode("utf-8")
            
            return ""
        except Exception, err:
            self.logger.exception("Error in handle_call()")
            return ""
        
    
    # Check profile in use.
    def get_profile(self):
        bus = dbus.SessionBus()
        profiled = bus.get_object('com.nokia.profiled', '/com/nokia/profiled')
        return profiled.get_profile(dbus_interface='com.nokia.profiled')
    
    # Fixed: (0.5) "eSpeak starts shouting things after end ring"-bug
    # Do things based on call status.
    def call_status(self,state,ukn1,ukn2):
        self.Log("state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2))
        #print "state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2)
        try:                       
            if state == 5: # STATUS_MT_ALERTING
                # Added: (0.6) Silence speakers if using headphones (dirty hack?)
                if self.headphones(): 
                    self.Log("Using headphones. Disabling speakers")
                    self._amixer("Speaker Function", "0")
                    
                eSpeakCommand = self.get_espeak_command(self.incomingnumber)   
                if eSpeakCommand != "":
                    
                    #Fixed: (0.6) Be quiet when in silent profile. :)
                    if self.get_profile() != "silent":
                        self.Log("Calling eSpeak. Command: " + eSpeakCommand)
                        import shlex
                        args = shlex.split(eSpeakCommand)
                        self.eSpeakProc = subprocess.Popen(args, shell=False)
                        self.StartMonitor()    

            elif state == 10 or state == 15 or state == 7 or state == 9 or state == 0: # STATUS_TERMINATED or STATUS_ANSWERED
                self.StopMonitor()
                self.incomingnumber = ""
                if self.eSpeakProc != 0:
                    subprocess.Popen("kill " + str(self.eSpeakProc.pid), shell=True)
                    self.eSpeakProc = 0
        except Exception, err:
            self.logger.exception("Error in call_status()")
            pass
    
    # Load settings for selected contact.
    def loadsettings(self,contact):
        try:    
            import codecs
            if contact == "unknown":
                cfgTmp = cfgFileLoc + cfgUnknown
            elif contact == "blocked":
                cfgTmp = cfgFileLoc + cfgBlocked
            elif contact == "global":
                cfgTmp = cfgFileLoc + cfgGlobal
            else:
                cfgTmp = cfgFileLoc + contact + ".conf"
                if not os.path.exists(os.path.expanduser(cfgTmp)):
                    #print "notfound " + cfgTmp
                    cfgTmp = cfgFileLoc + cfgGeneral 
                    
            cfgTmp = os.path.expanduser(cfgTmp)
                   
            if os.path.exists(cfgTmp): 
                self.Log("Loading config: " + cfgTmp)
         
                pdFile = codecs.open(cfgTmp, 'r','utf-8')
                lines = pdFile.readlines()
                pdFile.close()
                
		global silenceSpeakers

                for line in lines:
                    line = line.strip()
                    if line.startswith("eSpeak:"):
                        self.myCommand = line.split(":")[1]
                    elif line.startswith("Enabled:"):
                        self.Enabled = int(line.split(":")[1])   
                    elif line.startswith("Say:"):
                        self.sayName = line.split(":")[1]
                    elif line.startswith("Nick:"):
                        self.useNickname = int(line.split(":")[1])
                    elif line.startswith("Repeat:"):
                        if line.split(":")[1] == "1":
                            self.repeatCount = 5
                        else:
                            self.repeatCount = 1
                    elif line.startswith("RepeatCount:"):
                        self.repeatCount = int(line.split(":")[1])
                    elif line.startswith("Repeattime:"):
                        self.repeatTime = int(line.split(":")[1])
                    elif line.startswith("Silence:"):
                        self.silenceSpeakers = int(line.split(":")[1]) 
                                                       
        except Exception, err:
            logger.exception("Error in loadsettings()")
            pass
            
            
    # Fixed (0.7): Possible fix for "eSpeak is yelling after mute button has been pressed."-bug
    #              Reeeaaally dirty hack :b I still haven't found any real way to do this :(
    def StartMonitor(self):
        try:
            bus = dbus.SessionBus()
            bus.add_match_string("")
            bus.add_message_filter(self.msg_filter)
        except:
            pass
    def StopMonitor(self):
        try:
            bus = dbus.SessionBus()
            bus.remove_message_filter(self.msg_filter)
            bus.remove_match_string("")              
        except:
            pass
    def msg_filter(self,abus, msg):
        try:
            args = msg.get_args_list()
            dest = msg.get_destination()
            mem = msg.get_member()
            
            if dest == "org.maemo.Playback.Manager" and mem == "RequestState":
                if args[1] == "Stop":
		    global eSpeakProc
                    #print "Stop event!"
                    if self.eSpeakProc != 0:   
                        self.Log("Mute pressed. Killing espeak.")
                        subprocess.Popen("kill " + str(self.eSpeakProc.pid), shell=True)
                        self.eSpeakProc = 0
        except Exception, e:
            self.logger.exception("Error in msg_filter()")
        
         
    
# def Main
DBusGMainLoop(set_as_default=True)
daemon = eSpeakCallerDaemon()
gobject.MainLoop().run()

