#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Found this one from:
# http://wiki.maemo.org/PyMaemo/Accessing_APIs_without_Python_bindings/More_examples

import sys
import gtk
import ctypes
import osso

# New function to get name based on number (0.7)
# Now the code gets reeeeaaally ugly :b
def get_name_from_number(number):
    if (len(number) == 0) :
        return "%blocked%"
    
    programname = "eSpeakCaller"
    osso_ctx = osso.Context(programname, "0.1")
    osso_abook = ctypes.CDLL('libosso-abook-1.0.so.0')
    glib = ctypes.CDLL('libglib-2.0.so.0')
    osso_abook.osso_abook_init_with_name(programname, hash(osso_ctx))
    err = ctypes.c_void_p()
    
    
    ebook = ctypes.CDLL('libebook-1.2.so.5')

    c_book = ebook.e_book_new_default_addressbook(ctypes.byref(err)) 

    if not ebook.e_book_open(c_book, 1, 0):
        raise "Couldn't load addressbook."
        return "%number%"

    # fuzzy search enabled to allow partial matches (refer to documentation)
    c_query = osso_abook.osso_abook_query_phone_number(number, 1)
    
    contacts = ctypes.c_void_p()
    if not ebook.e_book_get_contacts(c_book, c_query, ctypes.byref(contacts), err):
        raise "Couldn't get query results."
        return "%number%"
    
    
    for i in glist(glib, contacts):
        #print "Contact with phone number %s:" % number
        ## http://maemo.org/api_refs/5.0/5.0-final/libebook/EContact.html#EContactField
        e_contact_get_const = ebook.e_contact_get_const
        e_contact_get_const.restype = ctypes.c_char_p
        
        fname = e_contact_get_const(i, 4)
        if fname == None: fname = ""     
        tmpNick = e_contact_get_const(i, 7)
        if tmpNick == None: tmpNick = ""  
        tmpFName = e_contact_get_const(i, 5)
        if tmpFName == None: tmpFName = ""    
        tmpLName = e_contact_get_const(i, 6)
        if tmpLName == None: tmpLName = "" 
        tmpId = e_contact_get_const(i, 1)
        if tmpId == None: tmpId = ""
        
        if fname == "" and (tmpFName != "" or tmpLName != ""):
            fname = (tmpFName + " " + tmpLName).strip()
        
        if fname != "":
            glib.g_list_free(contacts)
            return [fname.decode("utf-8"), tmpFName.decode("utf-8"), tmpLName.decode("utf-8"), tmpNick.decode("utf-8"), tmpId]

    #print "No contacts found with phone number %s." % number
    glib.g_list_free(contacts)
    return "%number%" 
    

def getContactNamesAndIds():
    programname = "eSpeakCaller"

    ebook = ctypes.CDLL('libebook-1.2.so.5')
    glib = ctypes.CDLL('libglib-2.0.so.0')
    err = ctypes.c_void_p()
    c_book = ebook.e_book_new_default_addressbook(ctypes.byref(err)) 

    if not ebook.e_book_open(c_book, 1, 0):
        raise "Couldn't load addressbook."

    c_query = ebook.e_book_query_any_field_contains("")
    
    contacts = ctypes.c_void_p()
    if not ebook.e_book_get_contacts(c_book, c_query, ctypes.byref(contacts), err):
        raise "Couldn't get query results."
    
    #print "Contacts found:"
    names = []
    
    for i in glist(glib, contacts):
        ## http://maemo.org/api_refs/5.0/5.0-final/libebook/EContact.html#EContactField
        E_CONTACT_UID = 1              
        E_CONTACT_FULL_NAME = 4       
        E_CONTACT_GIVEN_NAME = 5       
        E_CONTACT_FAMILY_NAME = 6      
        E_CONTACT_NICKNAME = 7         
        E_CONTACT_PHONE_PRIMARY = 31
        e_contact_get_const = ebook.e_contact_get_const
        e_contact_get_const.restype = ctypes.c_char_p
        
        fname = e_contact_get_const(i, E_CONTACT_FULL_NAME)
        if fname == None: fname = ""
        tmpNick = e_contact_get_const(i, E_CONTACT_NICKNAME)
        if tmpNick == None: tmpNick = ""
        tmpFName = e_contact_get_const(i, E_CONTACT_GIVEN_NAME)
        if tmpFName == None: tmpFName = ""
        tmpLName = e_contact_get_const(i, E_CONTACT_FAMILY_NAME)
        if tmpLName == None: tmpLName = ""
        tmpId = e_contact_get_const(i, E_CONTACT_UID)
        if tmpLName == None: tmpLName = ""
        #tmpNo = e_contact_get_const(i, E_CONTACT_PHONE_PRIMARY)
        #if tmpNo == None: tmpNo = ""
        #print tmpNo
        if fname == "" and (tmpFName != "" or tmpLName != ""):
            fname = (tmpFName + " " + tmpLName).strip()
            
        if fname != "": 
            names.append([fname.decode("utf-8"), tmpId, "0123456789", tmpFName.decode("utf-8"), tmpLName.decode("utf-8"), tmpNick.decode("utf-8")])
    
    glib.g_list_free(contacts)
    return names
    
    
    
  
def glist(glib, addr):
    """ Implementation of GList. """
    size = glib.g_list_length(addr)
    class _GList(ctypes.Structure):
        _fields_ = [('data', ctypes.c_void_p)]
    for i in xrange(0, size):
        item = glib.g_list_nth(addr, i)
        yield _GList.from_address(item).data
          
# Daaamn I feel kinda dirty right now...

if __name__ == "__main__":
    #getContactNamesAndIds()
    print get_name_from_number(str("+358 (123) 456789"))
    