#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# eSpeakCaller for Maemo 5.
#
# Author: Arto Rusanen
# Date: 2010.04.15
#
# File: espeakcaller.py
# Version: 0.7
# 
# Special thanks to: 
#    Original eSpeak project: http://espeak.sourceforge.net/
#
#    Kaj-Michael Lang (eSpeak) eSpeak maemo package :)
#
#    Nick Leppänen Larsson (fMMS) original phonebook code
#
#    Every one at http://talk.maemo.org/showthread.php?t=34982 for great
#    suggestions/bugreports/patches :)
#

daemonFile = '/opt/espeakcaller/espeakcaller-daemon.py'
pidFile = '/tmp/espeakcaller_pid.txt'
cfgFileLoc = "~/.espeakcaller/"
cfgGeneral = "espeakcaller_general.conf"
cfgUnknown = "espeakcaller_unknown.conf"
cfgBlocked = "espeakcaller_blocked.conf"

#cfgFileDaemon = "/home/user/.espeakcaller/general_daemon.conf"

from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import SIGNAL, SLOT
import sys
import subprocess
import os.path
import string
import locale
import random
import codecs
import dbus
from espeakcaller_ui import Ui_MainWindow
from espeakcaller_about import Ui_Dialog


class eSpeakCaller(QtGui.QMainWindow):
    # Load our new ultra awesome GUI.
    # Made with Qt Designer :)
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        locale.setlocale(locale.LC_ALL, "")

        self.loadContacts()
        self.loadsettings(0)
    
    # Load contacts to memory
    def loadContacts(self):
        import espeakcaller_contacts
        self.names = espeakcaller_contacts.getContactNamesAndIds() 
        
        self.names.sort(cmp=locale.strcoll,key=lambda x:x[0])
        
        for name in self.names:
            self.ui.comboContact.addItem(name[0])
            

    def contact_Changed(self,Index):
        self.loadsettings(Index)

    # Load settings for selected contact.
    def loadsettings(self, contact):
        if contact == 0:
            cfgTmp = cfgFileLoc + cfgGeneral
            self.ui.lblTags.setText("Tags =  %first% is first name, %last% is last name and %nick% is caller\nnickname. (if nickname is used then other tags are ignored)")
        elif contact == 1:
            cfgTmp = cfgFileLoc + cfgUnknown
            self.ui.lblTags.setText("Tags = %number% is caller number")
        elif contact == 2:
            cfgTmp = cfgFileLoc + cfgBlocked
            self.ui.lblTags.setText("")
        else:
            cfgTmp = cfgFileLoc + self.names[contact-3][1] + ".conf"
            self.ui.lblTags.setText("Loaded from:\n" + cfgTmp)
            if not os.path.exists(os.path.expanduser(cfgTmp)):
                print "notfound " + cfgTmp
                cfgTmp = cfgFileLoc + cfgGeneral 
                self.ui.lblTags.setText("Generated from general options.")
                
                         
        cfgTmp = os.path.expanduser(cfgTmp)
        print cfgTmp
                
        if os.path.exists(cfgTmp): 
            #try:
                pdFile = codecs.open(cfgTmp, 'r','utf-8')
                lines = pdFile.readlines()
                pdFile.close()
                
                for line in lines:
                    line = line.strip()
                    if line.startswith("Say:"):
                        tmpName = line.split(":")[1]
                        if contact > 2: # Parse tags if selected specific contact.
                            if tmpName.find("%nick%") != -1 and self.names[contact-3][5] != "":
                                print self.names[contact-3][5].encode("utf-8")
                                tmpName = tmpName.replace("%nick%", self.names[contact-3][5])
                                tmpName = tmpName.replace("%first%", "")
                                tmpName = tmpName.replace("%last%", "")
                                tmpName = tmpName.replace("%name%", "")      
                            else:
                                tmpName = tmpName.replace("%nick%", "")
                                tmpName = tmpName.replace("%first%", self.names[contact-3][3])
                                tmpName = tmpName.replace("%last%", self.names[contact-3][4])
                                tmpName = tmpName.replace("%name%", self.names[contact-3][0])                             
                        #print tmpName.encode("utf-8")
                        self.ui.lineSay.setText(tmpName.strip())
                    elif line.startswith("Enabled:"):
                        if line.split(":")[1] == "1":
                            self.ui.checkEnabled.setCheckState(-1)
                        else:
                            self.ui.checkEnabled.setCheckState(0)  
                    elif line.startswith("Lang:"):
                        self.ui.comboLang.setCurrentIndex(int(line.split(":")[1]))
                    elif line.startswith("Vol:"):
                        self.ui.sliVolume.setValue(int(line.split(":")[1]))
                    elif line.startswith("Pitch:"):
                        self.ui.sliPitch.setValue(int(line.split(":")[1]))
                    elif line.startswith("Speed:"):
                        self.ui.sliSpeed.setValue(int(line.split(":")[1])) 
                    elif line.startswith("Repeat:"):
                        if line.split(":")[1] == "1":
                            self.ui.sliRepeatTimes.setValue(5)
                        else:
                            self.ui.sliRepeatTimes.setValue(1)
                    elif line.startswith("RepeatCount:"):
                        if line.split(":")[1] == "1":
                            self.ui.sliRepeatTimes.setValue(int(line.split(":")[1]))
                        else:
                            self.ui.sliRepeatTimes.setValue(int(line.split(":")[1]))
                    elif line.startswith("Repeattime:"):
                        self.ui.sliRepeat.setValue(int(line.split(":")[1]))  
                    elif line.startswith("Headphones:"):
                        if line.split(":")[1] == "1":
                            self.ui.checkHeadphones.setCheckState(-1)
                        else:
                            self.ui.checkHeadphones.setCheckState(0)                                  
                    elif line.startswith("Aparams:"):
                        self.ui.lineAParams.setText(line.split(":")[1]) 
                        
            #except:
            #    pass       
            
    # Save settings
    def SaveSettings(self):
        #cfgTmp = os.path.expanduser(cfgFileUI)
        if self.ui.comboContact.currentIndex() == 0:
            cfgTmp = cfgFileLoc + cfgGeneral
        elif self.ui.comboContact.currentIndex() == 1:
            cfgTmp = cfgFileLoc + cfgUnknown
        elif self.ui.comboContact.currentIndex() == 2:
            cfgTmp = cfgFileLoc + cfgBlocked
        else:
            cfgTmp = cfgFileLoc + self.names[self.ui.comboContact.currentIndex()-3][1] + ".conf"
            #self.ui.lblTags.setText("Saved to:\n" + cfgTmp)
            
        cfgTmp = os.path.expanduser(cfgTmp)
        print cfgTmp
                
      
        if os.path.exists(cfgTmp): 
            os.remove(cfgTmp) # Remove old settings.
        
        pdFile = codecs.open(cfgTmp, 'w+','utf-8')
        pdFile.write("eSpeak:" + unicode(self.GeteSpeakCommand()).encode('utf-8') + '\n') 
        
        if self.ui.checkEnabled.isChecked():
            pdFile.write("Enabled:1" + '\n')
        else:
            pdFile.write("Enabled:0" + '\n')
                   
        pdFile.write("Say:" + unicode(self.ui.lineSay.displayText().toUtf8(),'utf-8') + '\n')
        pdFile.write("Lang:" + str(self.ui.comboLang.currentIndex()) + '\n')

        pdFile.write("Vol:" + str(self.ui.sliVolume.value()) + '\n')
        pdFile.write("Pitch:" + str(self.ui.sliPitch.value()) + '\n')
        pdFile.write("Speed:" + str(self.ui.sliSpeed.value()) + '\n')
    
        pdFile.write("RepeatCount:" + str(self.ui.sliRepeatTimes.value()) + '\n')
            
        pdFile.write("Repeattime:" + str(self.ui.sliRepeat.value()) + '\n')
        
        if self.ui.checkHeadphones.isChecked():
            pdFile.write("Headphones:1" + '\n')
        else:
            pdFile.write("Headphones:0" + '\n')
               
        pdFile.write("Aparams:" + unicode(self.ui.lineAParams.displayText().toUtf8(),'utf-8') + '\n')
                    
        pdFile.close()
        self.showNotification("Saved to: " + cfgTmp)
         

    # Generates hopefully valid eSpeak command.
    def GeteSpeakCommand(self):
        # Damn eSpeak supports lot of langueages
        sLang=['',' -ven',' -ven-us',' -ven-sc',' -vaf',' -vbs',' -vca',' -vcs',' -vde',' -vel',' -veo',' -ves',' -ves-la',' -vfi',' -vfr',' -vhr',' -vhu',' -vit',' -vku',' -vlv',' -vpl',' -vpt',' -vpt-pt',' -vro',' -vsk',' -vsr',' -vsv',' -vsw',' -vta',' -vtr',' -vzh']
        tmpCmd = "/usr/bin/espeak -m " + sLang[self.ui.comboLang.currentIndex()] + " "
        tmpCmd = tmpCmd + "-a " + str(self.ui.sliVolume.value()) + " "
        tmpCmd = tmpCmd + "-p " + str(self.ui.sliPitch.value()) + " "
        tmpCmd = tmpCmd + "-s " + str(self.ui.sliSpeed.value()) + " "
        tmpCmd = tmpCmd + unicode(self.ui.lineAParams.displayText().toUtf8(),'utf-8') + " "
        tmpCmd = tmpCmd + "'%text%'"
        
        return tmpCmd
       
       
    def speakName(self,Index):
        
        tmpName = unicode(self.ui.lineSay.displayText().toUtf8(),'utf-8')
        if tmpName.find("%nick%") != -1 and self.names[Index][5] != "":
            tmpName = tmpName.replace("%nick%", self.names[Index][5])
            tmpName = tmpName.replace("%first%", "")
            tmpName = tmpName.replace("%last%", "")
            tmpName = tmpName.replace("%name%", "")      
        else:
            tmpName = tmpName.replace("%nick%", "")
            tmpName = tmpName.replace("%first%", self.names[Index][3])
            tmpName = tmpName.replace("%last%", self.names[Index][4])
            tmpName = tmpName.replace("%name%", self.names[Index][0]) 
        
        tmpS = self.GeteSpeakCommand().replace("%text%", tmpName)
        print unicode(tmpS).encode('utf-8')

        subprocess.Popen(unicode(tmpS).encode('utf-8'), shell=True) 
          
    # Test eSpeak 
    def slotTest(self):
        contact = self.ui.comboContact.currentIndex() 
        if contact == 0:
            self.speakName(random.randint(0, len(self.names)-1))
        elif contact == 1:
            Index = random.randint(0, len(self.names)-1)
            tmpName = self.ui.lineSay.displayText().toUtf8()
            tmpNum = " ".join(list(self.names[Index][2]))
            tmpNum = tmpNum.replace("(","")
            tmpNum = tmpNum.replace(")","")     
            tmpName = tmpName.replace("%number%", tmpNum)    
            tmpS = self.GeteSpeakCommand().replace("%text%", tmpName)
            subprocess.Popen(unicode(tmpS).encode("utf-8"), shell=True) #.encode("utf-8")
        elif contact == 2:
            tmpS = self.GeteSpeakCommand().replace("%text%", self.ui.lineSay.displayText().toUtf8())
            subprocess.Popen(unicode(tmpS).encode("utf-8"), shell=True) #.encode("utf-8")
        else:
             self.speakName(contact - 3)           

        
    # Apply settings
    def slotApply(self):
        self.SaveSettings()

        
    def showNotification(self, Text):
        bus = dbus.SessionBus()
        NotificationsObj = bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
        Notifications = dbus.Interface(NotificationsObj, 'org.freedesktop.Notifications')
        Notifications.SystemNoteDialog(Text,0,"OK")
        
    
    # Show new cool About box :) (well not really that cool...)
    def slotAbout(self):
        AboutBox = QtGui.QDialog()
        AboutBox.ui = Ui_Dialog()
        AboutBox.ui.setupUi(AboutBox)
        AboutBox.show()
        AboutBox.exec_()
        

# Execution
if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    myapp = eSpeakCaller()
    myapp.show()
    sys.exit(app.exec_())

        
