#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import time
import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
import sys
import os.path
import subprocess
import shlex
import codecs
import traceback
import logging
import sys



cfgFileLoc = "~/.espeakcaller/"
cfgGeneral = "espeakcaller_general.conf"
cfgUnknown = "espeakcaller_unknown.conf"
cfgBlocked = "espeakcaller_blocked.conf"

myCommand = "espeak '%text%'"
sayName = "%name% is calling."
Enabled = 1
useNickname = 0
eSpeakProc = 0
repeatTime = 5
repeatEnabled = 1
repeatCount = 5
silenceSpeakers = 0
eSpeakCommand = ""

_HEADPHONE_SYS = "/sys/devices/platform/gpio-switch/headphone/state"


#Check if headphones are connected.
def headphones():
    HeadphoneSys = open(_HEADPHONE_SYS, "r")
    state = HeadphoneSys.read().strip()
    HeadphoneSys.close
    if (state == "disconnected"):
        #print "Headphones disconnected"
        return False

    elif (state == "connected"):
        #print "Headphones connected"
        return True

#Run mixer command.
def _amixer(name, value):

    print "mixer", name, value
    os.system("amixer -Dhw:0 cset iface=MIXER,name='%s' %s >/dev/null" % (name, value))
    
    
# Incoming phonecall...
def handle_call(obj_path, callernumber):
    global eSpeakCommand
    global muteTest
    
    try:    
        Log("Incoming phonecall from number: " + callernumber)
        import espeakcaller_contacts

        #CallerNames = get_name_from_number(callernumber)
        CallerNames = espeakcaller_contacts.get_name_from_number(str(callernumber))
        #print CallerNames
        eSpeakText = ""
        
        if CallerNames == "%number%": # Number not in phonebook :(
            Log("Number not found in phonebook")
            loadsettings("unknown")
            if Enabled == 1:
                # Split numbers. Possible fix for
                # "Phonenumber is over nine thouuusaaaannnddd!!!"-bug
                tmpNum = " ".join(list(callernumber))
                tmpNum = tmpNum.replace("(","")
                tmpNum = tmpNum.replace(")","")    
                eSpeakText = sayName.replace("%number%", tmpNum)
        elif CallerNames == "%blocked%": # Number withheld. Probably phonesalesdude.
                Log("Number is private/witheld")
                loadsettings("blocked")
                if Enabled == 1:           
                    eSpeakText = sayName
        else: #we got lucky and found name from phonebook :)
            Log("Found name: " + CallerNames[0])
            loadsettings(str(CallerNames[4]))
            if Enabled == 1:
                if sayName.find("%nick%") != -1 and CallerNames[3] != "":  # Use nickname if available and wanted.
                    eSpeakText = sayName.replace("%nick%", CallerNames[3])
                    eSpeakText = eSpeakText.replace("%name%", "")
                    eSpeakText = eSpeakText.replace("%first%", "")
                    eSpeakText = eSpeakText.replace("%last%", "")
                else: 
                    eSpeakText = sayName.replace("%name%", CallerNames[0])
                    eSpeakText = eSpeakText.replace("%nick%", "")            
                    eSpeakText = eSpeakText.replace("%first%", CallerNames[1])
                    eSpeakText = eSpeakText.replace("%last%", CallerNames[2])      
        
        if eSpeakText != "":
            # Added (0.4): Repeat option. (just quick hack really, but seems to do the trick)
            Log("Say text: " + eSpeakText)
            
            eSpeakText = (eSpeakText + '<break time="' + str(repeatTime) + 's"/>') * repeatCount 
            
            eSpeakText = '<break time="2s"/>' + eSpeakText       
            eSpeakCommand = myCommand.replace("%text%", eSpeakText).encode("utf-8")

    except Exception, err:
        logger.exception("Error in handle_call()")
        pass


# Check profile in use.
def get_profile():
    bus = dbus.SessionBus()
    profiled = bus.get_object('com.nokia.profiled', '/com/nokia/profiled')
    return profiled.get_profile(dbus_interface='com.nokia.profiled')

# Fixed: (0.5) "eSpeak starts shouting things after end ring"-bug
# Do things based on call status.
def call_status(state,ukn1,ukn2):
    Log("state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2))
    #print "state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2)
    global eSpeakProc
    global eSpeakCommand
    
    try:
        if state == 5: # STATUS_MT_ALERTING
            
            if eSpeakCommand != "":
                
                #Fixed: (0.6) Be quiet when in silent profile. :)
                if get_profile() != "silent":
                    Log("Calling eSpeak. Command: " + eSpeakCommand)
                    args = shlex.split(eSpeakCommand)
                    eSpeakProc = subprocess.Popen(args, shell=False)
                    # Fixed: (0.6) Silence speakers if using headphones (dirty hack?)
                    # TODO: Support for bluetooth headphones?
                    if headphones() and silenceSpeakers == 1: 
                        Log("Using headphones. Disabling speakers")
                        _amixer("Speaker Function", "0")  
                    StartMonitor()    
                         
                eSpeakCommand = ""
        elif state == 10 or state == 15 or state == 7 or state == 9 or state == 0: # STATUS_TERMINATED or STATUS_ANSWERED
            StopMonitor()
            if eSpeakProc != 0:
                subprocess.Popen("kill -9 " + str(eSpeakProc.pid), shell=True)
                eSpeakProc = 0
    except Exception, err:
        logger.exception("Error in call_status()")
        pass

# Load settings for selected contact.
def loadsettings(contact):
    try:    
        if contact == "unknown":
            cfgTmp = cfgFileLoc + cfgUnknown
        elif contact == "blocked":
            cfgTmp = cfgFileLoc + cfgBlocked
        else:
            cfgTmp = cfgFileLoc + contact + ".conf"
            if not os.path.exists(os.path.expanduser(cfgTmp)):
                #print "notfound " + cfgTmp
                cfgTmp = cfgFileLoc + cfgGeneral 
                
        cfgTmp = os.path.expanduser(cfgTmp)
               
        if os.path.exists(cfgTmp): 
            Log("Loading config: " + cfgTmp)
     
            pdFile = codecs.open(cfgTmp, 'r','utf-8')
            lines = pdFile.readlines()
            pdFile.close()
            
            global Enabled
            global myCommand
            global sayName
            global useNickname
            global repeatCount
            global repeatTime
            global silenceSpeakers
            global speakInSilentProfile
            
            for line in lines:
                line = line.strip()
                if line.startswith("eSpeak:"):
                    myCommand = line.split(":")[1]
                elif line.startswith("Enabled:"):
                    Enabled = int(line.split(":")[1])   
                elif line.startswith("Say:"):
                    sayName = line.split(":")[1]
                elif line.startswith("Nick:"):
                    useNickname = int(line.split(":")[1])
                elif line.startswith("Repeat:"):
                    if line.split(":")[1] == "1":
                        repeatCount = 5
                    else:
                        repeatCount = 1
                elif line.startswith("RepeatCount:"):
                    repeatCount = int(line.split(":")[1])
                elif line.startswith("Repeattime:"):
                    repeatTime = int(line.split(":")[1])
                elif line.startswith("Headphones:"):
                    silenceSpeakers = int(line.split(":")[1]) 
                                                   
    except Exception, err:
        logger.exception("Error in loadsettings()")
        pass
        
        
# Fixed (0.7): Possible fix for "eSpeak is yelling after mute button has been pressed."-bug
#              Reeeaaally dirty hack :b I still haven't found any real way to do this :(
def StartMonitor():
    try:
        bus = dbus.SessionBus()
        bus.add_match_string("")
        bus.add_message_filter(msg_filter)
    except:
        pass
def StopMonitor():
    try:
        bus = dbus.SessionBus()
        bus.remove_message_filter(msg_filter)
        bus.remove_match_string("")              
    except:
        pass
def msg_filter(abus, msg):
    try:
        args = msg.get_args_list()
        dest = msg.get_destination()
        mem = msg.get_member()
        
        if dest == "org.maemo.Playback.Manager" and mem == "RequestState":
            if args[1] == "Stop":
                #print "Stop event!"
                global eSpeakProc
                if eSpeakProc != 0:   
                    Log("Mute pressed. Killing espeak.")
                    subprocess.Popen("kill -9 " + str(eSpeakProc.pid), shell=True)
                    eSpeakProc = 0
    except Exception, e:
        logger.exception("Error in msg_filter()")
     
     
def Log(logText):
    logger.debug(logText)
    
# def Main
try:
    LogPath = os.path.expanduser(cfgFileLoc + "espeakcaller.log")
    logging.basicConfig(filename=LogPath,filemode='w',level=logging.DEBUG)
    logger = logging.getLogger('eSpeakCaller')
    
    DBusGMainLoop(set_as_default=True)
    bus = dbus.SystemBus()
    bus.add_signal_receiver(handle_call, path='/com/nokia/csd/call', dbus_interface='com.nokia.csd.Call', signal_name='Coming')
    bus.add_signal_receiver(call_status, path=None, dbus_interface='com.nokia.csd.Call.Instance', signal_name='CallStatus')
    
    gobject.MainLoop().run()
except Exception, err:
    logger.exception("Error in main()")
