#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import time
import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
import sys
import evolution
import os.path
import subprocess
import shlex
import codecs
import traceback
import logging


cfgFileLoc = "~/.espeakcaller/"
cfgGeneral = "espeakcaller_general.conf"
cfgUnknown = "espeakcaller_unknown.conf"
cfgBlocked = "espeakcaller_blocked.conf"

myCommand = "espeak '%text%'"
sayName = "%name% is calling."
Enabled = 1
useNickname = 0
eSpeakProc = 0
repeatTime = 5
repeatEnabled = 1
silenceSpeakers = 0
eSpeakCommand = ""

_HEADPHONE_SYS = "/sys/devices/platform/gpio-switch/headphone/state"

def get_name_from_number(number):
    #  Taken from fMMS (modified)
    #  Should get caller name from phonebook
    #  I wonder if there is better/faster/less dirty way to do this...
    #
    # Fixed (0.3): "eSpeakCaller says the number even if the name is defined"-bug :)
    #              (number is in international format)
    # Thanks to Thnninen @ http://talk.maemo.org/showthread.php?t=34982&page=4
    #
    # Fixed: (0.4): "eSpeakCaller still has no clue about callername"-bug
    #              (number contains spaces)
    #
    # Fixed: (0.5): "eSpeakCaller doesn't understand callernumber with brackets()"-bug
    #
    
    try:
        if (len(number) == 0) :
            return "%blocked%"
    
        ab = evolution.ebook.open_addressbook("default")
        contacts = ab.get_all_contacts()
        for c in contacts:
            vcardlist = c.get_vcard_string().replace('\r', '').split('\n')
            fname = ""
            tmpNick = ""
            tmpFName = ""
            tmpLName = ""
            nr = ""
            my_num = ""
            c_num = ""
            tmpId = c.get_uid()
            
            for line in vcardlist:    
                if line.startswith("TEL"):
                    nr = line.split(":")[1]
                                 
                    my_num = number.lstrip('0')      # Remove leading zero
                    my_num = my_num.replace(' ', '') # Remove spaces 
                    my_num = my_num.replace('(', '') # Remove brackets '()'
                    my_num = my_num.replace(')', '')
                                    
                    c_num = nr.lstrip('0')
                    c_num = c_num.replace(' ', '')
                    c_num = c_num.replace('(', '') 
                    c_num = c_num.replace(')', '')
                    
                    if c_num.endswith(my_num) or my_num.endswith(c_num):
                        fname = c.get_name()
                        Log("Found name: " + fname)
                        Log("Phonebook number: " + nr)
                        Log("Phonebook vcard: " + "\n".join(vcardlist))
                        Log("Stripped incoming number: " + my_num)
                        Log("Stripped phonebook number: " + c_num)
                    #end if
                #end if
                if line.startswith("NICKNAME"):
                    tmpNick = line.split(":")[1]
                if line.startswith("N:"):
                    tmpStr = line.split(":")[1]
                    tmpFName = tmpStr.split(";")[1]
                    tmpLName = tmpStr.split(";")[0]
                #end if
            #next
            
            if fname != "" and fname != None: 
                Log("First name: " + tmpFName)
                Log("Last name: " + tmpLName)
               
                return [fname.decode('utf-8'), tmpFName.decode('utf-8'), tmpLName.decode('utf-8'), tmpNick.decode('utf-8'), tmpId]
    
            #end if
        #next
        
        # Number not found in phonebook.
        return "%number%"
    except Exception, err:
        logger.exception("Error in get_name_from_number()")
        pass
        

#Check if headphones are connected.
def headphones():
    state = open(_HEADPHONE_SYS, "r").read().strip()
    if (state == "disconnected"):
        print "Headphones disconnected"
        return False

    elif (state == "connected"):
        print "Headphones connected"
        return True

#Run mixer command.
def _amixer(name, value):

    print "mixer", name, value
    os.system("amixer -Dhw:0 cset iface=MIXER,name='%s' %s >/dev/null" % (name, value))
    
    
# Incoming phonecall...
def handle_call(obj_path, callernumber):
    global eSpeakCommand
   
    try:    
        Log("Incoming phonecall from number: " + callernumber)
        CallerNames = get_name_from_number(callernumber)
    
        eSpeakText = ""
        
        if CallerNames == "%number%": # Number not in phonebook :(
            Log("Number not found in phonebook")
            loadsettings("unknown")
            if Enabled == 1:
                # Split numbers. Possible fix for
                # "Phonenumber is over nine thouuusaaaannnddd!!!"-bug
                tmpNum = " ".join(list(callernumber))
                tmpNum = tmpNum.replace("(","")
                tmpNum = tmpNum.replace(")","")    
                eSpeakText = sayName.replace("%number%", tmpNum)
        elif CallerNames == "%blocked%": # Number withheld. Probably phonesalesdude.
                Log("Number is private/witheld")
                loadsettings("blocked")
                if Enabled == 1:           
                    eSpeakText = sayName
        else: #we got lucky and found name from phonebook :)
            loadsettings(str(CallerNames[4]))
            if Enabled == 1:
                if sayName.find("%nick%") != -1 and CallerNames[3] != "":  # Use nickname if available and wanted.
                    eSpeakText = sayName.replace("%nick%", CallerNames[3])
                    eSpeakText = eSpeakText.replace("%name%", "")
                    eSpeakText = eSpeakText.replace("%first%", "")
                    eSpeakText = eSpeakText.replace("%last%", "")
                else: 
                    eSpeakText = sayName.replace("%name%", CallerNames[0])
                    eSpeakText = eSpeakText.replace("%nick%", "")            
                    eSpeakText = eSpeakText.replace("%first%", CallerNames[1])
                    eSpeakText = eSpeakText.replace("%last%", CallerNames[2])      
        
        if eSpeakText != "":
            # Fixed: (0.4) "me speaks no umlauts"-bug (use utf-8)
            # Added: Repeat option. (just quick hack really)
            Log("Say text: " + eSpeakText)
            if repeatEnabled == 1:
                eSpeakText = (eSpeakText + '<break time="' + str(repeatTime) + 's"/>') * 10 # max repeat 10 times (enough?)
            
            eSpeakText = '<break time="2s"/>' + eSpeakText       
            eSpeakCommand = unicode(myCommand.replace("%text%", eSpeakText)).encode("utf-8")

    except Exception, err:
        logger.exception("Error in handle_call()")
        pass


# Check profile in use.
def get_profile():
    bus = dbus.SessionBus()
    profiled = bus.get_object('com.nokia.profiled', '/com/nokia/profiled')
    return profiled.get_profile(dbus_interface='com.nokia.profiled')

# Fixed: (0.5) "eSpeak starts shouting things after end ring"-bug
# Do things based on call status.
def call_status(state,ukn1,ukn2):
    #Log("state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2))
    global eSpeakProc
    global eSpeakCommand

    try:
        if state == 5: # STATUS_MT_ALERTING
            if eSpeakCommand != "":
                args = shlex.split(eSpeakCommand)
                #Fixed: (0.6) Be quiet when in silent profile :)
                if get_profile() != "silent": 
                    Log("Calling eSpeak. Command: " + eSpeakCommand)
                    eSpeakProc = subprocess.Popen(args, shell=False)
                    # Fixed: (0.6) Silence speakers if using headphones (dirty hack?)
                    if headphones() and silenceSpeakers == 1: 
                        _amixer("Speaker Function", "0")        
                eSpeakCommand = ""
        elif state == 10 or state == 15 or state == 7: # STATUS_TERMINATED or STATUS_ANSWERED
            eSpeakCommand = ""
            if headphones() and silenceSpeakers == 1: 
                _amixer("Speaker Function", "1")  
            subprocess.Popen("kill -9 " + str(eSpeakProc.pid), shell=True)
    except Exception, err:
        logger.exception("Error in call_status()")
        pass

# Load settings for selected contact.
def loadsettings(contact):
    try:    
        if contact == "unknown":
            cfgTmp = cfgFileLoc + cfgUnknown
        elif contact == "blocked":
            cfgTmp = cfgFileLoc + cfgBlocked
        else:
            cfgTmp = cfgFileLoc + contact + ".conf"
            if not os.path.exists(os.path.expanduser(cfgTmp)):
                #print "notfound " + cfgTmp
                cfgTmp = cfgFileLoc + cfgGeneral 
                
                         
        cfgTmp = os.path.expanduser(cfgTmp)
               
        if os.path.exists(cfgTmp): 
            Log("Loaded config: " + cfgTmp)
     

            pdFile = codecs.open(cfgTmp, 'r','utf-8')
            lines = pdFile.readlines()
            pdFile.close()
            
            global Enabled
            global myCommand
            global sayName
            global useNickname
            global repeatEnabled
            global repeatTime
            global silenceSpeakers
            
            for line in lines:
                line = line.strip()
                if line.startswith("eSpeak:"):
                    myCommand = line.split(":")[1]
                elif line.startswith("Enabled:"):
                    Enabled = int(line.split(":")[1])   
                elif line.startswith("Say:"):
                    sayName = line.split(":")[1]
                elif line.startswith("Nick:"):
                    useNickname = int(line.split(":")[1])
                elif line.startswith("Repeat:"):
                    repeatEnabled = int(line.split(":")[1])
                elif line.startswith("Repeattime:"):
                    repeatTime = int(line.split(":")[1])
                elif line.startswith("Headphones:"):
                    silenceSpeakers = int(line.split(":")[1])                                
    except Exception, err:
        logger.exception("Error in loadsettings()")
        pass
        

def Log(logText):
    logger.debug(logText)
    
# def Main
try:
    LogPath = os.path.expanduser(cfgFileLoc + "espeakcaller.log")
    logging.basicConfig(filename=LogPath,filemode='w',level=logging.DEBUG)
    logger = logging.getLogger('eSpeakCaller')
    
    DBusGMainLoop(set_as_default=True)
    bus = dbus.SystemBus()
    bus.add_signal_receiver(handle_call, path='/com/nokia/csd/call', dbus_interface='com.nokia.csd.Call', signal_name='Coming')
    bus.add_signal_receiver(call_status, path=None, dbus_interface='com.nokia.csd.Call.Instance', signal_name='CallStatus')
    gobject.MainLoop().run()
except Exception, err:
    logger.exception("Error in main()")
