#!/usr/bin/env python
import os
import time
import gobject, dbus
from dbus.mainloop.glib import DBusGMainLoop
import sys
import subprocess
import evolution
import os.path


cfgFile = "~/.espeakcaller/espeakcaller_daemon.conf"
myCommand = "espeak '%text%'"
sayName = "%name% is calling."
unkNum = "Call from Unknown number"
blNum = "Call from Blocked number"
useNickname = 0
eSpeakProc = 0
Ringing = False


def get_name_from_number(number):
    #  Taken from fMMS (modified)
    #  Should get caller name from phonebook
    #  I wonder if there is better/faster/less dirty way to do this...
    #
    # Fixed: "eSpeakCaller says the number even if the name is defined"-bug :)
    #        (number is in international format)
    # Thanks to Thnninen @ http://talk.maemo.org/showthread.php?t=34982&page=4
    #
    #
    
    if (len(number) == 0) :
        return "%blocked%"

    fname = ""
    
    ab = evolution.ebook.open_addressbook("default")
    contacts = ab.get_all_contacts()
    for c in contacts:
        vcardlist = c.get_vcard_string().replace('\r', '').split('\n')
        tmpNick = ""
        
        for line in vcardlist:    
            if line.startswith("TEL"):
                nr = line.split(":")[1]
                my_num = number.lstrip('0')
                c_num = nr.lstrip('0')
                if nr != None:
                    if nr.endswith(my_num) or number.endswith(c_num):
                        fname = c.get_name()
                    #end if
                #end if
            #end if
            if line.startswith("NICKNAME"):
                tmpNick = line.split(":")[1]
            #end if
        #next
        
        if fname != "": 
            # Return nickname if available and wanted.
            if useNickname == 1 and tmpNick != "":
                return tmpNick
            else:
                return fname
            #end if
        #end if
    #next
    
    # Number not found in phonebook.
    return "%number%"
    


# Incoming phonecall...
# There are so many options that code is getting pretty dirty & ugly (needs cleaning?)
def handle_call(obj_path, callernumber):
    global eSpeakProc
    global Ringing
    
    Ringing = True # Just for future versions if I ever get that repeating working...
    
    CallerName = get_name_from_number(callernumber)
    eSpeakText = ""
    
    if CallerName == "%number%": # Number not in phonebook :(
        if unkNum != "":
            # Split numbers. Possible fix for
            # "Phonenumber is over nine thouuusaaaannnddd!!!"-bug
            tmpNum = " ".join(list(callernumber))
            eSpeakText = unkNum.replace("%number%", tmpNum)
    elif CallerName == "%blocked%": # Number blocked. Probably phonesalesdude.
        if blNum != "":
            eSpeakText = blNum
    else: #we got lucky and found name from phonebook :)
        eSpeakText = sayName.replace("%name%", CallerName)
        
    if eSpeakText != "":
        time.sleep(2) # Wait a sec. (I get laggy speak without this)
        eSpeakProc = subprocess.Popen(unicode(myCommand.replace("%text%", eSpeakText)).encode("utf-8"), shell=True)
    

# TODO: Make espeak repeat saying caller name (Maybe using threading. Gotta learn more about python threads...)

# Try to stop eSpeak if call is answered or call is cancelled.
def call_status(state,ukn1,ukn2):
    print "state: %d  ukn1: %d  ukn2: %d" % (state,ukn1,ukn2)
    global eSpeakProc
    global Ringing
    
    if state == 0: #or state == ??: # Ringing ended (0) or phone answered (7 or 8)?
        if not eSpeakProc == 0:
            subprocess.Popen("kill -9 " + str(eSpeakProc.pid + 1), shell=True)
            eSpeakProc = 0
            Ringing = False
            
# def Main
try:
    pdFile = open(os.path.expanduser(cfgFile), 'r+')
    myCommand = pdFile.readline().strip()
    sayName = pdFile.readline().strip()
    unkNum = pdFile.readline().strip()
    blNum = pdFile.readline().strip()
    useNickname = int(pdFile.readline().strip())
    pdFile.close()
except:
    pass

DBusGMainLoop(set_as_default=True)
bus = dbus.SystemBus()
bus.add_signal_receiver(handle_call, path='/com/nokia/csd/call', dbus_interface='com.nokia.csd.Call', signal_name='Coming')
bus.add_signal_receiver(call_status, path=None, dbus_interface='com.nokia.csd.Call.Instance', signal_name='CallStatus')

gobject.MainLoop().run()
