#!/bin/sh
# Reading config file
source /home/user/.ereswap/config

# Creating notification banner, for easy of further usage
banner(){
o=org
f=freedesktop
n=Notifications
run-standalone.sh dbus-send --type=method_call \
--dest=$o.$f.$n /$o/$f/$n $o.$f.$n.SystemNoteInfoprint string:"$1"
}

# Actual reswap, saving stats
swapon /dev/$swap2 || banner "Can't use $swap2 as temporal swap! Are You sure, that it is linuxswap type partition?"
nice -20 swapoff /dev/$swap0 || banner "Can't refresh $swap0 swap - it doesn't appear to be active swap!"
iostat -md $swap0 | grep $swap0 | awk '{print $6}' >/root/reswap.stat &&
swapon /dev/$swap0 || banner "Can't re-enable swap on $swap0 - NFC what is going on, this shouldn't happen."
nice -20 swapoff /dev/$swap2 || banner "Can't disable temporal swap - NFC what is going on, this shouldn't happen."

# Printing info
banner "Swap restarted"