# This file is part of effing
#
# Copyright (C) 2010 Richard Merren <richard@merren.net>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with this library; see the file COPYING.LIB.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301, USA.
#


QT       += core gui webkit network script

TARGET = effing
TEMPLATE = app

SOURCES += main.cpp\
        effingmain.cpp \
    logindialog.cpp \
    fbactions.cpp \
    settingsmanager.cpp \
    browserlauncher.cpp

HEADERS  += effingmain.h \
    logindialog.h \
    constants.h \
    fbactions.h \
    settingsmanager.h \
    browserlauncher.h

FORMS    += effingmain.ui

CONFIG += mobility
MOBILITY = 

#uncomment to get rid of debug output
#DEFINES += QT_NO_DEBUG_OUTPUT

symbian {
    TARGET.UID3 = 0xe204248a
    # TARGET.CAPABILITY += 
    TARGET.EPOCSTACKSIZE = 0x14000
    TARGET.EPOCHEAPSIZE = 0x020000 0x800000
}

unix {
  #VARIABLES
  isEmpty(PREFIX) {
    PREFIX = /usr
  }
  BINDIR = $$PREFIX/bin/$$TARGET
  DATADIR =$$PREFIX/share

  DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

  #MAKE INSTALL

  INSTALLS += target desktop icon48 iconscalable

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications/hildon
  desktop.files += ../maemofiles/effing.desktop

  icon48.path = $$DATADIR/icons/hicolor/48x48/hildon
  icon48.files += ../maemofiles/effing_icon.png

  iconscalable.path = $$DATADIR/icons/scalable/hildon
  iconscalable.files += ../maemofiles/effing_icon.png


}
