/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "settingsmanager.h"
#include "constants.h"


SettingsManager::SettingsManager(QObject *parent) :
    QObject(parent)
{
    settings = new QSettings(COMPANY_NAME,PROGRAM_NAME);
}

SettingsManager::~SettingsManager()
{
    delete settings;
}

QString SettingsManager::get_facebook_auth()
{
    settings->beginGroup(FB_GROUP);
    QString auth_key = settings->value(PROP_AUTH_KEY,QString()).toString();
    settings->endGroup();
    return auth_key;
}

void SettingsManager::set_facebook_auth(QString auth_key)
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_AUTH_KEY,auth_key);
    settings->endGroup();
    settings->sync();
}

void SettingsManager::clear_facebook_auth()
{
    set_facebook_auth(QString());
}

void SettingsManager::set_prefer_facebook_touch(bool prefer_touch)
{
    settings->beginGroup(FB_GROUP);
    settings->setValue(PROP_PREFER_TOUCH,prefer_touch);
    settings->endGroup();
    settings->sync();
}

bool SettingsManager::is_prefer_facebook_touch()
{
    settings->beginGroup(FB_GROUP);
    bool prefer_touch = settings->value(PROP_PREFER_TOUCH,false).toBool();
    settings->endGroup();
    return prefer_touch;

}
