/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "effingmain.h"
#include "ui_effingmain.h"
#include "constants.h"
#include <Qt>

EffingMain::EffingMain(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::EffingMain)
{
    ui->setupUi(this);
    connect(ui->actionUnauthorize,SIGNAL(triggered()),this,SIGNAL(erase_token()));
    connect(ui->actionUse_FB_Touch,SIGNAL(toggled(bool)),this,SIGNAL(changed_prefer_touch(bool)));
    connect(ui->openFacebookButton,SIGNAL(clicked()),this,SIGNAL(launch_facebook()));
}

EffingMain::~EffingMain()
{
    delete ui;
}

void EffingMain::set_status(QString status_text, QDateTime status_timestamp)
{
    QString new_text;
    if (status_text.isNull() || status_text.trimmed().length()==0)
        new_text = tr("none");
    else
        new_text = Qt::escape(status_text);

    QString new_timestamp;
    if (status_timestamp.isNull())
        new_timestamp = tr("unknown time");
    else
        new_timestamp = status_timestamp.toString(Qt::SystemLocaleShortDate);

    QString html = QString("<b>" + tr("Current Status") +":</b> %1 <i>(%2)</i>").arg(new_text,new_timestamp);

    ui->currentStatusEdit->setHtml(html);
}

void EffingMain::on_submitButton_clicked()
{
    QString text = ui->statusEdit->toPlainText();
    if (text!=NULL && !text.trimmed().isEmpty())
    {
        emit submitStatus(text);
    }
}

void EffingMain::set_status_not_logged_in()
{
    set_status(tr("Not logged in"),QDateTime::currentDateTime());
}

void EffingMain::on_refreshButton_clicked()
{
    emit refresh();
}

void EffingMain::set_prefer_touch(bool prefer_touch)
{
    bool current = ui->actionUse_FB_Touch->isChecked();
    //Only emit if this is a change in value
    if (prefer_touch!=current)
        ui->actionUse_FB_Touch->setChecked(prefer_touch);
}

void EffingMain::clear_entry_box()
{
    ui->statusEdit->clear();
}
