/*
 * This file is part of edicom application
 *
 * Copyright (C) 2010 Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * Contact: Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "scanfthread.h"
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <QInputDialog>
#include "mainwindow.h"
#include <QMutex>
//#include <QDebug>

ScanfThread::ScanfThread(QObject *parent)
    : QThread(parent)
{
    this->stopFlag=false;
}
void ScanfThread::run()
{
        this->stopFlag=false;
            int rd=::open("/tmp/.POUT",O_RDWR|O_NONBLOCK|O_NOCTTY);
            int wr=::open("/tmp/.PIN",O_RDWR|O_NONBLOCK|O_NOCTTY);

        sleep(2);

        while(stopFlag==false)
        {

            QFile pidFile("/tmp/pid.ec");
            QString pid;
            if(pidFile.exists())
            {
                if (pidFile.open(QFile::ReadOnly))
                {
                    QTextStream out(&pidFile);
                    pid=out.readAll();
                }
                //qDebug()<<pid;
                pidFile.close();
                pid=pid.trimmed();
                QFile status("/proc/"+pid+"/status");
                if(status.exists())
                {
                    if (status.open(QFile::ReadOnly))
                    {
                        QTextStream out(&status);
                        QString buffer=out.readAll();
                        QStringList afterSplit=buffer.split("\n");
                        //qDebug()<<afterSplit[1];
                        if(afterSplit[1].contains("sleeping"))
                        {
                            //emit showDialog("");
                            char temp[400];
                            strcpy(temp,"scanf \"");
                            strcat(temp,this->scanfParam.toAscii().data());
                            strcat(temp,"\"");
                            system(temp);
                        }
                    }
                }
                else
                {
                    emit stopDebug();
                    //qDebug()<<pid<<"\nnot found";
                    //QMessageBox::warning(this, tr("Application"),tr("check program pid not found"));
                }
            }
            this->sleep(1);
/*
            system("ps -eo stat,comm=CMD | grep .temp > .c.txt");
                        QFile readLoginData(".c.txt");
            if (!readLoginData.open(QFile::ReadOnly))
                return;
            this->sleep(2);
            QByteArray line3=readLoginData.readLine(100);
                line3=readLoginData.readLine(100);
                line3=readLoginData.readLine(100);
                QString line=QString(line3);
                if(!line.contains(QDir::currentPath()+"/.temp"))
                {
                    line3=readLoginData.readLine(100);
                    line=QString(line3);
                }
            readLoginData.close();
            if(line.contains(" S") && line.contains(QDir::currentPath()+"/.temp"))
            {
                system("scanf");
                //emit showScanDialog();
            }*/
       }
        ::close(rd);
        ::close(wr);
}
void ScanfThread::suspend()
{
    m_bToSuspend = true;
}

void ScanfThread::resume()
{
    if (!m_bToSuspend)
        return;

    m_bToSuspend = false;
    m_waitCondt.wakeOne();
}
