/*
 * This file is part of edicom application
 *
 * Copyright (C) 2010 Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * Contact: Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef CODEEDITOR_H
#define CODEEDITOR_H

#include <QPlainTextEdit>
#include <QObject>
#include <QDebug>
#include <QTextBlock>
#include <QPainter>

QT_BEGIN_NAMESPACE
class QPaintEvent;
class QResizeEvent;
class QSize;
class QWidget;
QT_END_NAMESPACE

class LineNumberArea;

class CodeEditor : public QPlainTextEdit
{
    Q_OBJECT

public:
    CodeEditor(QWidget *parent = 0);

    void lineNumberAreaPaintEvent(QPaintEvent *event);
    int lineNumberAreaWidth();
    QTextBlock firstVisibleBlk();
    QRectF blockBoundingRec(QTextBlock block);
    void setBreakPoint(int lineNumber);
    QList<int> getBreakPoints(){ return breakpointLineNumber;}
protected:
    void resizeEvent(QResizeEvent *event);
    //bool viewportEvent(QEvent *event);

private slots:
    void updateLineNumberAreaWidth(int newBlockCount);
    void highlightCurrentLine();
    void updateLineNumberArea(const QRect &, int);

signals:
    void setBreakPoint(int lineNumber,bool setFlag);

private:
    QWidget *lineNumberArea;
    QList<int> breakpointLineNumber;
};

class LineNumberArea : public QWidget
{
public:
    LineNumberArea(CodeEditor *editor) : QWidget(editor) {
        codeEditor = editor;
    }

    QSize sizeHint() const {
        return QSize(codeEditor->lineNumberAreaWidth(), 0);
    }

protected:
    void paintEvent(QPaintEvent *event) {

        codeEditor->lineNumberAreaPaintEvent(event);
        QPainter paint(this);
        QImage image(":images/breakpointimage.png");
        QList<int> breakpointLineNumber=codeEditor->getBreakPoints();
        for(int i=0;i<breakpointLineNumber.count();i++){
            QTextBlock block = codeEditor->firstVisibleBlk();
            QPoint p(4,(codeEditor->blockBoundingRec(block).height()*breakpointLineNumber.at(i))+10);
            paint.drawImage(p,image);
        }
    }
    void mousePressEvent(QMouseEvent *event){
        QTextCursor cursor = codeEditor->cursorForPosition(QPoint(0, event->pos().y()));
        cursor.setPosition(cursor.block().position());
        codeEditor->setBreakPoint(cursor.blockNumber());
    }

private:
    CodeEditor *codeEditor;
};

#endif

