#ifndef TERMINAL_H
#define TERMINAL_H

#include <QtGui/QMainWindow>
#include <QTextStream>
#include <QFileDialog>
#include "exethread.h"
#include "outputthread.h"
#include "scannerthread.h"

namespace Ui {
    class Terminal;
}

class Terminal : public QMainWindow {
    Q_OBJECT
public:
    Terminal(QWidget *parent = 0);
    ~Terminal();

public:
    OutputThread outputThread;
    ExeThread exeThread;
    ScannerThread scanfThread;
    int charCountBefourScanf;
    int fl;
    int fpointer;
    int endPoint;
signals:
    void killed();
    void terminalExiting();
public slots:
    void updateDisplay(QString str);
    void killer();
    void showScanDialog();
    void returnPressed();
    void closeEvent(QCloseEvent *event);

protected:
    void changeEvent(QEvent *e);
    bool eventFilter(QObject *obj, QEvent *ev);

public:
    Ui::Terminal *m_ui;
};

#endif // TERMINAL_H
