/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "ec-button.h"

#include "ec-button-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _ec_button_state_values[] = {
	{ EC_BUTTON_STATE_RELEASED, (char *)"EC_BUTTON_STATE_RELEASED", (char *)"released" },
	{ EC_BUTTON_STATE_DOWN, (char *)"EC_BUTTON_STATE_DOWN", (char *)"down" },
	{ EC_BUTTON_STATE_COUNT, (char *)"EC_BUTTON_STATE_COUNT", (char *)"count" },
	{ 0, NULL, NULL }
};

GType
ec_button_state_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("EcButtonState", _ec_button_state_values);
	return type;
}

/* self casting macros */
#define SELF(x) EC_BUTTON(x)
#define SELF_CONST(x) EC_BUTTON_CONST(x)
#define IS_SELF(x) EC_IS_BUTTON(x)
#define TYPE_SELF EC_TYPE_BUTTON
#define SELF_CLASS(x) EC_BUTTON_CLASS(x)

#define SELF_GET_CLASS(x) EC_BUTTON_GET_CLASS(x)

/* self typedefs */
typedef EcButton Self;
typedef EcButtonClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void ec_button_class_init (EcButtonClass * c) G_GNUC_UNUSED;
static void ec_button_init (EcButton * self) G_GNUC_UNUSED;
static void ec_button_repaint (EcButton * self) G_GNUC_UNUSED;
static void ___19_ec_button_style_set (GtkWidget * widget, GtkStyle * prev_style) G_GNUC_UNUSED;
static gboolean ___1a_ec_button_expose_event (GtkWidget * widget, GdkEventExpose * event) G_GNUC_UNUSED;
static void ec_button_expose_with_title (GtkWidget * widget, GdkEventExpose * event, gboolean is_down) G_GNUC_UNUSED;
static gboolean ec_button_button_press_event (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static gboolean ec_button_enter_notify_event (GtkWidget * widget, GdkEventCrossing * event) G_GNUC_UNUSED;
static gboolean ec_button_leave_notify_event (GtkWidget * widget, GdkEventCrossing * event) G_GNUC_UNUSED;
static gboolean ec_button_button_release_event (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void ec_button_realize (GtkWidget * widget, gpointer user_data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__clicked(object,func,data)	ec_button_connect__clicked((object),(func),(data))
#define self_connect_after__clicked(object,func,data)	ec_button_connect_after__clicked((object),(func),(data))
#define self_connect_data__clicked(object,func,data,destroy_data,flags)	ec_button_connect_data__clicked((object),(func),(data),(destroy_data),(flags))

enum {
	CLICKED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_BTN_DOWN_OFFSET,
	PROP_CENTER_VERTICALLY,
	PROP_CENTER_TEXT_VERTICALLY
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkDrawingAreaClass *parent_class = NULL;

/* Short form macros */
#define self_get_btn_down_offset ec_button_get_btn_down_offset
#define self_set_btn_down_offset ec_button_set_btn_down_offset
#define self_get_center_vertically ec_button_get_center_vertically
#define self_set_center_vertically ec_button_set_center_vertically
#define self_get_center_text_vertically ec_button_get_center_text_vertically
#define self_set_center_text_vertically ec_button_set_center_text_vertically
#define self_new ec_button_new
#define self_set_label_text ec_button_set_label_text
#define self_get_label_text ec_button_get_label_text
#define self_set_title_text ec_button_set_title_text
#define self_get_title_text ec_button_get_title_text
#define self_set_bg_image ec_button_set_bg_image
#define self_set_bg_image_pixbuf ec_button_set_bg_image_pixbuf
#define self_set_icon ec_button_set_icon
#define self_set_icon_pixbuf ec_button_set_icon_pixbuf
#define self_set_font_description_label ec_button_set_font_description_label
#define self_get_font_description_label ec_button_get_font_description_label
#define self_set_font_description_title ec_button_set_font_description_title
#define self_get_font_description_title ec_button_get_font_description_title
#define self_set_alignment ec_button_set_alignment
#define self_get_alignment ec_button_get_alignment
#define self_clicked ec_button_clicked
#define self_repaint ec_button_repaint
#define self_expose_with_title ec_button_expose_with_title
#define self_button_press_event ec_button_button_press_event
#define self_enter_notify_event ec_button_enter_notify_event
#define self_leave_notify_event ec_button_leave_notify_event
#define self_button_release_event ec_button_button_release_event
#define self_realize ec_button_realize
GType
ec_button_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (EcButtonClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) ec_button_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (EcButton),
			0 /* n_preallocs */,
			(GInstanceInitFunc) ec_button_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DRAWING_AREA, "EcButton", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((EcButton *)g_object_new(ec_button_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static EcButton * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static EcButton *
GET_NEW_VARG (const char *first, ...)
{
	EcButton *ret;
	va_list ap;
	va_start (ap, first);
	ret = (EcButton *)g_object_new_valist (ec_button_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Ec:Button::dispose"
	EcButton *self G_GNUC_UNUSED = EC_BUTTON (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#define layout_label (self->_priv->layout_label)
#define VAR layout_label
	{
#line 67 "ec-button.gob"
	
			if(VAR)
			{
				g_object_unref(VAR);
			}
		}
#line 183 "ec-button.c"
	memset(&layout_label, 0, sizeof(layout_label));
#undef VAR
#undef layout_label
#define layout_title (self->_priv->layout_title)
#define VAR layout_title
	{
#line 75 "ec-button.gob"
	
			if(VAR)
			{
				g_object_unref(VAR);
			}
		}
#line 197 "ec-button.c"
	memset(&layout_title, 0, sizeof(layout_title));
#undef VAR
#undef layout_title
#define bg_pixbuf (self->_priv->bg_pixbuf)
#define VAR bg_pixbuf
	{
#line 83 "ec-button.gob"
	
			gint i;
			for(i = 0; i < EC_BUTTON_STATE_COUNT; i++)
			{
				if(VAR[i])
				{
					gdk_pixbuf_unref(VAR[i]);
				}
			}
		}
#line 215 "ec-button.c"
	memset(&bg_pixbuf, 0, sizeof(bg_pixbuf));
#undef VAR
#undef bg_pixbuf
#line 95 "ec-button.gob"
	if(self->_priv->icon_pixbuf) { gdk_pixbuf_unref ((gpointer) self->_priv->icon_pixbuf); self->_priv->icon_pixbuf = NULL; }
#line 221 "ec-button.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Ec:Button::finalize"
	EcButton *self G_GNUC_UNUSED = EC_BUTTON (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 21 "ec-button.gob"
	if(self->_priv->label_text) { g_free ((gpointer) self->_priv->label_text); self->_priv->label_text = NULL; }
#line 236 "ec-button.c"
#line 24 "ec-button.gob"
	if(self->_priv->title_text) { g_free ((gpointer) self->_priv->title_text); self->_priv->title_text = NULL; }
#line 239 "ec-button.c"
}
#undef __GOB_FUNCTION__

static void 
ec_button_class_init (EcButtonClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Ec:Button::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	g_type_class_add_private(c,sizeof(EcButtonPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DRAWING_AREA);

	object_signals[CLICKED_SIGNAL] =
		g_signal_new ("clicked",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (EcButtonClass, clicked),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

	c->clicked = NULL;
#line 375 "ec-button.gob"
	gtk_widget_class->style_set = ___19_ec_button_style_set;
#line 393 "ec-button.gob"
	gtk_widget_class->expose_event = ___1a_ec_button_expose_event;
#line 268 "ec-button.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_int
		("btn_down_offset" /* name */,
		 _("Button down offset") /* nick */,
		 _("Offset by which button is moved to right-down direction when it is in a pressed-down state") /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_BTN_DOWN_OFFSET,
		param_spec);
	param_spec = g_param_spec_boolean
		("center_vertically" /* name */,
		 _("Center graphics vertically") /* nick */,
		 _("Whether or not to center the graphics also vertically") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CENTER_VERTICALLY,
		param_spec);
	param_spec = g_param_spec_boolean
		("center_text_vertically" /* name */,
		 _("Center text vertically") /* nick */,
		 _("Whether or not to center the text also vertically") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CENTER_TEXT_VERTICALLY,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 100 "ec-button.gob"
static void 
ec_button_init (EcButton * self G_GNUC_UNUSED)
#line 311 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,EC_TYPE_BUTTON,EcButtonPrivate);
#line 20 "ec-button.gob"
	self->_priv->label_text =  g_strdup("") ;
#line 317 "ec-button.c"
#line 23 "ec-button.gob"
	self->_priv->title_text =  g_strdup("") ;
#line 320 "ec-button.c"
 {
#line 101 "ec-button.gob"

		gint i = 0;
		for(i = 0; i < EC_BUTTON_STATE_COUNT; i++)
		{
			self->_priv->bg_pixbuf[i] = NULL;
		}
		self->_priv->icon_pixbuf = NULL;
		self->_priv->state = EC_BUTTON_STATE_RELEASED;
		self->_priv->cursor_inside = FALSE;

		self->_priv->layout_label = gtk_widget_create_pango_layout(
				GTK_WIDGET(self),
				NULL);
		g_object_ref(self->_priv->layout_label);

		self->_priv->layout_title = gtk_widget_create_pango_layout(
				GTK_WIDGET(self),
				NULL);
		g_object_ref(self->_priv->layout_title);

		g_signal_connect(G_OBJECT(self), "realize",
				G_CALLBACK(self_realize), NULL);

		g_signal_connect(G_OBJECT(self), "enter-notify-event",
				G_CALLBACK(self_enter_notify_event), NULL);

		g_signal_connect(G_OBJECT(self), "leave-notify-event",
				G_CALLBACK(self_leave_notify_event), NULL);

		g_signal_connect(G_OBJECT(self), "button-press-event",
				G_CALLBACK(self_button_press_event), NULL);

		g_signal_connect(G_OBJECT(self), "button-release-event",
				G_CALLBACK(self_button_release_event), NULL);
	
#line 358 "ec-button.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Ec:Button::set_property"
{
	EcButton *self G_GNUC_UNUSED;

	self = EC_BUTTON (object);

	switch (property_id) {
	case PROP_BTN_DOWN_OFFSET:
		{
#line 28 "ec-button.gob"
self->_priv->btn_down_offset = g_value_get_int (VAL);
#line 379 "ec-button.c"
		}
		break;
	case PROP_CENTER_VERTICALLY:
		{
#line 40 "ec-button.gob"

			self->_priv->center_vertically =
				g_value_get_boolean(VAL);
			self_repaint(self);
		
#line 390 "ec-button.c"
		}
		break;
	case PROP_CENTER_TEXT_VERTICALLY:
		{
#line 56 "ec-button.gob"

			self->_priv->center_text_vertically =
				g_value_get_boolean(VAL);
			self_repaint(self);
		
#line 401 "ec-button.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Ec:Button::get_property"
{
	EcButton *self G_GNUC_UNUSED;

	self = EC_BUTTON (object);

	switch (property_id) {
	case PROP_BTN_DOWN_OFFSET:
		{
#line 28 "ec-button.gob"
g_value_set_int (VAL, self->_priv->btn_down_offset);
#line 432 "ec-button.c"
		}
		break;
	case PROP_CENTER_VERTICALLY:
		{
#line 45 "ec-button.gob"

			g_value_set_boolean(VAL,
					self->_priv->center_vertically);
		
#line 442 "ec-button.c"
		}
		break;
	case PROP_CENTER_TEXT_VERTICALLY:
		{
#line 61 "ec-button.gob"

			g_value_set_boolean(VAL,
					self->_priv->center_text_vertically);
		
#line 452 "ec-button.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 28 "ec-button.gob"
gint 
ec_button_get_btn_down_offset (EcButton * self)
#line 471 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_btn_down_offset"
{
#line 28 "ec-button.gob"
		gint val; g_object_get (G_OBJECT (self), "btn_down_offset", &val, NULL); return val;
}}
#line 478 "ec-button.c"
#undef __GOB_FUNCTION__

#line 28 "ec-button.gob"
void 
ec_button_set_btn_down_offset (EcButton * self, gint val)
#line 484 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_btn_down_offset"
{
#line 28 "ec-button.gob"
		g_object_set (G_OBJECT (self), "btn_down_offset", val, NULL);
}}
#line 491 "ec-button.c"
#undef __GOB_FUNCTION__

#line 45 "ec-button.gob"
gboolean 
ec_button_get_center_vertically (EcButton * self)
#line 497 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_center_vertically"
{
#line 35 "ec-button.gob"
		gboolean val; g_object_get (G_OBJECT (self), "center_vertically", &val, NULL); return val;
}}
#line 504 "ec-button.c"
#undef __GOB_FUNCTION__

#line 40 "ec-button.gob"
void 
ec_button_set_center_vertically (EcButton * self, gboolean val)
#line 510 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_center_vertically"
{
#line 35 "ec-button.gob"
		g_object_set (G_OBJECT (self), "center_vertically", val, NULL);
}}
#line 517 "ec-button.c"
#undef __GOB_FUNCTION__

#line 61 "ec-button.gob"
gboolean 
ec_button_get_center_text_vertically (EcButton * self)
#line 523 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_center_text_vertically"
{
#line 51 "ec-button.gob"
		gboolean val; g_object_get (G_OBJECT (self), "center_text_vertically", &val, NULL); return val;
}}
#line 530 "ec-button.c"
#undef __GOB_FUNCTION__

#line 56 "ec-button.gob"
void 
ec_button_set_center_text_vertically (EcButton * self, gboolean val)
#line 536 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_center_text_vertically"
{
#line 51 "ec-button.gob"
		g_object_set (G_OBJECT (self), "center_text_vertically", val, NULL);
}}
#line 543 "ec-button.c"
#undef __GOB_FUNCTION__


#line 143 "ec-button.gob"
GtkWidget * 
ec_button_new (void)
#line 550 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::new"
{
#line 144 "ec-button.gob"
	
		EcButton *widget = GET_NEW;
		return (GtkWidget *)widget;
	}}
#line 559 "ec-button.c"
#undef __GOB_FUNCTION__

#line 152 "ec-button.gob"
void 
ec_button_set_label_text (EcButton * self, const gchar * text)
#line 565 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_label_text"
#line 152 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 152 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 572 "ec-button.c"
{
#line 153 "ec-button.gob"
	
		self->_priv->label_text = g_strdup(text);
		pango_layout_set_markup(self->_priv->layout_label, text, -1);
		self_repaint(self);
	}}
#line 580 "ec-button.c"
#undef __GOB_FUNCTION__

#line 159 "ec-button.gob"
const gchar * 
ec_button_get_label_text (EcButton * self)
#line 586 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_label_text"
#line 159 "ec-button.gob"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
#line 159 "ec-button.gob"
	g_return_val_if_fail (EC_IS_BUTTON (self), (const gchar * )0);
#line 593 "ec-button.c"
{
#line 160 "ec-button.gob"
	
		return self->_priv->label_text;
	}}
#line 599 "ec-button.c"
#undef __GOB_FUNCTION__

#line 167 "ec-button.gob"
void 
ec_button_set_title_text (EcButton * self, const gchar * text)
#line 605 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_title_text"
#line 167 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 167 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 612 "ec-button.c"
{
#line 168 "ec-button.gob"
	
		self->_priv->title_text = g_strdup(text);
		pango_layout_set_markup(self->_priv->layout_title, text, -1);
		self_repaint(self);
	}}
#line 620 "ec-button.c"
#undef __GOB_FUNCTION__

#line 174 "ec-button.gob"
const gchar * 
ec_button_get_title_text (EcButton * self)
#line 626 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_title_text"
#line 174 "ec-button.gob"
	g_return_val_if_fail (self != NULL, (const gchar * )0);
#line 174 "ec-button.gob"
	g_return_val_if_fail (EC_IS_BUTTON (self), (const gchar * )0);
#line 633 "ec-button.c"
{
#line 175 "ec-button.gob"
	
		return self->_priv->title_text;
	}}
#line 639 "ec-button.c"
#undef __GOB_FUNCTION__

#line 188 "ec-button.gob"
void 
ec_button_set_bg_image (EcButton * self, EcButtonState state, const gchar * path)
#line 645 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_bg_image"
#line 188 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 188 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 652 "ec-button.c"
{
#line 192 "ec-button.gob"
	
		gint i;
		GError *error = NULL;
		GdkPixbuf *new_pixbuf = NULL;
		g_return_if_fail(
				(0 <= state)
			       && (state < EC_BUTTON_STATE_COUNT));

		if(self->_priv->bg_pixbuf[state])
		{
			gdk_pixbuf_unref(self->_priv->bg_pixbuf[state]);
			self->_priv->bg_pixbuf[state] = NULL;
		}
		if(!path)
		{
			return;
		}

		new_pixbuf = gdk_pixbuf_new_from_file(path, &error);
		if(error)
		{
			g_warning("Unable to load image %s: %s",
					path,
					error->message);
			return;
		}
		self->_priv->bg_pixbuf[state] = new_pixbuf;

		if(state == EC_BUTTON_STATE_RELEASED)
		{
			for(i = 0; i < EC_BUTTON_STATE_COUNT; i++)
			{
				if(self->_priv->bg_pixbuf[i] == NULL)
				{
					g_object_ref(G_OBJECT(new_pixbuf));
					self->_priv->bg_pixbuf[i] = new_pixbuf;
				}
			}
		}
		self_repaint(self);
	}}
#line 696 "ec-button.c"
#undef __GOB_FUNCTION__

#line 234 "ec-button.gob"
void 
ec_button_set_bg_image_pixbuf (EcButton * self, EcButtonState state, GdkPixbuf * pixbuf)
#line 702 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_bg_image_pixbuf"
#line 234 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 234 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 709 "ec-button.c"
{
#line 238 "ec-button.gob"
	
		gint i;

		if(self->_priv->bg_pixbuf[state])
		{
			gdk_pixbuf_unref(self->_priv->bg_pixbuf[state]);
		}
		self->_priv->bg_pixbuf[state] = pixbuf;
		if(pixbuf)
		{
			g_object_ref(G_OBJECT(pixbuf));
			if(state == EC_BUTTON_STATE_RELEASED)
			{
				for(i = 0; i < EC_BUTTON_STATE_COUNT; i++)
				{
					if(self->_priv->bg_pixbuf[i] == NULL)
					{
						g_object_ref(G_OBJECT(pixbuf));
						self->_priv->bg_pixbuf[i] =
							pixbuf;
					}
				}
			}
		}
		self_repaint(self);
	}}
#line 738 "ec-button.c"
#undef __GOB_FUNCTION__

#line 265 "ec-button.gob"
void 
ec_button_set_icon (EcButton * self, const gchar * path)
#line 744 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_icon"
#line 265 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 265 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 751 "ec-button.c"
{
#line 268 "ec-button.gob"
	
		GError *error = NULL;
		GdkPixbuf *new_pixbuf = NULL;

		if(self->_priv->icon_pixbuf)
		{
			gdk_pixbuf_unref(self->_priv->icon_pixbuf);
			self->_priv->icon_pixbuf = NULL;
		}
		if(!path)
		{
			return;
		}

		new_pixbuf = gdk_pixbuf_new_from_file(path, &error);
		if(error)
		{
			g_warning("Unable to load image %s: %s",
					path,
					error->message);
			return;
		}
		self->_priv->icon_pixbuf = new_pixbuf;
		self_repaint(self);
	}}
#line 779 "ec-button.c"
#undef __GOB_FUNCTION__

#line 294 "ec-button.gob"
void 
ec_button_set_icon_pixbuf (EcButton * self, GdkPixbuf * pixbuf)
#line 785 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_icon_pixbuf"
#line 294 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 294 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 792 "ec-button.c"
{
#line 297 "ec-button.gob"
	
		if(self->_priv->icon_pixbuf)
		{
			gdk_pixbuf_unref(self->_priv->icon_pixbuf);
		}
		self->_priv->icon_pixbuf = pixbuf;
		if(pixbuf)
		{
			g_object_ref(pixbuf);
		}
		self_repaint(self);
	}}
#line 807 "ec-button.c"
#undef __GOB_FUNCTION__

#line 310 "ec-button.gob"
void 
ec_button_set_font_description_label (EcButton * self, const PangoFontDescription * desc)
#line 813 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_font_description_label"
#line 310 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 310 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 310 "ec-button.gob"
	g_return_if_fail (desc != NULL);
#line 822 "ec-button.c"
{
#line 314 "ec-button.gob"
	
		pango_layout_set_font_description(
				self->_priv->layout_label,
				desc);
	}}
#line 830 "ec-button.c"
#undef __GOB_FUNCTION__

#line 320 "ec-button.gob"
const PangoFontDescription * 
ec_button_get_font_description_label (EcButton * self)
#line 836 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_font_description_label"
#line 320 "ec-button.gob"
	g_return_val_if_fail (self != NULL, (const PangoFontDescription * )0);
#line 320 "ec-button.gob"
	g_return_val_if_fail (EC_IS_BUTTON (self), (const PangoFontDescription * )0);
#line 843 "ec-button.c"
{
#line 321 "ec-button.gob"
	
		return pango_layout_get_font_description(
				self->_priv->layout_label);
	}}
#line 850 "ec-button.c"
#undef __GOB_FUNCTION__

#line 326 "ec-button.gob"
void 
ec_button_set_font_description_title (EcButton * self, const PangoFontDescription * desc)
#line 856 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_font_description_title"
#line 326 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 326 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 326 "ec-button.gob"
	g_return_if_fail (desc != NULL);
#line 865 "ec-button.c"
{
#line 330 "ec-button.gob"
	
		pango_layout_set_font_description(
				self->_priv->layout_title,
				desc);
	}}
#line 873 "ec-button.c"
#undef __GOB_FUNCTION__

#line 336 "ec-button.gob"
const PangoFontDescription * 
ec_button_get_font_description_title (EcButton * self)
#line 879 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_font_description_title"
#line 336 "ec-button.gob"
	g_return_val_if_fail (self != NULL, (const PangoFontDescription * )0);
#line 336 "ec-button.gob"
	g_return_val_if_fail (EC_IS_BUTTON (self), (const PangoFontDescription * )0);
#line 886 "ec-button.c"
{
#line 337 "ec-button.gob"
	
		return pango_layout_get_font_description(
				self->_priv->layout_title);
	}}
#line 893 "ec-button.c"
#undef __GOB_FUNCTION__

#line 342 "ec-button.gob"
void 
ec_button_set_alignment (EcButton * self, PangoAlignment alignment)
#line 899 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::set_alignment"
#line 342 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 342 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 906 "ec-button.c"
{
#line 343 "ec-button.gob"
	
		pango_layout_set_alignment(
				self->_priv->layout_label,
				alignment);

		pango_layout_set_alignment(
				self->_priv->layout_title,
				alignment);
	}}
#line 918 "ec-button.c"
#undef __GOB_FUNCTION__

#line 353 "ec-button.gob"
PangoAlignment 
ec_button_get_alignment (EcButton * self)
#line 924 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::get_alignment"
#line 353 "ec-button.gob"
	g_return_val_if_fail (self != NULL, (PangoAlignment )0);
#line 353 "ec-button.gob"
	g_return_val_if_fail (EC_IS_BUTTON (self), (PangoAlignment )0);
#line 931 "ec-button.c"
{
#line 354 "ec-button.gob"
	
		return pango_layout_get_alignment(self->_priv->layout_label);
	}}
#line 937 "ec-button.c"
#undef __GOB_FUNCTION__

#line 359 "ec-button.gob"
void 
ec_button_clicked (EcButton * self)
#line 943 "ec-button.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 359 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 359 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 955 "ec-button.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[CLICKED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 367 "ec-button.gob"
static void 
ec_button_repaint (EcButton * self)
#line 972 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::repaint"
#line 367 "ec-button.gob"
	g_return_if_fail (self != NULL);
#line 367 "ec-button.gob"
	g_return_if_fail (EC_IS_BUTTON (self));
#line 979 "ec-button.c"
{
#line 368 "ec-button.gob"
	
		gtk_widget_queue_draw(GTK_WIDGET(self));
	}}
#line 985 "ec-button.c"
#undef __GOB_FUNCTION__

#line 375 "ec-button.gob"
static void 
___19_ec_button_style_set (GtkWidget * widget G_GNUC_UNUSED, GtkStyle * prev_style)
#line 991 "ec-button.c"
#define PARENT_HANDLER(___widget,___prev_style) \
	{ if(GTK_WIDGET_CLASS(parent_class)->style_set) \
		(* GTK_WIDGET_CLASS(parent_class)->style_set)(___widget,___prev_style); }
{
#define __GOB_FUNCTION__ "Ec:Button::style_set"
#line 375 "ec-button.gob"
	g_return_if_fail (widget != NULL);
#line 375 "ec-button.gob"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 1001 "ec-button.c"
{
#line 378 "ec-button.gob"
	
		EcButton *self = EC_BUTTON(widget);
		pango_layout_context_changed(self->_priv->layout_label);
		pango_layout_context_changed(self->_priv->layout_title);
	}}
#line 1009 "ec-button.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 393 "ec-button.gob"
static gboolean 
___1a_ec_button_expose_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventExpose * event)
#line 1016 "ec-button.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->expose_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->expose_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Ec:Button::expose_event"
{
#line 396 "ec-button.gob"
	
		EcButton *self = EC_BUTTON(widget);
		EcButtonState state;
		GdkDrawable *drawable = GDK_DRAWABLE(widget->window);
		GdkPixbuf *pxb;
		GdkGC *gc = NULL;
		gint self_w, self_h;
		gint w, h;
		PangoRectangle rect;
		gint x, y;
		gboolean is_down;

		state = self->_priv->state;

		/* Draw the background */
		if(state == EC_BUTTON_STATE_DOWN && self->_priv->cursor_inside)
		{
			is_down = TRUE;
			pxb = self->_priv->bg_pixbuf[EC_BUTTON_STATE_DOWN];
		} else {
			is_down = FALSE;
			pxb = self->_priv->bg_pixbuf[EC_BUTTON_STATE_RELEASED];
		}

		if(strcmp(self->_priv->title_text, "") != 0)
		{
			self_expose_with_title(widget, event, is_down);
			return FALSE;
		}

		self_w = widget->allocation.width;
		self_h = widget->allocation.height;

		gc = gdk_gc_new(drawable);

		if(pxb)
		{

			w = gdk_pixbuf_get_width(pxb);
			h = gdk_pixbuf_get_height(pxb);

			x = (self_w - w) / 2;
			if(self->_priv->center_vertically)
			{
				y = (self_h - h) / 2;
			} else {
				y = 0;
			}

			if(is_down)
			{
				x += self->_priv->btn_down_offset;
				y += self->_priv->btn_down_offset;
			}

			gdk_draw_pixbuf(drawable,
					gc,
					pxb,
					0, 0,
					x, y,
					w, h,
					GDK_RGB_DITHER_MAX,
					0, 0);
		} else {
			w = 0;
			h = 0;
		}

		/* Draw the icon */
		pxb = self->_priv->icon_pixbuf;
		if(pxb)
		{

			w = gdk_pixbuf_get_width(pxb);
			h = gdk_pixbuf_get_height(pxb);

			x = (self_w - w) / 2;
			if(self->_priv->center_vertically)
			{
				y = (self_h - h) / 2;
			} else {
				y = 0;
			}

			if(is_down)
			{
				x += self->_priv->btn_down_offset;
				y += self->_priv->btn_down_offset;
			}

			gdk_draw_pixbuf(drawable,
					gc,
					pxb,
					0, 0,
					x, y,
					w, h,
					GDK_RGB_DITHER_MAX,
					0, 0);
		}

		/* Draw the label */
		pango_layout_get_pixel_extents(self->_priv->layout_label,
				NULL, &rect);

		x = (self_w - rect.width) / 2;
		if(x < 0)
		{
			x = 0;
		}

		if(self->_priv->center_text_vertically)
		{
			y = (self_h - rect.height) / 2;
		} else {
			y = self_h - rect.height;
		}

		if(is_down)
		{
			x += self->_priv->btn_down_offset;
			y += self->_priv->btn_down_offset;
		}

		gtk_paint_layout(widget->style,
				widget->window,
				GTK_WIDGET_STATE(widget),
				FALSE,
				&event->area,
				widget,
				NULL,
				x, y,
				self->_priv->layout_label);

		gdk_gc_unref(gc);
		return FALSE;
	}}
#line 1161 "ec-button.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 533 "ec-button.gob"
static void 
ec_button_expose_with_title (GtkWidget * widget, GdkEventExpose * event, gboolean is_down)
#line 1168 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::expose_with_title"
{
#line 537 "ec-button.gob"
	
		/* A button with title will always be drawn as follows:
		 *
		 * +------------------------------------+
		 * |                Title               |
		 * | +------+                           |
		 * | | Icon |       Label               |
		 * | +------+                           |
		 * +------------------------------------+
		 *
		 * Title and label are centered horizontally.
		 *
		 * Title, label and the icon are centered vertically
		 * in their halves of the widget.
		 *
		 * Icon is drawn near the left edge.
		 */
		EcButton *self = EC_BUTTON(widget);
		EcButtonState state;
		GdkDrawable *drawable = GDK_DRAWABLE(widget->window);
		GdkPixbuf *pxb;
		GdkGC *gc = NULL;
		gint self_w, self_h;
		gint w, h;
		gint icon_w, icon_h;
		gint total_w;
		PangoRectangle rect;
		gint x, y;

		self_w = widget->allocation.width;
		self_h = widget->allocation.height;
		state = self->_priv->state;

		/* Draw the background */
		if(is_down)
		{
			pxb = self->_priv->bg_pixbuf[EC_BUTTON_STATE_DOWN];
		} else {
			pxb = self->_priv->bg_pixbuf[EC_BUTTON_STATE_RELEASED];
		}

		gc = gdk_gc_new(drawable);

		if(pxb)
		{
			/* Draw the background image */
			w = gdk_pixbuf_get_width(pxb);
			h = gdk_pixbuf_get_height(pxb);

			x = (self_w - w) / 2;
			y = (self_h - h) / 2;

			if(is_down)
			{
				x += self->_priv->btn_down_offset;
				y += self->_priv->btn_down_offset;
			}

			gdk_draw_pixbuf(drawable,
					gc,
					pxb,
					0, 0,
					x, y,
					w, h,
					GDK_RGB_DITHER_MAX,
					0, 0);
		} else {
			w = 0;
			h = 0;
		}

		/* Draw the title */
		pango_layout_get_pixel_extents(self->_priv->layout_title,
				NULL, &rect);

		x = (self_w - rect.width) / 2;
		if(x < 0)
		{
			x = 0;
		}

		/* The upper coordinate of the background image */
		y = (self_h - h) / 2;

		/* Add the y coordinate of the text within the
		 * half-of-the-background-image block */
		y += (h / 2 - rect.height) / 2;

		if(is_down)
		{
			x += self->_priv->btn_down_offset;
			y += self->_priv->btn_down_offset;
		}

		gtk_paint_layout(widget->style,
				widget->window,
				GTK_WIDGET_STATE(widget),
				FALSE,
				&event->area,
				widget,
				NULL,
				x, y,
				self->_priv->layout_title);

		/* Draw the icon */

		/* Calculate the width of the icon+label complex */
		pango_layout_get_pixel_extents(self->_priv->layout_label,
				NULL, &rect);
		total_w = rect.width;

		pxb = self->_priv->icon_pixbuf;
		if(pxb)
		{

			icon_w = gdk_pixbuf_get_width(pxb);
			total_w += icon_w + 10; /* Add 10 pixel padding */
			icon_h = gdk_pixbuf_get_height(pxb);

			x = (self_w - w) / 2 + 10;

			/* The upper coordinate of the lower half of the
			 * background image is in the halfway of the widget */
			y = self_h / 2;

			/* Add the y coordinate of the text within the
			 * half-of-the-background-image block */
			y += (h / 2 - icon_w) / 2;

			if(is_down)
			{
				x += self->_priv->btn_down_offset;
				y += self->_priv->btn_down_offset;
			}

			gdk_draw_pixbuf(drawable,
					gc,
					pxb,
					0, 0,
					x, y,
					icon_w, icon_h,
					GDK_RGB_DITHER_MAX,
					0, 0);
		}
		x = (self_w - rect.width) / 2;
		if(is_down)
		{
			x += self->_priv->btn_down_offset;
		}

		/* Calculate the y coordinate for the label. */
		/* The upper coordinate of the lower half of the
		 * background image is in the halfway of the widget */
		y = self_h / 2;

		/* Add the y coordinate of the text within the
		 * half-of-the-background-image block */
		y += (h / 2 - rect.height) / 2;

		if(is_down)
		{
			y += self->_priv->btn_down_offset;
		}

		gtk_paint_layout(widget->style,
				widget->window,
				GTK_WIDGET_STATE(widget),
				FALSE,
				&event->area,
				widget,
				NULL,
				x, y,
				self->_priv->layout_label);

		gdk_gc_unref(gc);
	}}
#line 1349 "ec-button.c"
#undef __GOB_FUNCTION__

#line 714 "ec-button.gob"
static gboolean 
ec_button_button_press_event (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1355 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::button_press_event"
{
#line 718 "ec-button.gob"
	
		EcButton *self = NULL;

		self = EC_BUTTON(widget);
		self->_priv->state = EC_BUTTON_STATE_DOWN;
		self_repaint(self);
		return FALSE;
	}}
#line 1368 "ec-button.c"
#undef __GOB_FUNCTION__

#line 727 "ec-button.gob"
static gboolean 
ec_button_enter_notify_event (GtkWidget * widget, GdkEventCrossing * event)
#line 1374 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::enter_notify_event"
{
#line 730 "ec-button.gob"
	
		EcButton *self = NULL;
		GtkWidget *event_widget = NULL;

		self = EC_BUTTON(widget);

		event_widget = gtk_get_event_widget((GdkEvent *)event);
		if((event_widget != widget) ||
				event->detail == GDK_NOTIFY_INFERIOR)
		{
			return FALSE;
		}
		self->_priv->cursor_inside = TRUE;
		self_repaint(self);
		return FALSE;
	}}
#line 1395 "ec-button.c"
#undef __GOB_FUNCTION__

#line 747 "ec-button.gob"
static gboolean 
ec_button_leave_notify_event (GtkWidget * widget, GdkEventCrossing * event)
#line 1401 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::leave_notify_event"
{
#line 750 "ec-button.gob"
	
		EcButton *self = NULL;
		GtkWidget *event_widget = NULL;

		self = EC_BUTTON(widget);

		event_widget = gtk_get_event_widget((GdkEvent *)event);
		if((event_widget != widget) ||
				event->detail == GDK_NOTIFY_INFERIOR)
		{
			return FALSE;
		}
		self->_priv->cursor_inside = FALSE;
		self_repaint(self);
		return FALSE;
	}}
#line 1422 "ec-button.c"
#undef __GOB_FUNCTION__

#line 767 "ec-button.gob"
static gboolean 
ec_button_button_release_event (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1428 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::button_release_event"
{
#line 771 "ec-button.gob"
	
		EcButton *self = EC_BUTTON(widget);
		self->_priv->state = EC_BUTTON_STATE_RELEASED;
		self_repaint(self);
		if(self->_priv->cursor_inside)
		{
			g_signal_emit(
					self,
					object_signals[CLICKED_SIGNAL],
					0
					);
		}
		return FALSE;
	}}
#line 1447 "ec-button.c"
#undef __GOB_FUNCTION__

#line 786 "ec-button.gob"
static void 
ec_button_realize (GtkWidget * widget, gpointer user_data)
#line 1453 "ec-button.c"
{
#define __GOB_FUNCTION__ "Ec:Button::realize"
{
#line 789 "ec-button.gob"
	
		GdkEventMask event_mask;
		event_mask = gdk_window_get_events(widget->window);
		event_mask |= GDK_BUTTON_RELEASE_MASK |
			GDK_BUTTON_PRESS_MASK |
			GDK_ENTER_NOTIFY_MASK |
			GDK_LEAVE_NOTIFY_MASK;
		gdk_window_set_events(widget->window, event_mask);
	}}
#line 1467 "ec-button.c"
#undef __GOB_FUNCTION__
