/*
 * This file is part of maptile-loader
 * Copyright (C) 2007  Pekka Rönkkö (pronkko@gmail.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef __MAPTILE_MODULE_H__
#define __MAPTILE_MODULE_H__

#include <glib-object.h>
#include <gmodule.h>

G_BEGIN_DECLS


#define MAPTILE_TYPE_MODULE         (maptile_module_get_type ())
#define MAPTILE_MODULE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), \
                                 MAPTILE_TYPE_MODULE, MaptileModule))
#define MAPTILE_MODULE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), \
                                 MAPTILE_TYPE_MODULE, MaptileModuleClass))
#define MAPTILE_IS_MODULE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), \
                                 MAPTILE_TYPE_MODULE))
#define MAPTILE_IS_MODULE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), \
                                 MAPTILE_TYPE_MODULE))
#define MAPTILE_MODULE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), \
                                 MAPTILE_TYPE_MODULE, MaptileModuleClass))


typedef struct _MaptileModule      MaptileModule;
typedef struct _MaptileModuleClass MaptileModuleClass;

struct _MaptileModule
{
  GTypeModule  parent_instance;

  gchar       *filename;
  GModule     *library;

  /*  module symbols  */
  void (* load)   (MaptileModule *module);
  void (* unload) (MaptileModule *module);
};

struct _MaptileModuleClass
{
  GTypeModuleClass  parent_class;
};


GType       maptile_module_get_type (void) G_GNUC_CONST;

MaptileModule * maptile_module_new      (const gchar *filename);


/* API for the modules to implement */

void        maptile_module_load     (MaptileModule   *module);
void        maptile_module_unload   (MaptileModule   *module);

G_END_DECLS

#endif /* __MAPTILE_MODULE_H_ */
