/* e-vard-store.h - A GtkTreeModel implementation that stores the attributes
 * of a EVcard
 *
 * Copyright (C) 2008 Nokia Corp.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Joergen Scheibengruber <jorgen.scheibengruber AT nokia.com>
 */

#ifndef __E_VCARD_STORE_H__
#define __E_VCARD_STORE_H__

#include <gtk/gtktreemodel.h>
#include <libebook/e-book-view.h>

G_BEGIN_DECLS

#define E_VCARD_STORE_TYPE            (e_vcard_store_get_type ())
#define E_VCARD_STORE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_VCARD_STORE_TYPE, EVCardStore))
#define E_VCARD_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), E_VCARD_STORE_TYPE, EVCardStoreClass))
#define IS_E_VCARD_STORE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_VCARD_STORE_TYPE))
#define IS_E_VCARD_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), E_VCARD_STORE_TYPE))
#define E_VCARD_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), E_VCARD_STORE_TYPE, EVCardStoreClass))

typedef struct _EVCardStore       EVCardStore;
typedef struct _EVCardStoreClass  EVCardStoreClass;
typedef enum   _EVCardStoreColumn EVCardStoreColumn;

struct _EVCardStoreClass
{
    GObjectClass parent_class;
};

struct _EVCardStore
{
    GObject parent;
};

enum _EVCardStoreColumn
{
    EVCARD_STORE_COLUMN_NAME,
    EVCARD_STORE_COLUMN_GROUP,
    EVCARD_STORE_COLUMN_PARAMS,
    EVCARD_STORE_COLUMN_VALUES,

    EVCARD_STORE_COLUMN_LAST
};

GType e_vcard_store_get_type (void);

EVCardStore* e_vcard_store_new            (void);
EVCardStore* e_vcard_store_new_from_vcard (EVCard *vcard);
void         e_vcard_store_set_vcard      (EVCardStore* store, EVCard *vcard);
EVCard*      e_vcard_store_get_vcard      (EVCardStore* store);
void   e_vcard_store_set_attribute_params (EVCardStore *store, GtkTreeIter *iter, GList *params);
void   e_vcard_store_set_attribute_values (EVCardStore *store, GtkTreeIter *iter, GList *values);
void   e_vcard_store_append_attribute     (EVCardStore *store, const char *name, const char *group);
void   e_vcard_store_remove_attribute     (EVCardStore *store, GtkTreeIter *iter);

G_END_DECLS

#endif
