/* e-contact-store.h - A GtkTreeModel implementation that stores EContacts
 *
 * Copyright (C) 2008 Nokia Corp.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Joergen Scheibengruber <jorgen.scheibengruber AT nokia.com>
 */

#ifndef __E_CONTACT_STORE_H__
#define __E_CONTACT_STORE_H__

#include <gtk/gtktreemodel.h>
#include <libebook/e-book-view.h>

G_BEGIN_DECLS

#define E_CONTACT_STORE_TYPE            (e_contact_store_get_type ())
#define E_CONTACT_STORE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_CONTACT_STORE_TYPE, EContactStore))
#define E_CONTACT_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), E_CONTACT_STORE_TYPE, EContactStoreClass))
#define IS_E_CONTACT_STORE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_CONTACT_STORE_TYPE))
#define IS_E_CONTACT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), E_CONTACT_STORE_TYPE))
#define E_CONTACT_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), E_CONTACT_STORE_TYPE, EContactStoreClass))

typedef struct _EContactStore      EContactStore;
typedef struct _EContactStoreClass EContactStoreClass;

typedef int (*EContactCompareFunc) (EContact *a, EContact *b, gpointer user_data);

struct _EContactStoreClass
{
    GObjectClass parent_class;
};

struct _EContactStore
{
    GObject parent;
};

GType e_contact_store_get_type (void);

EContactStore* e_contact_store_new                (void);
EContactStore* e_contact_store_new_with_book_view (EBookView *book_view);
void           e_contact_store_set_book_view      (EContactStore *store, EBookView *book_view);
EBookView*     e_contact_store_get_book_view      (EContactStore *store);
void           e_contact_store_set_sort_func      (EContactStore *store, EContactCompareFunc compare_func);

G_END_DECLS

#endif
