#!/usr/bin/env python

##########################################################################
# EasyPlayer
#
# a mp3/ogg/aac/wav (whatever gstreamer supports) audio player
# for Maemo 5 on the N900
# written 2010 by Klaus Rotter (klaus at rotters dot de)
# (c) 2010 by Klaus Rotter, distribution GPL
#
# History
#
# 0.1	2010-03-09	First steps, based on a gstreamer+python example
#			added a treeview widget with code to scan and
#			display /home/usr/MyDocs/.sounds
# 0.2	2010-03-22	added code to load/save/display prefs, added timeout
#			bug fixing			
#
##########################################################################

import sys, os, thread, time, string, pickle
import pygtk, gtk, gobject
import pygst
pygst.require("0.10")
import gst
import hildon

class GTK_Main:
  def __init__(self):
    # Some global variables are defined here
    self.dir_l = []      # list to store the directorys containing music files
    self.dc = 0          # actual number of directory
    self.file_l = []     # list to store filenames of music files
    
    self.play_name = ""
    self.act_file_id = 0
    self.max_files = 0

    self.pause_pos = 0;
    self.pause_flag = 0;

    self.prefsfile = "/home/user/MyDocs/.easyplayer/preferences"

    self.prefs = {
      "lastfile":0,		# id of last played file
      "lastpos":0,		# position in seconds
      "hideext":0,		# Hide filename extention, eg. ".mp3",".ogg"
      "displaytimeout":1,	# Show the remaining time until timeout
      "resumeplay":0,		# resume playing last file
      "timeout":3,		# timeout in minutes, 3 ist 30 minutes
      "bigbuttons":0		# Use HILDON_THUMB_SIZE if 1
    }
    
    # Try to load the preferences
    if os.path.isfile(self.prefsfile):
      try:
        fd = open(self.prefsfile)
        self.prefs = pickle.load(fd) # overwrite default values
        fd.close()
      except:
        print "Can't load prefernces"
    self.act_file_id = self.prefs["lastfile"]    
    
    if self.prefs["bigbuttons"] == 1: 
      self.std_size = gtk.HILDON_SIZE_AUTO|gtk.HILDON_SIZE_THUMB_HEIGHT
    else:
      self.std_size = gtk.HILDON_SIZE_AUTO|gtk.HILDON_SIZE_FINGER_HEIGHT
    
    self.timeout = 0;
    self.reset_timer() # Reset TimeOut Timer
    
    program = hildon.Program.get_instance()
    gtk.set_application_name("EasyPlayer")
   
    self.base_media_dir = "/home/user/MyDocs/.sounds/"
    self.rescan(self.base_media_dir)
	
    self.window = hildon.StackableWindow()
    program.add_window(self.window)

    self.window.set_title("Easy Player")
    self.window.connect("destroy", gtk.main_quit, "WM destroy")

    # Add a menu
    menu = hildon.AppMenu()

    self.pref_btn = hildon.GtkButton(self.std_size)
    self.pref_btn.set_label("Preferences");
    self.pref_btn.connect("clicked",self.show_pref_win_cb)
    menu.append(self.pref_btn)

    self.scan_btn = hildon.GtkButton(self.std_size)
    self.scan_btn.set_label("Rescan Files");
    self.scan_btn.connect("clicked",self.menu_rescan_cb, self.scan_btn)
    menu.append(self.scan_btn)

    self.about_btn = hildon.GtkButton(self.std_size)
    self.about_btn.set_label("About");
    self.about_btn.connect("clicked",self.menu_about_cb, self.about_btn)
    menu.append(self.about_btn)

    menu.show_all()
    self.window.set_app_menu(menu)
        
    vbox = gtk.VBox()
    self.window.add(vbox)
		
    panarea = hildon.PannableArea()
    #hildon.hildon_pannable_area_new_full(mode, enabled, vel_min, vel_max, decel, sps)	
    
    # create a TreeStore with one string column to use as the model
    self.treestore = gtk.TreeStore(str)

    # we'll add some data now - 4 rows with 3 child rows each
    #for parent in range(4):
    #  piter = self.treestore.append(None, ['parent %i' % parent])
    #  for child in range(3):
    #    self.treestore.append(piter, ['child %i of parent %i' %
    #    	(child, parent)])
    
    last_dir = -1
    parent = None   	
    for i in self.file_l:
      if i[1] > last_dir: # must we add a new parent dir?
        last_dir = i[1]
        d = self.dir_l[last_dir]
        if d == self.base_media_dir: # don't add dir if it' base dir
          parent = None
        else: # add a new parent  
          parent = self.treestore.append(None, [ self.get_parent_dir(d) ])    
      # add new entry    
      self.treestore.append(parent,[ i[0] ])

    # create the TreeView using treestore
    self.treeview = gtk.TreeView(self.treestore)
    # create the TreeViewColumn to display the data
    self.tvcolumn = gtk.TreeViewColumn('Song')

    # add tvcolumn to treeview
    self.treeview.append_column(self.tvcolumn)

    # create a CellRendererText to render the data
    self.cell = gtk.CellRendererText()
    # add the cell to the tvcolumn and allow it to expand
    self.tvcolumn.pack_start(self.cell, True)
    # set the cell "text" attribute to column 0 - retrieve text
    # from that column in treestore
    self.tvcolumn.add_attribute(self.cell, 'text', 0)

    # make it searchable
    self.treeview.set_search_column(0)
    # Allow sorting on the column
    self.tvcolumn.set_sort_column_id(0)

    # Allow drag and drop reordering of rows
    self.treeview.set_reorderable(True)

    self.treeview.get_selection().set_mode(gtk.SELECTION_SINGLE) 
    self.treeview.connect("row-activated", self.tv_row_activated_cb)

    panarea.add(self.treeview)
    vbox.pack_start(panarea, True, True)
			
    #self.entry = hildon.Entry(self.std_size)
    #self.entry.set_text("/home/user/MyDocs/mary.ogg")
    #vbox.pack_start(self.entry, False, True)

    # Create the ProgressBar
    self.pbar = gtk.ProgressBar()
    vbox.pack_start(self.pbar, False, True)
    self.pbar.show()
    self.pbar.set_text("00:00 / 00:00")

    buttonbox = gtk.HBox()

    prev_btn = self.new_button(gtk.STOCK_MEDIA_PREVIOUS)
    prev_btn.connect("clicked", self.prev_cb)
    buttonbox.add(prev_btn)
		
    rew_btn = self.new_button(gtk.STOCK_MEDIA_REWIND)
    rew_btn.connect("clicked", self.rewind_cb)
    buttonbox.add(rew_btn)

    # Use own images, allow us to switch
    # Play images and button nmust be public
    self.play_img = gtk.Image()
    self.set_play_img()

    self.play_btn = hildon.GtkButton(self.std_size)
    self.play_btn.add(self.play_img)
    self.play_btn.connect("clicked", self.play_pause_cb)
    buttonbox.add(self.play_btn)

    stop_btn = self.new_button(gtk.STOCK_MEDIA_STOP)
    stop_btn.connect("clicked", self.stop_cb)
    buttonbox.add(stop_btn)

    forward_btn = self.new_button(gtk.STOCK_MEDIA_FORWARD)
    forward_btn.connect("clicked", self.forward_cb)
    buttonbox.add(forward_btn)

    next_btn = self.new_button(gtk.STOCK_MEDIA_NEXT)
    next_btn.connect("clicked", self.next_cb)
    buttonbox.add(next_btn)

    #self.lbl_time = gtk.Label()
    #self.lbl_time.set_text("00:00 / 00:00")
    #buttonbox.add(self.lbl_time)
		
    vbox.pack_start(buttonbox,False,True)	
    self.window.show_all()
		
    self.player = gst.element_factory_make("playbin2", "player")
    fakesink = gst.element_factory_make("fakesink", "fakesink")
    self.player.set_property("video-sink", fakesink)
    bus = self.player.get_bus()
    bus.add_signal_watch()
    bus.connect("message", self.on_message)
    self.running = False;
    self.time_format = gst.Format(gst.FORMAT_TIME)
    if self.prefs["resumeplay"] == 1:
      self.play_pause_h()

  # Thread to display time / update process bar while running
  # copied from pygst tutorial
  def play_thread(self):
    play_thread_id = self.play_thread_id
    oldtime = time.time()
    gtk.gdk.threads_enter()
    self.reset_bar()
    gtk.gdk.threads_leave()
    while play_thread_id == self.play_thread_id:
      try:
        time.sleep(0.2)
        dur_int = self.player.query_duration(self.time_format, None)[0]
        dur_str = self.convert_ns(dur_int)
        gtk.gdk.threads_enter()
	self.pbar.set_text(self.play_name + " - 00:00 / " + dur_str)
        gtk.gdk.threads_leave()
	break
      except:
        pass
    time.sleep(0.2)
    #
    # Main Thread for displaying time infos etc.
    #
    while play_thread_id == self.play_thread_id:
      try: 
        pos_int = self.player.query_position(self.time_format, None)[0]
        pos_str = self.convert_ns(pos_int)
        # Do we use timeout for suspend?
        if self.timeout <> -1:
          if self.timeout > 0: 
            newtime = time.time()
            self.timeout = self.timeout - int(newtime-oldtime)
            oldtime = newtime
          else: # Timeout is reached, suspend player
            self.stop_reset() # prepare stopping of threat
            gtk.gdk.threads_enter()
            self.reset_bar()
            gtk.gdk.threads_leave()
            self.player.set_state(gst.STATE_NULL)       
            break; 	# leave threat 
          to_str = self.convert_s(self.timeout)   
        if play_thread_id == self.play_thread_id:
          gtk.gdk.threads_enter()
          # don't display time to suspend if we don't use timeour ot we disabled it
          if (self.timeout == -1) or (self.prefs["displaytimeout"] == 0):
            self.pbar.set_text(self.play_name + " - " + pos_str + " / " + dur_str)
          else:
            self.pbar.set_text(self.play_name + " - " + pos_str + " / " + dur_str + " -- " + to_str)
          if dur_int <> 0:  
            self.pbar.set_fraction(float(pos_int) / float(dur_int))
          gtk.gdk.threads_leave()
        time.sleep(1)
      except:
        time.sleep(0.2)
      
  # Extracs the parent directory name of a given path
  #
  def get_parent_dir(self, path):
    (rest, name) = os.path.split(path)
    if name == '': # if the path ends with '/', we get an empty string
      name = os.path.split(rest)[1] # repeat to get the name
    return name        

  # Resan given dir and subdirs for audio files.
  #
  def rescan(self, dir):
    if not dir.endswith(os.sep):
      dir = dir + os.sep
    self.dir_l.append(dir)
    self.dc = self.dc + 1
    d = os.listdir(dir)
    for f in d:
      if os.path.isdir(dir+f) == 1: # f is a directory
        self.rescan(dir+f)
      elif os.path.isfile(dir+f) == 1: #f is a file
        if f.endswith(".mp3") == 1 or \
          f.endswith(".wav") == 1 or \
          f.endswith(".aac") == 1 or \
          f.endswith(".ogg") == 1:
            self.file_l.append((f,self.dc-1))
            self.max_files = self.max_files + 1

  # Rescan dir for music/sound files
  #
  def menu_rescan_cb(self, btn, lbl):
    # clear fileslist
    self.dir_l = []      # list to store the directorys containing music files
    self.dc = 0          # actual number of directory
    self.file_l = []     # list to store filenames of music files
    self.max_files = 0
    self.rescan(self.base_media_dir)

  # row acivated callback is activated if a row is
  # double clicked by the user
  #
  def tv_row_activated_cb(self, tv, path, view_colum):
    self.reset_timer()
    tv.collapse_row(path)
    iter = self.treestore.get_iter(path)
    value = self.treestore.get(iter, 0)
    id = self.get_id(value[0])
    #print "Path: ",path," Value:",value," id:",id
    if id <> None:
      self.stop_h() # Stop current file if one is playing
      self.act_file_id = id
      self.play_pause_h() # Start new file  

  # Get the file_id to a given name
  #
  def get_id(self, name):
    for i in range(self.max_files):
      if name == self.file_l[i][0]:
        return i
    return None      

  # Create a button with a default stock image   
  #
  def new_button(self, stock_img):
    image = gtk.Image()
    image.set_from_stock(stock_img,gtk.ICON_SIZE_LARGE_TOOLBAR)
    image.show()
    button = hildon.GtkButton(self.std_size)
    button.add(image)
    return button

  # Set process bar to 0 and time/text to 00:00
  #
  def reset_bar(self):
    self.pbar.set_text("00:00 / 00:00")
    self.pbar.set_fraction(0.0)
	
  # Menu "About" callback - display About...
  #
  def menu_about_cb(self, btn, lbl):
    note = hildon.hildon_note_new_information(self.window, \
           "EasyPlayer was written 2010 for Maemo 5\n" \
           "by Klaus Rotter (klaus at rotters dot de)\n" \
           "Version 0.2 - March 2010")   
    response = gtk.Dialog.run(note)
    #if response == gtk.RESPONSE_DELETE_EVENT:
    #  print "show_information_note: gtk.RESPONSE_DELETE_EVENT"

  # Resets the time-out timer to its starting value (eg. 5 min to 60 min)
  #
  def reset_timer(self):
    to = self.prefs["timeout"]
    if to == 0:
      self.timeout = 5*60	# 5 minutes 
    elif to == 1:
      self.timeout = 10*60	# 10 minutes 
    elif to == 2:
      self.timeout = 20*60	# 20 minutes 
    elif to == 3:
      self.timeout = 30*60	# 30 minutes 
    elif to == 4:
      self.timeout = 60*60	# 60 minutes 
    elif to > 5:	
      self.timeout = -1		# Never

  # Set Image of Button Play to "Play"
  #  
  def set_play_img(self):
    self.play_img.set_from_stock(gtk.STOCK_MEDIA_PLAY, gtk.ICON_SIZE_BUTTON)
    self.play_img.show()

  # Set Image of Button Play to "Pause"
  #  
  def set_pause_img(self):
    self.play_img.set_from_stock(gtk.STOCK_MEDIA_PAUSE, gtk.ICON_SIZE_BUTTON)
    self.play_img.show()
		
  # Start / Pause Playback
  #
  def play_pause_cb(self, w):
    self.reset_timer() # Reset TimeOut Timer
    self.play_pause_h()
  
  # Start / Pause Handler
  #
  def play_pause_h(self):
    if self.running == False:
      file_id = self.act_file_id; #which file to play?
      dir_id = self.file_l[file_id][1]
      self.play_name = self.file_l[file_id][0]
      filepath = self.dir_l[dir_id]+self.play_name
      #print filepath
      if os.path.isfile(filepath):
        self.set_pause_img()
        self.player.set_property("uri", "file://" + filepath)
        self.player.set_state(gst.STATE_PLAYING)
        if self.pause_flag:
          self.player.seek_simple(self.time_format, gst.SEEK_FLAG_FLUSH, self.pause_pos)
          self.pause_flag = 0;            
	# Start thread
	self.play_thread_id = thread.start_new_thread(self.play_thread, ())
        self.running = True
        self.prefs["lastfile"] = file_id
        self.save_prefs()
    else:
      # We are running, go to pause mode
      self.pause_pos = self.player.query_position(self.time_format, None)[0]
      self.pause_flag = True          
      self.player.set_state(gst.STATE_NULL)
      # don't self.reset_bar()
      self.stop_reset()      

  # "Stop" Button callback - Stop Playback
  #
  def stop_cb(self, w):
    self.reset_timer() # Reset TimeOut Time
    self.stop_h()

  # "Stop" Handler
  #
  def stop_h(self):
    if self.running == True:
      self.player.set_state(gst.STATE_NULL)
      self.reset_bar()
      self.stop_reset() # stop thread	
      self.pause_flag = 0;
      
  # stop_reset - restore old button
  #
  def stop_reset(self):
    self.play_thread_id = None
    self.set_play_img()
    self.running = False

  # Parse any messages from gstreamer
  #    
  def on_message(self, bus, message):
    t = message.type
    if t == gst.MESSAGE_EOS:
      if self.act_file_id < self.max_files: # Is there at least one file more to play
        self.stop_h() 		# Stop current file if one is playing
        self.act_file_id = self.act_file_id + 1
        self.play_pause_h() 	# Start new file  
      else: 			# No more files, just stop
        self.stop_h()
      
    elif t == gst.MESSAGE_ERROR:
      self.stop_h()
      err, debug = message.parse_error()
      print "Error: %s" % err, debug
    #else:
    #  print "Msg %d" % t 

  # Skip backward 10 s callback
  #
  def rewind_cb(self, w):
    self.reset_timer() # Reset TimeOut Timer
    pos_int = self.player.query_position(self.time_format, None)[0]
    seek_ns = pos_int - (10 * 1000000000)
    self.player.seek_simple(self.time_format, gst.SEEK_FLAG_FLUSH, seek_ns)

  # Skip forward 10 s callback
  #            
  def forward_cb(self, w):
    self.reset_timer() # Reset TimeOut Timer
    pos_int = self.player.query_position(self.time_format, None)[0]
    seek_ns = pos_int + (10 * 1000000000)
    self.player.seek_simple(self.time_format, gst.SEEK_FLAG_FLUSH, seek_ns)

  # Select Previous file to play
  #
  def prev_cb(self, w):
    self.reset_timer() # Reset TimeOut Timer
    if self.act_file_id > 0: # Is there at least one previous file to play
      self.stop_h() # Stop current file if one is playing
      self.act_file_id = self.act_file_id - 1
      self.play_pause_h() # Start new file  
      
  # Select next file to play
  #
  def next_cb(self, w):
    self.reset_timer() # Reset TimeOut Timer
    if self.act_file_id < self.max_files: # Is there at least one file more to play
      self.stop_h() # Stop current file if one is playing
      self.act_file_id = self.act_file_id + 1
      self.play_pause_h() # Start new file  

  # Convert a time in secondes to min:sec
  # taken from the pygst tutorial 
  #
  def convert_s(self, time_int):
    time_str = ""
    if time_int >= 3600:
      _hours = time_int / 3600
      time_int = time_int - (_hours * 3600)
      time_str = str(_hours) + ":"
    if time_int >= 600:
      _mins = time_int / 60
      time_int = time_int - (_mins * 60)
      time_str = time_str + str(_mins) + ":"
    elif time_int >= 60:
      _mins = time_int / 60
      time_int = time_int - (_mins * 60)
      time_str = time_str + "0" + str(_mins) + ":"
    else:
      time_str = time_str + "00:"
    if time_int > 9:
      time_str = time_str + str(time_int)
    else:
      time_str = time_str + "0" + str(time_int)
            
    return time_str
        
  # Convert medias streams time in ns to min:sec eg 01:27
  #
  def convert_ns(self, time_int):
    time_int = time_int / 1000000000
    return self.convert_s(time_int)

  # Create and display the preferences window
  #
  def show_pref_win_cb(self, widget):
    # Create the main window
    prefwin = hildon.StackableWindow()
    prefwin.set_title("Preferences")
   
    vbox = gtk.VBox(False,0)
    prefwin.add(vbox)
 
    cb1 = hildon.CheckButton(self.std_size)
    cb1.set_label("Display remaining time until timeout")
    cb1.set_active(self.prefs["displaytimeout"])
    cb1.connect("toggled", self.cb_toggled_timeout)
    vbox.pack_start(cb1, False, True)

    cb2 = hildon.CheckButton(self.std_size)
    cb2.set_label("Resume playing last file after startup")
    cb2.set_active(self.prefs["resumeplay"])
    cb2.connect("toggled", self.cb_toggled_resume)
    vbox.pack_start(cb2, False, True)

    cb3 = hildon.CheckButton(self.std_size)
    cb3.set_label("Use big buttons")
    cb3.set_active(self.prefs["bigbuttons"])
    cb3.connect("toggled", self.cb_toggled_big_btn)
    vbox.pack_start(cb3, False, True)

    timeouts = [ "5 min", "10 min", "20 min", "30 min", "60 min", "Never" ]
    # Create a picker button
    timeout_pk = hildon.PickerButton(self.std_size, hildon.BUTTON_ARRANGEMENT_HORIZONTAL) 
    # Set a title to the button 
    timeout_pk.set_title("Stop playing after: ") 
    # Create a touch selector entry
    selector = hildon.TouchSelectorEntry(text=True)
    # Populate the selector
    for timeout in timeouts:
      selector.append_text(timeout)
    # Attach the touch selector to the picker button
    timeout_pk.set_selector(selector)
    timeout_pk.set_active(self.prefs["timeout"])
    timeout_pk.connect("value-changed", self.timeout_changed)

    # Add button to main window
    vbox.pack_start(timeout_pk, False, True, 0)	
    prefwin.show_all()

  # Callback for changing displaying of timeout 
  #
  def cb_toggled_timeout(self, cb):
    self.prefs["displaytimeout"] = cb.get_active()
    self.save_prefs()

  # Callback for changing resume playing 
  #
  def cb_toggled_resume(self, cb):
    self.prefs["resumeplay"] = cb.get_active()
    self.save_prefs()

  # Callback for changing button size 
  #
  def cb_toggled_big_btn(self, cb):
    self.prefs["bigbuttons"] = cb.get_active()
    self.save_prefs()

  # Callback for changing timeout/suspend 
  #
  def timeout_changed(self, picker):
    self.prefs["timeout"] = picker.get_active()
    self.reset_timer()
    self.save_prefs()

  # Save preferences file
  #
  def save_prefs(self):
    prefdir = os.path.dirname(self.prefsfile)
    if os.path.exists(prefdir) == 0: # pref dir doesn't exists
      try:
        os.mkdir(prefdir)
      except:
        print "Can't create preferences directory!"
    try: 
      fd = open(self.prefsfile,"w")
      pickle.dump(self.prefs, fd)
      fd.close()
    except:
      print "Can't save preferences file"
  
  # Helperfunction for makeing a menu item
  #       
  def make_menu_item(self, menu, name, callback, data=None):
    item = gtk.MenuItem(name)
    item.connect("activate", callback, data)
    item.show()
    menu.append(item)
    return item

###################################################
# MAIN
###################################################
    
GTK_Main()
gtk.gdk.threads_init()
gtk.main()
