#include "fastlistform.h"
#include "ui_fastlistform.h"

FastListForm::FastListForm(QWidget *parent) :
    SlideWidget(parent),
    ui(new Ui::FastListForm)
{
    ui->setupUi(this);
    settings = new QSettings(WILLEM_LIU, EASY_LIST);
    shown();
}

FastListForm::~FastListForm()
{
    delete ui;
}
#include <QListWidgetItem>
void FastListForm::shown()
{
    ui->listWidget->clear();
    MyCheckBoxContainer::getInstance()->set(settings->value(LIST_TEXT, "").toString());
    QList<MyCheckBox * > checkBoxes = MyCheckBoxContainer::getInstance()->getCheckBoxes();
    QString bla;
    foreach(MyCheckBox * cb, checkBoxes)
    {
        QListWidgetItem * w = new QListWidgetItem;
        bla.append("1\n");
        w->setText(cb->text().append(bla));
        ui->listWidget->addItem(w);
        ui->listWidget->setItemWidget(w, cb);
    }
}

void FastListForm::on_editPushButton_clicked()
{
    emit signalNavigate(0);
}
