#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "machdep/m68kops.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(flags, x) SET_CFLG(flags, x)
#define SET_NFLG_ALWAYS(flags, x) SET_NFLG(flags, x)
#ifdef NOFLAGS
#include "noflags.h"
#endif

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
}
/* OR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0038_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0039_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 8);
}
/* ORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_003c_6)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	src &= 0xFF;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	regs->sr |= src;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
}
/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
}
/* OR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3705;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3705: ;
}
/* OR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3706;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3706: ;
}
/* OR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3707;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3707: ;
}
/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3708;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3708: ;
}
/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3709;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3709: ;
}
/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0078_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3710;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3710: ;
}
/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0079_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3711;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 8);
endlabel3711: ;
}
/* ORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_007c_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel3712; }
{	MakeSR (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	regs->sr |= src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel3712: ;
}
/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
}
/* OR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3714;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3714: ;
}
/* OR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3715;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3715: ;
}
/* OR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_00a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3716;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3716: ;
}
/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_00a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3717;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3717: ;
}
/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_00b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3718;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3718: ;
}
/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_00b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3719;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3719: ;
}
/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_00b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3720;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 12);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 10);
endlabel3720: ;
}
/* BTST.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 2);
}
/* MVPMR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_u16 val = (get_byte_ce (memp) << 8) + get_byte_ce (memp + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}	m68k_incpc (regs, 4);
}
/* BTST.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 2);
}
/* BTST.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 2);
}
/* BTST.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 2);
}
/* BTST.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
}
/* BTST.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_013a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_013b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 2;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B Dn,#<data>.B */
void REGPARAM2 CPUFUNC(op_013c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = (uae_u8)get_word_ce_prefetch (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 4);
}
/* BCHG.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 2);
}
/* MVPMR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_u32 val = (get_byte_ce (memp) << 24) + (get_byte_ce (memp + 2) << 16)
              + (get_byte_ce (memp + 4) << 8) + get_byte_ce (memp + 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (val);
}}	m68k_incpc (regs, 4);
}
/* BCHG.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BCHG.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BCHG.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BCHG.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCHG.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_017a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_017b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 2;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 2);
}
/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (memp, src >> 8); put_byte_ce (memp + 2, src);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}	m68k_incpc (regs, 4);
}
/* BCLR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BCLR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BCLR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BCLR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCLR.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_01ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_01bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 2;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_01c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 2);
}
/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (memp, src >> 24); put_byte_ce (memp + 2, src >> 16);
	put_byte_ce (memp + 4, src >> 8); put_byte_ce (memp + 6, src);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}	m68k_incpc (regs, 4);
}
/* BSET.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_01d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BSET.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_01d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BSET.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 2);
}
/* BSET.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BSET.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_01fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_getpc (regs) + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_01fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 2;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0200_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
}
/* AND.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0210_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0218_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0220_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0228_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0230_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0238_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0239_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 8);
}
/* ANDSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_023c_6)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	src |= 0xFF00;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	regs->sr &= src;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
}
/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0240_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
}
/* AND.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0250_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3776;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3776: ;
}
/* AND.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0258_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3777;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3777: ;
}
/* AND.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0260_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3778;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3778: ;
}
/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0268_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3779;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3779: ;
}
/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0270_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3780;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3780: ;
}
/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0278_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3781;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3781: ;
}
/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0279_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3782;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 8);
endlabel3782: ;
}
/* ANDSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_027c_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel3783; }
{	MakeSR (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	regs->sr &= src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel3783: ;
}
/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0280_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
}
/* AND.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0290_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3785;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3785: ;
}
/* AND.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0298_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3786;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3786: ;
}
/* AND.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_02a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3787;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3787: ;
}
/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_02a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3788;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3788: ;
}
/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_02b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3789;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3789: ;
}
/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_02b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3790;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3790: ;
}
/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_02b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3791;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 12);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 10);
endlabel3791: ;
}
/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0400_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0410_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0418_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0420_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0428_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0430_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0438_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0439_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
}
/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0440_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0450_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3801;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3801: ;
}
/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0458_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3802;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3802: ;
}
/* SUB.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0460_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3803;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3803: ;
}
/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0468_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3804;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3804: ;
}
/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0470_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3805;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3805: ;
}
/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0478_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3806;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3806: ;
}
/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0479_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3807;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3807: ;
}
/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0480_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
}
/* SUB.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0490_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3809;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3809: ;
}
/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0498_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3810;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3810: ;
}
/* SUB.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_04a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3811;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3811: ;
}
/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_04a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3812;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3812: ;
}
/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_04b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3813;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3813: ;
}
/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_04b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3814;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3814: ;
}
/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_04b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3815;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 12);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 10);
endlabel3815: ;
}
/* ADD.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0600_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0610_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0618_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0620_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0628_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0630_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0638_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0639_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 8);
}
/* ADD.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0640_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0650_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3825;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3825: ;
}
/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0658_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3826;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3826: ;
}
/* ADD.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0660_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3827;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3827: ;
}
/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0668_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3828;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3828: ;
}
/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0670_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3829;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3829: ;
}
/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0678_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3830;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3830: ;
}
/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0679_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3831;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3831: ;
}
/* ADD.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0680_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
}
/* ADD.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0690_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3833;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3833: ;
}
/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0698_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3834;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3834: ;
}
/* ADD.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_06a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3835;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3835: ;
}
/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_06a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3836;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3836: ;
}
/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_06b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3837;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3837: ;
}
/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_06b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3838;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3838: ;
}
/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_06b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3839;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 12);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 10);
endlabel3839: ;
}
/* BTST.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0800_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 4);
}
/* BTST.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0810_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0818_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0820_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 4);
}
/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0828_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
}
/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0830_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
}
/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0838_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
}
/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0839_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 8);
}
/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_083a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
}
/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_083b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 4;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}}	m68k_incpc (regs, 6);
}
/* BTST.B #<data>.W,#<data>.B */
void REGPARAM2 CPUFUNC(op_083c_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = (uae_u8)get_word_ce_prefetch (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
}}}	m68k_incpc (regs, 6);
}
/* BCHG.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0840_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 4);
}
/* BCHG.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0850_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0858_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0860_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0868_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0870_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0878_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0879_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 8);
}
/* BCHG.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_087a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCHG.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_087b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 4;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (&regs->ccrflags, ((uae_u32)dst & (1 << src)) >> src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCLR.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0880_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 4);
}
/* BCLR.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0890_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0898_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 8);
}
/* BCLR.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_08ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BCLR.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_08bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 4;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BSET.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_08c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 31;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpc (regs, 4);
}
/* BSET.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_08d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_08d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 4);
}
/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 8);
}
/* BSET.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_08fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_getpc (regs) + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* BSET.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_08fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpc (regs) + 4;
	dsta = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src &= 7;
	SET_ZFLG (&regs->ccrflags, 1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_ce (dsta,dst);
}}}}	m68k_incpc (regs, 6);
}
/* EOR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0a00_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
}
/* EOR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0a10_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0a18_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* EOR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0a20_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a28_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a30_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a38_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a39_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 8);
}
/* EORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_0a3c_6)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	src &= 0xFF;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	regs->sr ^= src;
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
}
/* EOR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0a40_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
}
/* EOR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0a50_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3891;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3891: ;
}
/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0a58_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3892;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3892: ;
}
/* EOR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0a60_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3893;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel3893: ;
}
/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a68_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3894;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3894: ;
}
/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a70_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3895;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3895: ;
}
/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a78_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3896;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel3896: ;
}
/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a79_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3897;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 8);
endlabel3897: ;
}
#endif

#ifdef PART_2
/* EORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_0a7c_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel3898; }
{	MakeSR (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	regs->sr ^= src;
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel3898: ;
}
/* EOR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0a80_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
}
/* EOR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0a90_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3900;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3900: ;
}
/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0a98_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3901;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3901: ;
}
/* EOR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0aa0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3902;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel3902: ;
}
/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0aa8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3903;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3903: ;
}
/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0ab0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3904;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3904: ;
}
/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0ab8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3905;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 8);
endlabel3905: ;
}
/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0ab9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3906;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 12);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 10);
endlabel3906: ;
}
/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0c00_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0c10_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0c18_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0c20_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c28_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
}
/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c30_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
}
/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c38_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
}
/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c39_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 8);
}
/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0c40_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0c50_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3916;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3916: ;
}
/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0c58_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3917;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3917: ;
}
/* CMP.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0c60_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3918;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel3918: ;
}
/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c68_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3919;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3919: ;
}
/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c70_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3920;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3920: ;
}
/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c78_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3921;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3921: ;
}
/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c79_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel3922;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3922: ;
}
/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0c80_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 6);
}
/* CMP.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0c90_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3924;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3924: ;
}
/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0c98_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3925;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3925: ;
}
/* CMP.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0ca0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3926;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel3926: ;
}
/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0ca8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3927;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3927: ;
}
/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0cb0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3928;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3928: ;
}
/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0cb8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3929;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 8);
endlabel3929: ;
}
/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0cb9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel3930;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 12);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 10);
endlabel3930: ;
}
/* MOVE.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_1000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),Dn */
void REGPARAM2 CPUFUNC(op_1010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_1018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_1020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_1028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_1030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_1038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_1039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_103a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_103b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_103c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_1080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),(An) */
void REGPARAM2 CPUFUNC(op_1090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,(An) */
void REGPARAM2 CPUFUNC(op_1098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),(An) */
void REGPARAM2 CPUFUNC(op_10a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_10a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_10b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_10b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_10ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_10bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_10c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),(An)+ */
void REGPARAM2 CPUFUNC(op_10d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_10d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_10f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_10f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_10fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_10fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_1100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}
/* MOVE.B (An),-(An) */
void REGPARAM2 CPUFUNC(op_1110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}
/* MOVE.B (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_1118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}
/* MOVE.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_1120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}
/* MOVE.B (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_1128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}
/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_1130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}
/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_1138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}
/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_1139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}}
/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_113a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}
/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_113b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}
/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_113c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}
/* MOVE.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_1140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_1158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_1170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_1178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_1179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_117a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_117b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_117c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_11c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_11d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_11fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_13c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.B (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_13d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}
/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_13fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_2000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.L An,Dn */
void REGPARAM2 CPUFUNC(op_2008_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.L (An),Dn */
void REGPARAM2 CPUFUNC(op_2010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4021;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4021: ;
}
/* MOVE.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_2018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4022;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4022: ;
}
/* MOVE.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_2020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4023;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4023: ;
}
/* MOVE.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_2028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4024;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4024: ;
}
/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_2030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4025;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4025: ;
}
/* MOVE.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_2038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4026;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4026: ;
}
/* MOVE.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_2039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4027;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4027: ;
}
/* MOVE.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_203a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4028;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4028: ;
}
/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_203b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4029;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4029: ;
}
/* MOVE.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_203c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVEA.L Dn,An */
void REGPARAM2 CPUFUNC(op_2040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVEA.L An,An */
void REGPARAM2 CPUFUNC(op_2048_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVEA.L (An),An */
void REGPARAM2 CPUFUNC(op_2050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4033;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4033: ;
}
/* MOVEA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_2058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4034;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4034: ;
}
/* MOVEA.L -(An),An */
void REGPARAM2 CPUFUNC(op_2060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4035;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4035: ;
}
/* MOVEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_2068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4036;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4036: ;
}
/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_2070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4037;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4037: ;
}
/* MOVEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_2078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4038;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4038: ;
}
/* MOVEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_2079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4039;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4039: ;
}
/* MOVEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_207a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4040;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4040: ;
}
/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_207b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4041;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4041: ;
}
/* MOVEA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_207c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_2080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4043;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4043: ;
}
/* MOVE.L An,(An) */
void REGPARAM2 CPUFUNC(op_2088_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4044;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4044: ;
}
/* MOVE.L (An),(An) */
void REGPARAM2 CPUFUNC(op_2090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4045;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4045;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4045: ;
}
/* MOVE.L (An)+,(An) */
void REGPARAM2 CPUFUNC(op_2098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4046;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4046;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4046: ;
}
/* MOVE.L -(An),(An) */
void REGPARAM2 CPUFUNC(op_20a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4047;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4047;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4047: ;
}
/* MOVE.L (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_20a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4048;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4048;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4048: ;
}
/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4049;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4049;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4049: ;
}
/* MOVE.L (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_20b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4050;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4050;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4050: ;
}
/* MOVE.L (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_20b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4051;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4051;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4051: ;
}
/* MOVE.L (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_20ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4052;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4052;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4052: ;
}
/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4053;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4053;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4053: ;
}
/* MOVE.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_20bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4054;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4054: ;
}
/* MOVE.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_20c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4055;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4055: ;
}
/* MOVE.L An,(An)+ */
void REGPARAM2 CPUFUNC(op_20c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4056;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4056: ;
}
/* MOVE.L (An),(An)+ */
void REGPARAM2 CPUFUNC(op_20d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4057;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4057;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4057: ;
}
/* MOVE.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_20d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4058;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4058;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4058: ;
}
/* MOVE.L -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4059;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4059;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4059: ;
}
/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4060;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4060;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4060: ;
}
/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4061;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4061;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4061: ;
}
/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_20f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4062;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4062;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4062: ;
}
/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_20f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4063;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4063;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4063: ;
}
/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_20fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4064;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4064;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4064: ;
}
/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4065;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4065;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4065: ;
}
/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_20fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4066;
	}
{	m68k_areg (regs, dstreg) += 4;
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4066: ;
}
/* MOVE.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_2100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4067;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}endlabel4067: ;
}
/* MOVE.L An,-(An) */
void REGPARAM2 CPUFUNC(op_2108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4068;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}endlabel4068: ;
}
/* MOVE.L (An),-(An) */
void REGPARAM2 CPUFUNC(op_2110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4069;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4069;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}}endlabel4069: ;
}
/* MOVE.L (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_2118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4070;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4070;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}}endlabel4070: ;
}
/* MOVE.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_2120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4071;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4071;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}}endlabel4071: ;
}
/* MOVE.L (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_2128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4072;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4072;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4072: ;
}
/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_2130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4073;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4073;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4073: ;
}
/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_2138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4074;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4074;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4074: ;
}
/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_2139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4075;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4075;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}}}endlabel4075: ;
}
/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_213a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4076;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4076;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4076: ;
}
/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_213b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4077;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4077;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4077: ;
}
/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_213c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4078;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}endlabel4078: ;
}
/* MOVE.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_2140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4079;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4079: ;
}
/* MOVE.L An,(d16,An) */
void REGPARAM2 CPUFUNC(op_2148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4080;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4080: ;
}
#endif

#ifdef PART_3
/* MOVE.L (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4081;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4081;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4081: ;
}
/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_2158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4082;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4082;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4082: ;
}
/* MOVE.L -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4083;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4083;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4083: ;
}
/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4084;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4084;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4084: ;
}
/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_2170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4085;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4085;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4085: ;
}
/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_2178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4086;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4086;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4086: ;
}
/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_2179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4087;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4087;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4087: ;
}
/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_217a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4088;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4088;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4088: ;
}
/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_217b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4089;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4089;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4089: ;
}
/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_217c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4090;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4090: ;
}
/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4091;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4091: ;
}
/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4092;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4092: ;
}
/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4093;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4093;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4093: ;
}
/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4094;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4094;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4094: ;
}
/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4095;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4095;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4095: ;
}
/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4096;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4096;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4096: ;
}
/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4097;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4097;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4097: ;
}
/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4098;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4098;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4098: ;
}
/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4099;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4099;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4099: ;
}
/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4100;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4100;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4100: ;
}
/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4101;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4101;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4101: ;
}
/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4102;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4102: ;
}
/* MOVE.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4103;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4103: ;
}
/* MOVE.L An,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4104;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4104: ;
}
/* MOVE.L (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4105;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4105;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4105: ;
}
/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_21d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4106;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4106;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4106: ;
}
/* MOVE.L -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4107;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4107;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4107: ;
}
/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4108;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4108;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4108: ;
}
/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4109;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4109;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4109: ;
}
/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4110;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4110;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4110: ;
}
/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4111;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4111;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4111: ;
}
/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4112;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4112;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4112: ;
}
/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4113;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4113;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4113: ;
}
/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4114;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4114: ;
}
/* MOVE.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4115;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4115: ;
}
/* MOVE.L An,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4116;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4116: ;
}
/* MOVE.L (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4117;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4117;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4117: ;
}
/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_23d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4118;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4118;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4118: ;
}
/* MOVE.L -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4119;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4119;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4119: ;
}
/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4120;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4120;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4120: ;
}
/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4121;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4121;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4121: ;
}
/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4122;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4122;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4122: ;
}
/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4123;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4123;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4123: ;
}
/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4124;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4124;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4124: ;
}
/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4125;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4125;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4125: ;
}
/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= get_word_ce_prefetch (regs, 10);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4126;
	}
{	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4126: ;
}
/* MOVE.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_3000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.W An,Dn */
void REGPARAM2 CPUFUNC(op_3008_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.W (An),Dn */
void REGPARAM2 CPUFUNC(op_3010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4129;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4129: ;
}
/* MOVE.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_3018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4130;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4130: ;
}
/* MOVE.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_3020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4131;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4131: ;
}
/* MOVE.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_3028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4132;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4132: ;
}
/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_3030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4133;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4133: ;
}
/* MOVE.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_3038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4134;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4134: ;
}
/* MOVE.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_3039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4135;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4135: ;
}
/* MOVE.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_303a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4136;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4136: ;
}
/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_303b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4137;
	}
{{	uae_s16 src = get_word_ce (srca);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4137: ;
}
/* MOVE.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_303c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVEA.W Dn,An */
void REGPARAM2 CPUFUNC(op_3040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVEA.W An,An */
void REGPARAM2 CPUFUNC(op_3048_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVEA.W (An),An */
void REGPARAM2 CPUFUNC(op_3050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4141;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4141: ;
}
/* MOVEA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_3058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4142;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4142: ;
}
/* MOVEA.W -(An),An */
void REGPARAM2 CPUFUNC(op_3060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4143;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4143: ;
}
/* MOVEA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_3068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4144;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4144: ;
}
/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_3070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4145;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4145: ;
}
/* MOVEA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_3078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4146;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4146: ;
}
/* MOVEA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_3079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4147;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4147: ;
}
/* MOVEA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_307a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4148;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4148: ;
}
/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_307b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4149;
	}
{{	uae_s16 src = get_word_ce (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4149: ;
}
/* MOVEA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_307c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* MOVE.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_3080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4151;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4151: ;
}
/* MOVE.W An,(An) */
void REGPARAM2 CPUFUNC(op_3088_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4152;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4152: ;
}
/* MOVE.W (An),(An) */
void REGPARAM2 CPUFUNC(op_3090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4153;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4153;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4153: ;
}
/* MOVE.W (An)+,(An) */
void REGPARAM2 CPUFUNC(op_3098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4154;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4154;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4154: ;
}
/* MOVE.W -(An),(An) */
void REGPARAM2 CPUFUNC(op_30a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4155;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4155;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4155: ;
}
/* MOVE.W (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_30a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4156;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4156;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4156: ;
}
/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4157;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4157;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4157: ;
}
/* MOVE.W (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_30b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4158;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4158;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4158: ;
}
/* MOVE.W (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_30b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4159;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4159;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4159: ;
}
/* MOVE.W (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_30ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4160;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4160;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4160: ;
}
/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4161;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4161;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4161: ;
}
/* MOVE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_30bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4162;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4162: ;
}
/* MOVE.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_30c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4163;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4163: ;
}
/* MOVE.W An,(An)+ */
void REGPARAM2 CPUFUNC(op_30c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4164;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4164: ;
}
/* MOVE.W (An),(An)+ */
void REGPARAM2 CPUFUNC(op_30d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4165;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4165;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4165: ;
}
/* MOVE.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_30d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4166;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4166;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4166: ;
}
/* MOVE.W -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4167;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4167;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4167: ;
}
/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4168;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4168;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4168: ;
}
/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4169;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4169;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4169: ;
}
/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_30f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4170;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4170;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4170: ;
}
/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_30f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4171;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4171;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4171: ;
}
/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_30fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4172;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4172;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4172: ;
}
/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4173;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4173;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4173: ;
}
/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_30fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4174;
	}
{	m68k_areg (regs, dstreg) += 2;
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4174: ;
}
/* MOVE.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_3100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4175;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}endlabel4175: ;
}
/* MOVE.W An,-(An) */
void REGPARAM2 CPUFUNC(op_3108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4176;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}endlabel4176: ;
}
/* MOVE.W (An),-(An) */
void REGPARAM2 CPUFUNC(op_3110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4177;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4177;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}}endlabel4177: ;
}
/* MOVE.W (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_3118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4178;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4178;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}}endlabel4178: ;
}
/* MOVE.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_3120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4179;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4179;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
}}}}}}endlabel4179: ;
}
/* MOVE.W (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_3128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4180;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4180;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4180: ;
}
/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_3130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4181;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4181;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4181: ;
}
/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_3138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4182;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4182;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4182: ;
}
/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_3139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4183;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4183;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
}}}}}}endlabel4183: ;
}
/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_313a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4184;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4184;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4184: ;
}
/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_313b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4185;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4185;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}}}endlabel4185: ;
}
/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_313c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4186;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
}}}}endlabel4186: ;
}
/* MOVE.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_3140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4187;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4187: ;
}
/* MOVE.W An,(d16,An) */
void REGPARAM2 CPUFUNC(op_3148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4188;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4188: ;
}
/* MOVE.W (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4189;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4189;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4189: ;
}
/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_3158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4190;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4190;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4190: ;
}
/* MOVE.W -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4191;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4191;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4191: ;
}
/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4192;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4192;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4192: ;
}
/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_3170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4193;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4193;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4193: ;
}
/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_3178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4194;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4194;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4194: ;
}
/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_3179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4195;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4195;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4195: ;
}
/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_317a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4196;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4196;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4196: ;
}
/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_317b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4197;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4197;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4197: ;
}
/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_317c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4198;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4198: ;
}
/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4199;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4199: ;
}
/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4200;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4200: ;
}
/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4201;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4201;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4201: ;
}
/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4202;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4202;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4202: ;
}
/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4203;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4203;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4203: ;
}
/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4204;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4204;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4204: ;
}
/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4205;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4205;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4205: ;
}
/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4206;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4206;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4206: ;
}
/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4207;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 8));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4207;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4207: ;
}
/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4208;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4208;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4208: ;
}
/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4209;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4209;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4209: ;
}
/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4210;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4210: ;
}
/* MOVE.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4211;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4211: ;
}
/* MOVE.W An,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4212;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4212: ;
}
/* MOVE.W (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4213;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4213;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4213: ;
}
/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_31d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4214;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4214;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4214: ;
}
/* MOVE.W -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4215;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4215;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4215: ;
}
/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4216;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4216;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4216: ;
}
/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4217;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4217;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4217: ;
}
/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4218;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4218;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4218: ;
}
/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4219;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4219;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4219: ;
}
/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4220;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4220;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4220: ;
}
/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4221;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4221;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4221: ;
}
/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4222;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4222: ;
}
/* MOVE.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4223;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4223: ;
}
/* MOVE.W An,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4224;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4224: ;
}
/* MOVE.W (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4225;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4225;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4225: ;
}
/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_33d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4226;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4226;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4226: ;
}
/* MOVE.W -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4227;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4227;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 6);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4227: ;
}
/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4228;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4228;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4228: ;
}
/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4229;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4229;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4229: ;
}
/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4230;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4230;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4230: ;
}
/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4231;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 8) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4231;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 10);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4231: ;
}
/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4232;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4232;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4232: ;
}
/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4233;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uaecptr dsta;
	dsta = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= regs->irc;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4233;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}endlabel4233: ;
}
/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 6) << 16;
	dsta |= get_word_ce_prefetch (regs, 8);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4234;
	}
{	put_word_ce (dsta,src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 8);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}endlabel4234: ;
}
/* NEGX.B Dn */
void REGPARAM2 CPUFUNC(op_4000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* NEGX.B (An) */
void REGPARAM2 CPUFUNC(op_4010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 2);
}
/* NEGX.B (An)+ */
void REGPARAM2 CPUFUNC(op_4018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 2);
}
/* NEGX.B -(An) */
void REGPARAM2 CPUFUNC(op_4020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 2);
}
/* NEGX.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 4);
}
/* NEGX.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 4);
}
/* NEGX.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4038_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 4);
}
/* NEGX.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4039_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}}	m68k_incpc (regs, 6);
}
/* NEGX.W Dn */
void REGPARAM2 CPUFUNC(op_4040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}	m68k_incpc (regs, 2);
}
/* NEGX.W (An) */
void REGPARAM2 CPUFUNC(op_4050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4244;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4244: ;
}
/* NEGX.W (An)+ */
void REGPARAM2 CPUFUNC(op_4058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4245;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4245: ;
}
/* NEGX.W -(An) */
void REGPARAM2 CPUFUNC(op_4060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4246;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4246: ;
}
/* NEGX.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4247;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4247: ;
}
/* NEGX.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4248;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4248: ;
}
/* NEGX.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4078_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4249;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4249: ;
}
/* NEGX.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4079_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4250;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca,newv);
}}}}}}	m68k_incpc (regs, 6);
endlabel4250: ;
}
/* NEGX.L Dn */
void REGPARAM2 CPUFUNC(op_4080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* NEGX.L (An) */
void REGPARAM2 CPUFUNC(op_4090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4252;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 2);
endlabel4252: ;
}
/* NEGX.L (An)+ */
void REGPARAM2 CPUFUNC(op_4098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4253;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 2);
endlabel4253: ;
}
/* NEGX.L -(An) */
void REGPARAM2 CPUFUNC(op_40a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4254;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 2);
endlabel4254: ;
}
/* NEGX.L (d16,An) */
void REGPARAM2 CPUFUNC(op_40a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4255;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 4);
endlabel4255: ;
}
/* NEGX.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4256;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 4);
endlabel4256: ;
}
/* NEGX.L (xxx).W */
void REGPARAM2 CPUFUNC(op_40b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4257;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 4);
endlabel4257: ;
}
/* NEGX.L (xxx).L */
void REGPARAM2 CPUFUNC(op_40b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4258;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = 0 - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, newv); put_word_ce (srca, newv >> 16);
}}}}}}	m68k_incpc (regs, 6);
endlabel4258: ;
}
/* MVSR2.W Dn */
void REGPARAM2 CPUFUNC(op_40c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeSR (regs);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs->sr) & 0xffff);
}}	m68k_incpc (regs, 2);
}
/* MVSR2.W (An) */
void REGPARAM2 CPUFUNC(op_40d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4260;
	}
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 2);
endlabel4260: ;
}
/* MVSR2.W (An)+ */
void REGPARAM2 CPUFUNC(op_40d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4261;
	}
{	m68k_areg (regs, srcreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 2);
endlabel4261: ;
}
/* MVSR2.W -(An) */
void REGPARAM2 CPUFUNC(op_40e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4262;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 2);
endlabel4262: ;
}
/* MVSR2.W (d16,An) */
void REGPARAM2 CPUFUNC(op_40e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4263;
	}
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 4);
endlabel4263: ;
}
/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4264;
	}
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 4);
endlabel4264: ;
}
/* MVSR2.W (xxx).W */
void REGPARAM2 CPUFUNC(op_40f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4265;
	}
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 4);
endlabel4265: ;
}
/* MVSR2.W (xxx).L */
void REGPARAM2 CPUFUNC(op_40f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4266;
	}
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	MakeSR (regs);
	put_word_ce (srca,regs->sr);
}}}	m68k_incpc (regs, 6);
endlabel4266: ;
}
/* CHK.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_4180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4267;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4267;
	}
}}}endlabel4267: ;
}
/* CHK.W (An),Dn */
void REGPARAM2 CPUFUNC(op_4190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4268;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4268;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4268;
	}
}}}}}endlabel4268: ;
}
/* CHK.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_4198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4269;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4269;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4269;
	}
}}}}}endlabel4269: ;
}
/* CHK.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_41a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4270;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4270;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4270;
	}
}}}}}endlabel4270: ;
}
/* CHK.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_41a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4271;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4271;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4271;
	}
}}}}}endlabel4271: ;
}
/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4272;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4272;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4272;
	}
}}}}}endlabel4272: ;
}
/* CHK.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_41b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4273;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4273;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4273;
	}
}}}}}endlabel4273: ;
}
/* CHK.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_41b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4274;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 6);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4274;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4274;
	}
}}}}}endlabel4274: ;
}
/* CHK.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_41ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4275;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4275;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4275;
	}
}}}}}endlabel4275: ;
}
/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4276;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4276;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4276;
	}
}}}}}endlabel4276: ;
}
/* CHK.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_41bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpc (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 6);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	if ((uae_s32)dst < 0) {
		SET_NFLG (&regs->ccrflags, 1);
		Exception (6, regs, oldpc);
		goto endlabel4277;
	} else if (dst > src) {
		SET_NFLG (&regs->ccrflags, 0);
		Exception (6, regs, oldpc);
		goto endlabel4277;
	}
}}}endlabel4277: ;
}
/* LEA.L (An),An */
void REGPARAM2 CPUFUNC(op_41d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 2);
}
/* LEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_41e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
}
/* LEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_41f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
{	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
}
/* LEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_41f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
}
/* LEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_41f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 6);
}
/* LEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_41fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
}
/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_41fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
{	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpc (regs, 4);
}
/* CLR.B Dn */
void REGPARAM2 CPUFUNC(op_4200_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((0) & 0xff);
}}	m68k_incpc (regs, 2);
}
/* CLR.B (An) */
void REGPARAM2 CPUFUNC(op_4210_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 2);
}
/* CLR.B (An)+ */
void REGPARAM2 CPUFUNC(op_4218_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 2);
}
/* CLR.B -(An) */
void REGPARAM2 CPUFUNC(op_4220_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 2);
}
/* CLR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4228_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 4);
}
/* CLR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4230_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 4);
}
/* CLR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4238_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 4);
}
/* CLR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4239_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(0)) < 0) ? 1 : 0);
	put_byte_ce (srca,0);
}}}	m68k_incpc (regs, 6);
}
/* CLR.W Dn */
void REGPARAM2 CPUFUNC(op_4240_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}	m68k_incpc (regs, 2);
}
/* CLR.W (An) */
void REGPARAM2 CPUFUNC(op_4250_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4294;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 2);
endlabel4294: ;
}
/* CLR.W (An)+ */
void REGPARAM2 CPUFUNC(op_4258_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4295;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 2);
endlabel4295: ;
}
/* CLR.W -(An) */
void REGPARAM2 CPUFUNC(op_4260_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4296;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 2);
endlabel4296: ;
}
/* CLR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4268_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4297;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 4);
endlabel4297: ;
}
/* CLR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4270_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4298;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 4);
endlabel4298: ;
}
/* CLR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4278_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4299;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 4);
endlabel4299: ;
}
/* CLR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4279_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4300;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(0)) < 0) ? 1 : 0);
	put_word_ce (srca,0);
}}}}	m68k_incpc (regs, 6);
endlabel4300: ;
}
/* CLR.L Dn */
void REGPARAM2 CPUFUNC(op_4280_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (0);
}}	m68k_incpc (regs, 2);
}
/* CLR.L (An) */
void REGPARAM2 CPUFUNC(op_4290_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4302;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 2);
endlabel4302: ;
}
#endif

#ifdef PART_4
/* CLR.L (An)+ */
void REGPARAM2 CPUFUNC(op_4298_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4303;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 2);
endlabel4303: ;
}
/* CLR.L -(An) */
void REGPARAM2 CPUFUNC(op_42a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4304;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 2);
endlabel4304: ;
}
/* CLR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_42a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4305;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 4);
endlabel4305: ;
}
/* CLR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_42b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4306;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 4);
endlabel4306: ;
}
/* CLR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_42b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4307;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 4);
endlabel4307: ;
}
/* CLR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_42b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4308;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(0)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(0)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, 0); put_word_ce (srca, 0 >> 16);
}}}}	m68k_incpc (regs, 6);
endlabel4308: ;
}
/* NEG.B Dn */
void REGPARAM2 CPUFUNC(op_4400_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}	m68k_incpc (regs, 2);
}
/* NEG.B (An) */
void REGPARAM2 CPUFUNC(op_4410_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
}
/* NEG.B (An)+ */
void REGPARAM2 CPUFUNC(op_4418_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
}
/* NEG.B -(An) */
void REGPARAM2 CPUFUNC(op_4420_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 2);
}
/* NEG.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4428_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
}
/* NEG.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4430_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
}
/* NEG.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4438_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 4);
}
/* NEG.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4439_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (srca,dst);
}}}}}}	m68k_incpc (regs, 6);
}
/* NEG.W Dn */
void REGPARAM2 CPUFUNC(op_4440_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
}
/* NEG.W (An) */
void REGPARAM2 CPUFUNC(op_4450_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4318;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 2);
endlabel4318: ;
}
/* NEG.W (An)+ */
void REGPARAM2 CPUFUNC(op_4458_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4319;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 2);
endlabel4319: ;
}
/* NEG.W -(An) */
void REGPARAM2 CPUFUNC(op_4460_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4320;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 2);
endlabel4320: ;
}
/* NEG.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4468_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4321;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 4);
endlabel4321: ;
}
/* NEG.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4470_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4322;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 4);
endlabel4322: ;
}
/* NEG.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4478_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4323;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 4);
endlabel4323: ;
}
/* NEG.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4479_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4324;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca,dst);
}}}}}}}	m68k_incpc (regs, 6);
endlabel4324: ;
}
/* NEG.L Dn */
void REGPARAM2 CPUFUNC(op_4480_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, srcreg) = (dst);
}}}}}	m68k_incpc (regs, 2);
}
/* NEG.L (An) */
void REGPARAM2 CPUFUNC(op_4490_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4326;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 2);
endlabel4326: ;
}
/* NEG.L (An)+ */
void REGPARAM2 CPUFUNC(op_4498_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4327;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 2);
endlabel4327: ;
}
/* NEG.L -(An) */
void REGPARAM2 CPUFUNC(op_44a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4328;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 2);
endlabel4328: ;
}
/* NEG.L (d16,An) */
void REGPARAM2 CPUFUNC(op_44a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4329;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 4);
endlabel4329: ;
}
/* NEG.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4330;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 4);
endlabel4330: ;
}
/* NEG.L (xxx).W */
void REGPARAM2 CPUFUNC(op_44b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4331;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 4);
endlabel4331: ;
}
/* NEG.L (xxx).L */
void REGPARAM2 CPUFUNC(op_44b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4332;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(0)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(dst)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(0))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}}}	m68k_incpc (regs, 6);
endlabel4332: ;
}
/* MV2SR.B Dn */
void REGPARAM2 CPUFUNC(op_44c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}	m68k_incpc (regs, 2);
}
/* MV2SR.B (An) */
void REGPARAM2 CPUFUNC(op_44d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4334;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 2);
endlabel4334: ;
}
/* MV2SR.B (An)+ */
void REGPARAM2 CPUFUNC(op_44d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4335;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 2);
endlabel4335: ;
}
/* MV2SR.B -(An) */
void REGPARAM2 CPUFUNC(op_44e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4336;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 2);
endlabel4336: ;
}
/* MV2SR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_44e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4337;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel4337: ;
}
/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4338;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel4338: ;
}
/* MV2SR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_44f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4339;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel4339: ;
}
/* MV2SR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_44f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4340;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 6);
endlabel4340: ;
}
/* MV2SR.B (d16,PC) */
void REGPARAM2 CPUFUNC(op_44fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4341;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel4341: ;
}
/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_44fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4342;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}	m68k_incpc (regs, 4);
endlabel4342: ;
}
/* MV2SR.B #<data>.B */
void REGPARAM2 CPUFUNC(op_44fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 8);
	MakeSR (regs);
	regs->sr &= 0xFF00;
	regs->sr |= src & 0xFF;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}	m68k_incpc (regs, 4);
}
/* NOT.B Dn */
void REGPARAM2 CPUFUNC(op_4600_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}	m68k_incpc (regs, 2);
}
/* NOT.B (An) */
void REGPARAM2 CPUFUNC(op_4610_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 2);
}
/* NOT.B (An)+ */
void REGPARAM2 CPUFUNC(op_4618_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 2);
}
/* NOT.B -(An) */
void REGPARAM2 CPUFUNC(op_4620_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 2);
}
/* NOT.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4628_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 4);
}
/* NOT.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4630_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 4);
}
/* NOT.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4638_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 4);
}
/* NOT.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4639_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(dst)) < 0) ? 1 : 0);
	put_byte_ce (srca,dst);
}}}}	m68k_incpc (regs, 6);
}
/* NOT.W Dn */
void REGPARAM2 CPUFUNC(op_4640_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpc (regs, 2);
}
/* NOT.W (An) */
void REGPARAM2 CPUFUNC(op_4650_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4353;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 2);
endlabel4353: ;
}
/* NOT.W (An)+ */
void REGPARAM2 CPUFUNC(op_4658_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4354;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 2);
endlabel4354: ;
}
/* NOT.W -(An) */
void REGPARAM2 CPUFUNC(op_4660_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4355;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 2);
endlabel4355: ;
}
/* NOT.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4668_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4356;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 4);
endlabel4356: ;
}
/* NOT.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4670_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4357;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 4);
endlabel4357: ;
}
/* NOT.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4678_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4358;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 4);
endlabel4358: ;
}
/* NOT.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4679_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4359;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca,dst);
}}}}}	m68k_incpc (regs, 6);
endlabel4359: ;
}
/* NOT.L Dn */
void REGPARAM2 CPUFUNC(op_4680_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
}
/* NOT.L (An) */
void REGPARAM2 CPUFUNC(op_4690_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4361;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 2);
endlabel4361: ;
}
/* NOT.L (An)+ */
void REGPARAM2 CPUFUNC(op_4698_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4362;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 2);
endlabel4362: ;
}
/* NOT.L -(An) */
void REGPARAM2 CPUFUNC(op_46a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4363;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 2);
endlabel4363: ;
}
/* NOT.L (d16,An) */
void REGPARAM2 CPUFUNC(op_46a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4364;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 4);
endlabel4364: ;
}
/* NOT.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4365;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 4);
endlabel4365: ;
}
/* NOT.L (xxx).W */
void REGPARAM2 CPUFUNC(op_46b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4366;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 4);
endlabel4366: ;
}
/* NOT.L (xxx).L */
void REGPARAM2 CPUFUNC(op_46b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4367;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	put_word_ce (srca + 2, dst); put_word_ce (srca, dst >> 16);
}}}}}	m68k_incpc (regs, 6);
endlabel4367: ;
}
/* MV2SR.W Dn */
void REGPARAM2 CPUFUNC(op_46c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4368; }
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 2);
endlabel4368: ;
}
/* MV2SR.W (An) */
void REGPARAM2 CPUFUNC(op_46d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4369; }
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4369;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 2);
endlabel4369: ;
}
/* MV2SR.W (An)+ */
void REGPARAM2 CPUFUNC(op_46d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4370; }
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4370;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 2);
endlabel4370: ;
}
/* MV2SR.W -(An) */
void REGPARAM2 CPUFUNC(op_46e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4371; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4371;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 2);
endlabel4371: ;
}
/* MV2SR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_46e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4372; }
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4372;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 4);
endlabel4372: ;
}
/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4373; }
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4373;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 4);
endlabel4373: ;
}
/* MV2SR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_46f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4374; }
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4374;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 4);
endlabel4374: ;
}
/* MV2SR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_46f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4375; }
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4375;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 6);
endlabel4375: ;
}
/* MV2SR.W (d16,PC) */
void REGPARAM2 CPUFUNC(op_46fa_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4376; }
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4376;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 4);
endlabel4376: ;
}
/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_46fb_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4377; }
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4377;
	}
{{	uae_s16 src = get_word_ce (srca);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}}}	m68k_incpc (regs, 4);
endlabel4377: ;
}
/* MV2SR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_46fc_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4378; }
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->sr = src;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	MakeFromSR (regs);
}}}	m68k_incpc (regs, 4);
endlabel4378: ;
}
/* NBCD.B Dn */
void REGPARAM2 CPUFUNC(op_4800_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}	m68k_incpc (regs, 2);
}
/* NBCD.B (An) */
void REGPARAM2 CPUFUNC(op_4810_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 2);
}
/* NBCD.B (An)+ */
void REGPARAM2 CPUFUNC(op_4818_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 2);
}
/* NBCD.B -(An) */
void REGPARAM2 CPUFUNC(op_4820_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 2);
}
/* NBCD.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4828_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 4);
}
/* NBCD.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4830_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 4);
}
/* NBCD.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4838_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 4);
}
/* NBCD.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4839_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u16 newv_lo = - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo -= 6; }
	newv = newv_hi + newv_lo;	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (srca,newv);
}}}}	m68k_incpc (regs, 6);
}
/* SWAP.W Dn */
void REGPARAM2 CPUFUNC(op_4840_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
}
/* PEA.L (An) */
void REGPARAM2 CPUFUNC(op_4850_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4388;
	}
{	m68k_areg (regs, 7) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
}}}}	m68k_incpc (regs, 2);
endlabel4388: ;
}
/* PEA.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4868_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4389;
	}
{	m68k_areg (regs, 7) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
}}}}	m68k_incpc (regs, 4);
endlabel4389: ;
}
/* PEA.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4870_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4390;
	}
{	m68k_areg (regs, 7) = dsta;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
}}}}	m68k_incpc (regs, 4);
endlabel4390: ;
}
/* PEA.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4878_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4391;
	}
{	m68k_areg (regs, 7) = dsta;
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4391: ;
}
/* PEA.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4879_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 6, dsta);
		goto endlabel4392;
	}
{	m68k_areg (regs, 7) = dsta;
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4392: ;
}
/* PEA.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_487a_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4393;
	}
{	m68k_areg (regs, 7) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
}}}}	m68k_incpc (regs, 4);
endlabel4393: ;
}
/* PEA.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_487b_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, dsta);
		goto endlabel4394;
	}
{	m68k_areg (regs, 7) = dsta;
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, srca >> 16); put_word_ce (dsta + 2, srca);
}}}}	m68k_incpc (regs, 4);
endlabel4394: ;
}
/* EXT.W Dn */
void REGPARAM2 CPUFUNC(op_4880_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpc (regs, 2);
}
/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4890_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4396;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4396: ;
}
/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4397;
	}
{{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 2; put_word_ce (srca, m68k_areg (regs, movem_index2[amask])); amask = movem_next[amask]; }
	while (dmask) { srca -= 2; put_word_ce (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4397: ;
}
/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4398;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4398: ;
}
/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4399;
	}
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4399: ;
}
/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48b8_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4400;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4400: ;
}
/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48b9_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 6) << 16;
	srca |= get_word_ce_prefetch (regs, 8);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4401;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
}}}}	m68k_incpc (regs, 8);
endlabel4401: ;
}
/* EXT.L Dn */
void REGPARAM2 CPUFUNC(op_48c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(dst)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(dst)) < 0) ? 1 : 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpc (regs, 2);
}
/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_48d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4403;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16); put_word_ce (srca + 2, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask]) >> 16); put_word_ce (srca + 2, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4403: ;
}
/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4404;
	}
{{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 4; put_word_ce (srca, m68k_areg (regs, movem_index2[amask]) >> 16); put_word_ce (srca + 2, m68k_areg (regs, movem_index2[amask])); amask = movem_next[amask]; }
	while (dmask) { srca -= 4; put_word_ce (srca, m68k_dreg (regs, movem_index2[dmask]) >> 16); put_word_ce (srca + 2, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4404: ;
}
/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4405;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16); put_word_ce (srca + 2, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask]) >> 16); put_word_ce (srca + 2, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4405: ;
}
/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4406;
	}
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16); put_word_ce (srca + 2, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask]) >> 16); put_word_ce (srca + 2, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4406: ;
}
/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4407;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16); put_word_ce (srca + 2, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask]) >> 16); put_word_ce (srca + 2, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4407: ;
}
/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 6) << 16;
	srca |= get_word_ce_prefetch (regs, 8);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4408;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word_ce (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16); put_word_ce (srca + 2, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_word_ce (srca, m68k_areg (regs, movem_index1[amask]) >> 16); put_word_ce (srca + 2, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
}}}}	m68k_incpc (regs, 8);
endlabel4408: ;
}
/* TST.B Dn */
void REGPARAM2 CPUFUNC(op_4a00_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
}
/* TST.B (An) */
void REGPARAM2 CPUFUNC(op_4a10_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
}
/* TST.B (An)+ */
void REGPARAM2 CPUFUNC(op_4a18_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
}
/* TST.B -(An) */
void REGPARAM2 CPUFUNC(op_4a20_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 2);
}
/* TST.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4a28_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
}
/* TST.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a30_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
}
/* TST.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4a38_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 4);
}
/* TST.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4a39_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
}}}	m68k_incpc (regs, 6);
}
/* TST.W Dn */
void REGPARAM2 CPUFUNC(op_4a40_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
}
/* TST.W (An) */
void REGPARAM2 CPUFUNC(op_4a50_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4418;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 2);
endlabel4418: ;
}
/* TST.W (An)+ */
void REGPARAM2 CPUFUNC(op_4a58_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4419;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 2);
endlabel4419: ;
}
/* TST.W -(An) */
void REGPARAM2 CPUFUNC(op_4a60_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4420;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 2);
endlabel4420: ;
}
/* TST.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4a68_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4421;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 4);
endlabel4421: ;
}
/* TST.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a70_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4422;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 4);
endlabel4422: ;
}
/* TST.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4a78_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4423;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 4);
endlabel4423: ;
}
/* TST.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4a79_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4424;
	}
{{	uae_s16 src = get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 6);
endlabel4424: ;
}
/* TST.L Dn */
void REGPARAM2 CPUFUNC(op_4a80_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}	m68k_incpc (regs, 2);
}
/* TST.L (An) */
void REGPARAM2 CPUFUNC(op_4a90_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4426;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 2);
endlabel4426: ;
}
/* TST.L (An)+ */
void REGPARAM2 CPUFUNC(op_4a98_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4427;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 2);
endlabel4427: ;
}
/* TST.L -(An) */
void REGPARAM2 CPUFUNC(op_4aa0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4428;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 2);
endlabel4428: ;
}
/* TST.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4aa8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4429;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 4);
endlabel4429: ;
}
/* TST.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ab0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4430;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 4);
endlabel4430: ;
}
/* TST.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ab8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4431;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 4);
endlabel4431: ;
}
/* TST.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ab9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4432;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
}}}}	m68k_incpc (regs, 6);
endlabel4432: ;
}
/* TAS.B Dn */
void REGPARAM2 CPUFUNC(op_4ac0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src |= 0x80;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((src) & 0xff);
}}	m68k_incpc (regs, 2);
}
/* TAS.B (An) */
void REGPARAM2 CPUFUNC(op_4ad0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 2);
}
/* TAS.B (An)+ */
void REGPARAM2 CPUFUNC(op_4ad8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 2);
}
/* TAS.B -(An) */
void REGPARAM2 CPUFUNC(op_4ae0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 2);
}
/* TAS.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4ae8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 4);
}
/* TAS.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4af0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 4);
}
/* TAS.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4af8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 4);
}
/* TAS.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4af9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	src |= 0x80;
	put_byte_ce (srca,src);
}}}	m68k_incpc (regs, 6);
}
/* MVMEL.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4c90_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4441;
	}
{{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4441: ;
}
/* MVMEL.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4c98_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4442;
	}
{{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	m68k_areg (regs, dstreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4442: ;
}
/* MVMEL.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ca8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4443;
	}
{{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4443: ;
}
/* MVMEL.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cb0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4444;
	}
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4444: ;
}
/* MVMEL.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cb8_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4445;
	}
{{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4445: ;
}
/* MVMEL.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cb9_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 6) << 16;
	srca |= get_word_ce_prefetch (regs, 8);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4446;
	}
{{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
}}}}	m68k_incpc (regs, 8);
endlabel4446: ;
}
/* MVMEL.W #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_getpc (regs) + 4;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4447;
	}
{{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4447: ;
}
/* MVMEL.W #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cbb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 4;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 6));
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4448;
	}
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	while (dmask) { m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_ce(srca); srca += 2; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4448: ;
}
/* MVMEL.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4cd0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4449;
	}
{{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4449: ;
}
/* MVMEL.L #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4cd8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4450;
	}
{{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	m68k_areg (regs, dstreg) = srca;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}	m68k_incpc (regs, 4);
endlabel4450: ;
}
/* MVMEL.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ce8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4451;
	}
{{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4451: ;
}
/* MVMEL.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cf0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 6));
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4452;
	}
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4452: ;
}
/* MVMEL.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cf8_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4453;
	}
{{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4453: ;
}
/* MVMEL.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cf9_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 6) << 16;
	srca |= get_word_ce_prefetch (regs, 8);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4454;
	}
{{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 10);
}}}}	m68k_incpc (regs, 8);
endlabel4454: ;
}
/* MVMEL.L #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cfa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca = m68k_getpc (regs) + 4;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4455;
	}
{{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4455: ;
}
/* MVMEL.L #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cfb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce_prefetch (regs, 4);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 4;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 6));
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 4, srca);
		goto endlabel4456;
	}
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	while (dmask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_dreg (regs, movem_index1[dmask]) = v; srca += 4; dmask = movem_next[dmask]; }
	while (amask) { v = get_word_ce(srca) << 16; v |= get_word_ce(srca + 2); m68k_areg (regs, movem_index1[amask]) = v; srca += 4; amask = movem_next[amask]; }
	get_word_ce (srca);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
}}}}	m68k_incpc (regs, 6);
endlabel4456: ;
}
/* TRAP.L #<data> */
void REGPARAM2 CPUFUNC(op_4e40_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 15);
{{	uae_u32 src = srcreg;
	m68k_incpc (regs, 2);
	Exception (src + 32, regs, 0);
}}}
/* LINK.W An,#<data>.W */
void REGPARAM2 CPUFUNC(op_4e50_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	if (olda & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, olda);
		goto endlabel4458;
	}
{	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
	put_word_ce (olda, src >> 16); put_word_ce (olda + 2, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
{	uae_s16 offs = get_word_ce_prefetch (regs, 4);
	m68k_areg (regs, 7) += offs;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
}}}}}	m68k_incpc (regs, 4);
endlabel4458: ;
}
/* UNLK.L An */
void REGPARAM2 CPUFUNC(op_4e58_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	m68k_areg (regs, 7) = src;
{	uaecptr olda = m68k_areg (regs, 7);
	if (olda & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, olda);
		goto endlabel4459;
	}
{{	uae_s32 old = get_word_ce (olda) << 16; old |= get_word_ce (olda + 2);
	m68k_areg (regs, 7) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_areg (regs, srcreg) = (old);
}}}}}	m68k_incpc (regs, 2);
endlabel4459: ;
}
/* MVR2USP.L An */
void REGPARAM2 CPUFUNC(op_4e60_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4460; }
{{	uae_s32 src = m68k_areg (regs, srcreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	regs->usp = src;
}}}	m68k_incpc (regs, 2);
endlabel4460: ;
}
/* MVUSP2R.L An */
void REGPARAM2 CPUFUNC(op_4e68_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4461; }
{{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_areg (regs, srcreg) = (regs->usp);
}}}	m68k_incpc (regs, 2);
endlabel4461: ;
}
/* RESET.L  */
void REGPARAM2 CPUFUNC(op_4e70_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4462; }
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	cpureset();
	regs->irc = get_iword (regs, 4);
}}	m68k_incpc (regs, 2);
endlabel4462: ;
}
/* NOP.L  */
void REGPARAM2 CPUFUNC(op_4e71_6)(uae_u32 opcode, struct regstruct *regs)
{
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
}	m68k_incpc (regs, 2);
}
/* STOP.L #<data>.W */
void REGPARAM2 CPUFUNC(op_4e72_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4464; }
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
	regs->sr = src;
	MakeFromSR (regs);
	m68k_setstopped (regs, 1);
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4464: ;
}
/* RTE.L  */
void REGPARAM2 CPUFUNC(op_4e73_6)(uae_u32 opcode, struct regstruct *regs)
{
{if (!regs->s) { Exception (8, regs, 0); goto endlabel4465; }
{{	uaecptr sra = m68k_areg (regs, 7);
	if (sra & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, sra);
		goto endlabel4465;
	}
{{	uae_s16 sr = get_word_ce (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca = m68k_areg (regs, 7);
	if (pca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, pca);
		goto endlabel4465;
	}
{{	uae_s32 pc = get_word_ce (pca) << 16; pc |= get_word_ce (pca + 2);
	m68k_areg (regs, 7) += 4;
	regs->sr = sr; m68k_setpc (regs, pc);
	MakeFromSR (regs);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}}}endlabel4465: ;
}
/* RTD.L #<data>.W */
void REGPARAM2 CPUFUNC(op_4e74_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr pca = m68k_areg (regs, 7);
	if (pca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, pca);
		goto endlabel4466;
	}
{{	uae_s32 pc = get_word_ce (pca) << 16; pc |= get_word_ce (pca + 2);
	m68k_areg (regs, 7) += 4;
{	uae_s16 offs = get_word_ce_prefetch (regs, 4);
	m68k_areg (regs, 7) += offs;
	if (pc & 1)
		exception3 (0x4e74, m68k_getpc (regs), pc);
	else
		m68k_setpc (regs, pc);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}endlabel4466: ;
}
/* RTS.L  */
void REGPARAM2 CPUFUNC(op_4e75_6)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_do_rts_ce (regs);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}
/* TRAPV.L  */
void REGPARAM2 CPUFUNC(op_4e76_6)(uae_u32 opcode, struct regstruct *regs)
{
{	m68k_incpc (regs, 2);
	if (GET_VFLG (&regs->ccrflags)) {
		Exception (7, regs, m68k_getpc (regs));
		goto endlabel4468;
	}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}endlabel4468: ;
}
/* RTR.L  */
void REGPARAM2 CPUFUNC(op_4e77_6)(uae_u32 opcode, struct regstruct *regs)
{
{	MakeSR (regs);
{	uaecptr sra = m68k_areg (regs, 7);
	if (sra & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, sra);
		goto endlabel4469;
	}
{{	uae_s16 sr = get_word_ce (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca = m68k_areg (regs, 7);
	if (pca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, pca);
		goto endlabel4469;
	}
{{	uae_s32 pc = get_word_ce (pca) << 16; pc |= get_word_ce (pca + 2);
	m68k_areg (regs, 7) += 4;
	regs->sr &= 0xFF00; sr &= 0xFF;
	regs->sr |= sr; m68k_setpc (regs, pc);
	MakeFromSR (regs);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}}}}endlabel4469: ;
}
/* JSR.L (An) */
void REGPARAM2 CPUFUNC(op_4e90_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uaecptr oldpc = m68k_getpc (regs) + 2;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4470;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4470: ;
}
/* JSR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ea8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)regs->irc;
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4471;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4471: ;
}
/* JSR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4eb0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), regs->irc);
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4472;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4472: ;
}
/* JSR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4eb8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)regs->irc;
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4473;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4473: ;
}
/* JSR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4eb9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca = get_word_ce_prefetch (regs, 4) << 16;
	srca |= regs->irc;
{	uaecptr oldpc = m68k_getpc (regs) + 6;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4474;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4474: ;
}
/* JSR.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4eba_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)regs->irc;
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4475;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4475: ;
}
/* JSR.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4ebb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, regs->irc);
{	uaecptr oldpc = m68k_getpc (regs) + 4;
	if (srca & 1) {
		exception3i (opcode, oldpc, srca);
		goto endlabel4476;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	m68k_areg (regs, 7) -= 4;
	put_word_ce (m68k_areg (regs, 7), oldpc >> 16);
	put_word_ce (m68k_areg (regs, 7) + 2, oldpc);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4476: ;
}
/* JMP.L (An) */
void REGPARAM2 CPUFUNC(op_4ed0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4477;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4477: ;
}
/* JMP.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ee8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)regs->irc;
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4478;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4478: ;
}
/* JMP.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ef0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), regs->irc);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4479;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4479: ;
}
/* JMP.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ef8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)regs->irc;
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4480;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4480: ;
}
/* JMP.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ef9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca = get_word_ce_prefetch (regs, 4) << 16;
	srca |= regs->irc;
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4481;
	}
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4481: ;
}
/* JMP.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4efa_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)regs->irc;
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4482;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4482: ;
}
/* JMP.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4efb_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, regs->irc);
	if (srca & 1) {
		exception3i (opcode, m68k_getpc (regs) + 6, srca);
		goto endlabel4483;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_setpc (regs, srca);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4483: ;
}
/* ADD.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
}
/* ADD.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* ADD.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* ADD.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* ADD.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* ADD.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
#endif

#ifdef PART_5
/* ADD.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(~dst)) < ((uae_u8)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* ADD.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
}
/* ADDA.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5048_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* ADD.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4494;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4494: ;
}
/* ADD.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4495;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4495: ;
}
/* ADD.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4496;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4496: ;
}
/* ADD.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4497;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4497: ;
}
/* ADD.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4498;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4498: ;
}
/* ADD.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4499;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4499: ;
}
/* ADD.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4500;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(~dst)) < ((uae_u16)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4500: ;
}
/* ADD.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
}
/* ADDA.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5088_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* ADD.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4503;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4503: ;
}
/* ADD.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4504;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4504: ;
}
/* ADD.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_50a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4505;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4505: ;
}
/* ADD.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_50a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4506;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4506: ;
}
/* ADD.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_50b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4507;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4507: ;
}
/* ADD.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_50b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4508;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4508: ;
}
/* ADD.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_50b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4509;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(~dst)) < ((uae_u32)(src))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4509: ;
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_50c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_50c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 0)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4511;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4511: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_50d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_50d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_50e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_50e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_50f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_50f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_50f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 0) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* SUB.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* SUB.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUBA.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* SUB.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4529;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4529: ;
}
/* SUB.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4530;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4530: ;
}
/* SUB.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4531;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4531: ;
}
/* SUB.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4532;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4532: ;
}
/* SUB.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4533;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4533: ;
}
/* SUB.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4534;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4534: ;
}
/* SUB.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4535;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4535: ;
}
/* SUB.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUBA.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* SUB.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4538;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4538: ;
}
/* SUB.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4539;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4539: ;
}
/* SUB.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_51a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4540;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4540: ;
}
/* SUB.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_51a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4541;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4541: ;
}
/* SUB.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_51b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4542;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4542: ;
}
/* SUB.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_51b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4543;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4543: ;
}
/* SUB.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_51b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4544;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4544: ;
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_51c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_51c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 1)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4546;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4546: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_51d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_51d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_51e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_51e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_51f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_51f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_51f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 1) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_52c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_52c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 2)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4555;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4555: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_52d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_52d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_52e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_52e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_52f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_52f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_52f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 2) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_53c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_53c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 3)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4564;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4564: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_53d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_53d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_53e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_53e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_53f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_53f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_53f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 3) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_54c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_54c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 4)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4573;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4573: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_54d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_54d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_54e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_54e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_54f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_54f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_54f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 4) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_55c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_55c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 5)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4582;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4582: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_55d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_55d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_55e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_55e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_55f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_55f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_55f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 5) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_56c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_56c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 6)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4591;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4591: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_56d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_56d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_56e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_56e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_56f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_56f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_56f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 6) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_57c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_57c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 7)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4600;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4600: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_57d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_57d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_57e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_57e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_57f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_57f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_57f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 7) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_58c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_58c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 8)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4609;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4609: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_58d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_58d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_58e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_58e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_58f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_58f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_58f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 8) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_59c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_59c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 9)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4618;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4618: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_59d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_59d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_59e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_59e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_59f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_59f8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_59f9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 9) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_5ac0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_5ac8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 10)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4627;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4627: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_5ad0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_5ad8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_5ae0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_5ae8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5af0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_5af8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_5af9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 10) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_5bc0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_5bc8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 11)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4636;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4636: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_5bd0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_5bd8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_5be0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_5be8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5bf0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_5bf8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_5bf9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 11) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_5cc0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_5cc8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 12)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4645;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4645: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_5cd0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_5cd8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_5ce0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_5ce8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5cf0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_5cf8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_5cf9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 12) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_5dc0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_5dc8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 13)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4654;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4654: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_5dd0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_5dd8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_5de0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_5de8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5df0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_5df8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_5df9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 13) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_5ec0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_5ec8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 14)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4663;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4663: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_5ed0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_5ed8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_5ee0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_5ee8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5ef0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_5ef8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_5ef9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 14) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Scc.B Dn */
void REGPARAM2 CPUFUNC(op_5fc0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (val) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* DBcc.W Dn,#<data>.W */
void REGPARAM2 CPUFUNC(op_5fc8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs->irc;
	uaecptr oldpc = m68k_getpc (regs);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 15)) {
		m68k_incpc (regs, (uae_s32)offs + 2);
		get_word_ce_prefetch (regs, 0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)offs + 2);
				goto endlabel4672;
			}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
			return;
		}
	} else {
		do_cycles_ce (CYCLE_UNIT / 2 * 2);
	}
	m68k_setpc (regs, oldpc + 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}endlabel4672: ;
}
/* Scc.B (An) */
void REGPARAM2 CPUFUNC(op_5fd0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (An)+ */
void REGPARAM2 CPUFUNC(op_5fd8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B -(An) */
void REGPARAM2 CPUFUNC(op_5fe0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 2);
}
/* Scc.B (d16,An) */
void REGPARAM2 CPUFUNC(op_5fe8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5ff0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
/* Scc.B (xxx).W */
void REGPARAM2 CPUFUNC(op_5ff8_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 4);
}
#endif

#ifdef PART_6
/* Scc.B (xxx).L */
void REGPARAM2 CPUFUNC(op_5ff9_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	int val = cctrue (&regs->ccrflags, 15) ? 0xff : 0;
	int cycles = 0;
	if (cycles > 0) do_cycles_ce (cycles);
	put_byte_ce (srca,val);
}}}}}	m68k_incpc (regs, 6);
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6000_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4680;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4680: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6001_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4681;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4681: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_60ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 0)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4682;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4682;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4682;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4682: ;
}
/* BSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6100_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_s32 s;
{	uae_s16 src = regs->irc;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + s);
		goto endlabel4683;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_do_bsr_ce (regs, m68k_getpc (regs) + 4, s);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4683: ;
}
/* BSR.B #<data> */
void REGPARAM2 CPUFUNC(op_6101_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{	uae_s32 s;
{	uae_u32 src = srcreg;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + s);
		goto endlabel4684;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_do_bsr_ce (regs, m68k_getpc (regs) + 2, s);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4684: ;
}
/* BSR.L #<data>.L */
void REGPARAM2 CPUFUNC(op_61ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	uae_s32 s;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 4) << 16;
	src |= regs->irc;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + s);
		goto endlabel4685;
	}
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_do_bsr_ce (regs, m68k_getpc (regs) + 6, s);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4685: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6200_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4686;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4686: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6201_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4687;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4687: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_62ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 2)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4688;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4688;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4688;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4688: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6300_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4689;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4689: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6301_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4690;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4690: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_63ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 3)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4691;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4691;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4691;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4691: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6400_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4692;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4692: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6401_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4693;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4693: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_64ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 4)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4694;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4694;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4694;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4694: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6500_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4695;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4695: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6501_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4696;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4696: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_65ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 5)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4697;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4697;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4697;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4697: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6600_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4698;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4698: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6601_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4699;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4699: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_66ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 6)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4700;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4700;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4700;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4700: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6700_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4701;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4701: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6701_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4702;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4702: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_67ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 7)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4703;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4703;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4703;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4703: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6800_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4704;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4704: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6801_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4705;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4705: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_68ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 8)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4706;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4706;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4706;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4706: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6900_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4707;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4707: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6901_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4708;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4708: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_69ff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 9)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4709;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4709;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4709;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4709: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6a00_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4710;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4710: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6a01_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4711;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4711: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_6aff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 10)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4712;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4712;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4712;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4712: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6b00_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4713;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4713: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6b01_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4714;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4714: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_6bff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 11)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4715;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4715;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4715;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4715: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6c00_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4716;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4716: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6c01_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4717;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4717: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_6cff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 12)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4718;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4718;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4718;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4718: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6d00_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4719;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4719: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6d01_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4720;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4720: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_6dff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 13)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4721;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4721;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4721;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4721: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6e00_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4722;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4722: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6e01_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4723;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4723: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_6eff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 14)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4724;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4724;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4724;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4724: ;
}
/* Bcc.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6f00_6)(uae_u32 opcode, struct regstruct *regs)
{
{{	uae_s16 src = regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4725;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4725: ;
}
/* Bcc.B #<data> */
void REGPARAM2 CPUFUNC(op_6f01_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4726;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 2);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4726: ;
}
/* Bcc.L #<data>.L */
void REGPARAM2 CPUFUNC(op_6fff_6)(uae_u32 opcode, struct regstruct *regs)
{
{	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (cctrue (&regs->ccrflags, 15)) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 1);
		goto endlabel4727;
	}
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	goto endlabel4727;
{	uae_s32 src;
	src = get_word_ce_prefetch (regs, 2) << 16;
	src |= regs->irc;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (!cctrue (&regs->ccrflags, 15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpc (regs) + 2, m68k_getpc (regs) + 2 + (uae_s32)src);
		goto endlabel4727;
	}
	m68k_incpc (regs, (uae_s32)src + 2);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
	return;
didnt_jump:;
	m68k_incpc (regs, 4);
	get_word_ce_prefetch (regs, 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}endlabel4727: ;
}
/* MOVE.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_7000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_u32 src = srcreg;
{	m68k_dreg (regs, dstreg) = (src);
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	m68k_incpc (regs, 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 2);
}}}}
/* OR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 2);
}
/* OR.B (An),Dn */
void REGPARAM2 CPUFUNC(op_8010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* OR.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* OR.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_8020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* OR.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 6);
}
/* OR.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_803a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_803b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_803c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
}
/* OR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_8040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 2);
}
/* OR.W (An),Dn */
void REGPARAM2 CPUFUNC(op_8050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4741;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
endlabel4741: ;
}
/* OR.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4742;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
endlabel4742: ;
}
/* OR.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_8060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4743;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
endlabel4743: ;
}
/* OR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4744;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4744: ;
}
/* OR.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4745;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4745: ;
}
/* OR.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4746;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4746: ;
}
/* OR.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4747;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 6);
endlabel4747: ;
}
/* OR.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_807a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4748;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4748: ;
}
/* OR.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_807b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4749;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4749: ;
}
/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_807c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
}
/* OR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_8080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
}
/* OR.L (An),Dn */
void REGPARAM2 CPUFUNC(op_8090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4752;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 2);
endlabel4752: ;
}
/* OR.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4753;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 2);
endlabel4753: ;
}
/* OR.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_80a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4754;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 2);
endlabel4754: ;
}
/* OR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4755;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel4755: ;
}
/* OR.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4756;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel4756: ;
}
/* OR.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4757;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel4757: ;
}
/* OR.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4758;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 6);
endlabel4758: ;
}
/* OR.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4759;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel4759: ;
}
/* OR.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4760;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel4760: ;
}
/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_80bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
}
/* DIVU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_80c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4762;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}endlabel4762: ;
}
/* DIVU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_80d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4763;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4763;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}}}endlabel4763: ;
}
/* DIVU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_80d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4764;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4764;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}}}endlabel4764: ;
}
/* DIVU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_80e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4765;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4765;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}}}endlabel4765: ;
}
/* DIVU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4766;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4766;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4766: ;
}
/* DIVU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4767;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4767;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4767: ;
}
/* DIVU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4768;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4768;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4768: ;
}
/* DIVU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4769;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 6);
		Exception (5, regs, oldpc);
		goto endlabel4769;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_incpc (regs, 6);
	}
}}}}}endlabel4769: ;
}
/* DIVU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4770;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4770;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4770: ;
}
/* DIVU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4771;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4771;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4771: ;
}
/* DIVU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_80fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4772;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		int cycles = getDivu68kCycles((uae_u32)dst, (uae_u16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if (newv > 0xffff) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}endlabel4772: ;
}
/* SBCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - GET_XFLG (&regs->ccrflags)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG (&regs->ccrflags, ((((dst & 0xFF) - (src & 0xFF) - bcd - GET_XFLG (&regs->ccrflags)) & 0x300) > 0xFF) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* SBCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_8108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - GET_XFLG (&regs->ccrflags)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG (&regs->ccrflags, ((((dst & 0xFF) - (src & 0xFF) - bcd - GET_XFLG (&regs->ccrflags)) & 0x300) > 0xFF) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,newv);
}}}}}}	m68k_incpc (regs, 2);
}
/* OR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_8110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* OR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* OR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* OR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* OR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* OR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_8150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4782;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel4782: ;
}
/* OR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4783;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel4783: ;
}
/* OR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4784;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel4784: ;
}
/* OR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4785;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel4785: ;
}
/* OR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4786;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel4786: ;
}
/* OR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4787;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel4787: ;
}
/* OR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4788;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel4788: ;
}
/* OR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_8190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4789;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel4789: ;
}
/* OR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4790;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel4790: ;
}
/* OR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_81a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4791;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel4791: ;
}
/* OR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_81a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4792;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel4792: ;
}
/* OR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_81b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4793;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel4793: ;
}
/* OR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_81b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4794;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel4794: ;
}
/* OR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_81b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4795;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src |= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel4795: ;
}
/* DIVS.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_81c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4796;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}endlabel4796: ;
}
/* DIVS.W (An),Dn */
void REGPARAM2 CPUFUNC(op_81d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4797;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4797;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}}}endlabel4797: ;
}
/* DIVS.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_81d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4798;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4798;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}}}endlabel4798: ;
}
/* DIVS.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_81e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4799;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 2);
		Exception (5, regs, oldpc);
		goto endlabel4799;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_incpc (regs, 2);
	}
}}}}}endlabel4799: ;
}
/* DIVS.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_81e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4800;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4800;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4800: ;
}
/* DIVS.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4801;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4801;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4801: ;
}
/* DIVS.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_81f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4802;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4802;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4802: ;
}
/* DIVS.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_81f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4803;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 6);
		Exception (5, regs, oldpc);
		goto endlabel4803;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_incpc (regs, 6);
	}
}}}}}endlabel4803: ;
}
/* DIVS.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_81fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4804;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4804;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4804: ;
}
/* DIVS.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4805;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4805;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}}}endlabel4805: ;
}
/* DIVS.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_81fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr oldpc = m68k_getpc (regs);
{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV (&regs->ccrflags);
	if (src == 0) {
		m68k_incpc (regs, 4);
		Exception (5, regs, oldpc);
		goto endlabel4806;
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		int cycles = getDivs68kCycles((uae_s32)dst, (uae_s16)src) * CYCLE_UNIT / 2;
		if (cycles > 0) do_cycles_ce (cycles);
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (&regs->ccrflags, 1);
			SET_NFLG (&regs->ccrflags, 1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_incpc (regs, 4);
	}
}}}endlabel4806: ;
}
/* SUB.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B (An),Dn */
void REGPARAM2 CPUFUNC(op_9010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_9020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 6);
}
/* SUB.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_903a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_903b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_903c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.W An,Dn */
void REGPARAM2 CPUFUNC(op_9048_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.W (An),Dn */
void REGPARAM2 CPUFUNC(op_9050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4820;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4820: ;
}
/* SUB.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4821;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4821: ;
}
/* SUB.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_9060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4822;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4822: ;
}
/* SUB.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4823;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4823: ;
}
/* SUB.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4824;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4824: ;
}
/* SUB.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4825;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4825: ;
}
/* SUB.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4826;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4826: ;
}
/* SUB.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_907a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4827;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4827: ;
}
/* SUB.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_907b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4828;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4828: ;
}
/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_907c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.L An,Dn */
void REGPARAM2 CPUFUNC(op_9088_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.L (An),Dn */
void REGPARAM2 CPUFUNC(op_9090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4832;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4832: ;
}
/* SUB.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4833;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4833: ;
}
/* SUB.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_90a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4834;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4834: ;
}
/* SUB.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_90a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4835;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4835: ;
}
/* SUB.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4836;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4836: ;
}
/* SUB.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_90b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4837;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4837: ;
}
/* SUB.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_90b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4838;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4838: ;
}
/* SUB.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_90ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4839;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4839: ;
}
/* SUB.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4840;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4840: ;
}
/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_90bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
}
/* SUBA.W Dn,An */
void REGPARAM2 CPUFUNC(op_90c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* SUBA.W An,An */
void REGPARAM2 CPUFUNC(op_90c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* SUBA.W (An),An */
void REGPARAM2 CPUFUNC(op_90d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4844;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4844: ;
}
/* SUBA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_90d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4845;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4845: ;
}
/* SUBA.W -(An),An */
void REGPARAM2 CPUFUNC(op_90e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4846;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4846: ;
}
/* SUBA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_90e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4847;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4847: ;
}
/* SUBA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_90f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4848;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4848: ;
}
/* SUBA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_90f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4849;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4849: ;
}
/* SUBA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_90f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4850;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
endlabel4850: ;
}
/* SUBA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_90fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4851;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4851: ;
}
/* SUBA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_90fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4852;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4852: ;
}
/* SUBA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_90fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 4);
}
/* SUBX.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpc (regs, 2);
}
/* SUBX.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_9110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 2);
}
/* SUB.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 4);
}
/* SUB.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_byte_ce (dsta,newv);
}}}}}}}	m68k_incpc (regs, 6);
}
/* SUBX.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
}
/* SUBX.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4864;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4864;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s16)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s16)(newv)) < 0) ? 1 : 0);
	put_word_ce (dsta,newv);
}}}}}}}}}	m68k_incpc (regs, 2);
endlabel4864: ;
}
/* SUB.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_9150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4865;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4865: ;
}
/* SUB.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4866;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4866: ;
}
/* SUB.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4867;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4867: ;
}
/* SUB.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4868;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4868: ;
}
/* SUB.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4869;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4869: ;
}
/* SUB.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4870;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4870: ;
}
/* SUB.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4871;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta,newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4871: ;
}
/* SUBX.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpc (regs, 2);
}
/* SUBX.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4873;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4873;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src - GET_XFLG (&regs->ccrflags);
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (&regs->ccrflags, flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s32)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}}	m68k_incpc (regs, 2);
endlabel4873: ;
}
/* SUB.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_9190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4874;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4874: ;
}
/* SUB.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4875;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4875: ;
}
/* SUB.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_91a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4876;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4876: ;
}
/* SUB.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_91a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4877;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4877: ;
}
/* SUB.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_91b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4878;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4878: ;
}
/* SUB.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_91b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4879;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4879: ;
}
/* SUB.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_91b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4880;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_NFLG (&regs->ccrflags, flgn);
	put_word_ce (dsta, newv >> 16); put_word_ce (dsta + 2, newv);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4880: ;
}
/* SUBA.L Dn,An */
void REGPARAM2 CPUFUNC(op_91c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* SUBA.L An,An */
void REGPARAM2 CPUFUNC(op_91c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* SUBA.L (An),An */
void REGPARAM2 CPUFUNC(op_91d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4883;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4883: ;
}
/* SUBA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_91d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4884;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4884: ;
}
/* SUBA.L -(An),An */
void REGPARAM2 CPUFUNC(op_91e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4885;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel4885: ;
}
/* SUBA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_91e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4886;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4886: ;
}
/* SUBA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_91f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4887;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4887: ;
}
/* SUBA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_91f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4888;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4888: ;
}
/* SUBA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_91f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4889;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
endlabel4889: ;
}
/* SUBA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_91fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4890;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4890: ;
}
/* SUBA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_91fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4891;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel4891: ;
}
/* SUBA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_91fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 6);
}
/* CMP.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.B (An),Dn */
void REGPARAM2 CPUFUNC(op_b010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_b020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 6);
}
/* CMP.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b03a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b03b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_b03c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
#endif

#ifdef PART_7
/* CMP.W An,Dn */
void REGPARAM2 CPUFUNC(op_b048_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.W (An),Dn */
void REGPARAM2 CPUFUNC(op_b050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4906;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4906: ;
}
/* CMP.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4907;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4907: ;
}
/* CMP.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_b060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4908;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4908: ;
}
/* CMP.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4909;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4909: ;
}
/* CMP.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4910;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4910: ;
}
/* CMP.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4911;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4911: ;
}
/* CMP.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4912;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4912: ;
}
/* CMP.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b07a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4913;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4913: ;
}
/* CMP.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b07b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4914;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4914: ;
}
/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_b07c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
}
/* CMP.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.L An,Dn */
void REGPARAM2 CPUFUNC(op_b088_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMP.L (An),Dn */
void REGPARAM2 CPUFUNC(op_b090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4918;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4918: ;
}
/* CMP.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4919;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4919: ;
}
/* CMP.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_b0a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4920;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4920: ;
}
/* CMP.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b0a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4921;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4921: ;
}
/* CMP.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4922;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4922: ;
}
/* CMP.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b0b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4923;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4923: ;
}
/* CMP.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b0b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4924;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4924: ;
}
/* CMP.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b0ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4925;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4925: ;
}
/* CMP.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4926;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4926: ;
}
/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_b0bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 6);
}
/* CMPA.W Dn,An */
void REGPARAM2 CPUFUNC(op_b0c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMPA.W An,An */
void REGPARAM2 CPUFUNC(op_b0c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMPA.W (An),An */
void REGPARAM2 CPUFUNC(op_b0d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4930;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4930: ;
}
/* CMPA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_b0d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4931;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4931: ;
}
/* CMPA.W -(An),An */
void REGPARAM2 CPUFUNC(op_b0e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4932;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4932: ;
}
/* CMPA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_b0e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4933;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4933: ;
}
/* CMPA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b0f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4934;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4934: ;
}
/* CMPA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b0f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4935;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4935: ;
}
/* CMPA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b0f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4936;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4936: ;
}
/* CMPA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b0fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4937;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4937: ;
}
/* CMPA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b0fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4938;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4938: ;
}
/* CMPA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_b0fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 4);
}
/* EOR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 2);
}
/* CMPM.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = (((uae_s8)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s8)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s8)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s8)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u8)(src)) > ((uae_u8)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
}
/* EOR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_b110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* EOR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* EOR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* EOR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* EOR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* EOR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* EOR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* EOR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 2);
}
/* CMPM.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4950;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4950;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = (((uae_s16)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s16)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s16)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s16)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u16)(src)) > ((uae_u16)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}}}	m68k_incpc (regs, 2);
endlabel4950: ;
}
/* EOR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_b150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4951;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel4951: ;
}
/* EOR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4952;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel4952: ;
}
/* EOR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4953;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel4953: ;
}
/* EOR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4954;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel4954: ;
}
/* EOR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4955;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel4955: ;
}
/* EOR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4956;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel4956: ;
}
/* EOR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4957;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel4957: ;
}
/* EOR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b180_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 4);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
}
/* CMPM.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4959;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4959;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}}}	m68k_incpc (regs, 2);
endlabel4959: ;
}
/* EOR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_b190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4960;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel4960: ;
}
/* EOR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4961;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel4961: ;
}
/* EOR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b1a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4962;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel4962: ;
}
/* EOR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b1a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4963;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel4963: ;
}
/* EOR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b1b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4964;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel4964: ;
}
/* EOR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b1b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4965;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel4965: ;
}
/* EOR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b1b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel4966;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src ^= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel4966: ;
}
/* CMPA.L Dn,An */
void REGPARAM2 CPUFUNC(op_b1c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMPA.L An,An */
void REGPARAM2 CPUFUNC(op_b1c8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 2);
}
/* CMPA.L (An),An */
void REGPARAM2 CPUFUNC(op_b1d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4969;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4969: ;
}
/* CMPA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_b1d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4970;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4970: ;
}
/* CMPA.L -(An),An */
void REGPARAM2 CPUFUNC(op_b1e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4971;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 2);
endlabel4971: ;
}
/* CMPA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_b1e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4972;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4972: ;
}
/* CMPA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b1f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4973;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4973: ;
}
/* CMPA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b1f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4974;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4974: ;
}
/* CMPA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b1f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4975;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 6);
endlabel4975: ;
}
/* CMPA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b1fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4976;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4976: ;
}
/* CMPA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b1fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4977;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}}}	m68k_incpc (regs, 4);
endlabel4977: ;
}
/* CMPA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_b1fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = (((uae_s32)(src)) < 0) ? 1 : 0;
	int flgo = (((uae_s32)(dst)) < 0) ? 1 : 0;
	int flgn = (((uae_s32)(newv)) < 0) ? 1 : 0;
	SET_ZFLG (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, (flgs != flgo) && (flgn != flgo));
	SET_CFLG (&regs->ccrflags, (((uae_u32)(src)) > ((uae_u32)(dst))) ? 1 : 0);
	SET_NFLG (&regs->ccrflags, flgn);
}}}}}}	m68k_incpc (regs, 6);
}
/* AND.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 2);
}
/* AND.B (An),Dn */
void REGPARAM2 CPUFUNC(op_c010_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* AND.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c018_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* AND.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_c020_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* AND.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c028_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c030_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c038_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c039_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 6);
}
/* AND.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c03a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c03b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 src = get_byte_ce (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_c03c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpc (regs, 4);
}
/* AND.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c040_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 2);
}
/* AND.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c050_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4991;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
endlabel4991: ;
}
/* AND.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c058_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4992;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
endlabel4992: ;
}
/* AND.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c060_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4993;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 2);
endlabel4993: ;
}
/* AND.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c068_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4994;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4994: ;
}
/* AND.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c070_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4995;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4995: ;
}
/* AND.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c078_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4996;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4996: ;
}
/* AND.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c079_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4997;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 6);
endlabel4997: ;
}
/* AND.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c07a_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4998;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4998: ;
}
/* AND.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c07b_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel4999;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpc (regs, 4);
endlabel4999: ;
}
/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c07c_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpc (regs, 4);
}
/* AND.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_c080_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
}
/* AND.L (An),Dn */
void REGPARAM2 CPUFUNC(op_c090_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5002;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 2);
endlabel5002: ;
}
/* AND.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c098_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5003;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 2);
endlabel5003: ;
}
/* AND.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5004;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 2);
endlabel5004: ;
}
/* AND.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5005;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel5005: ;
}
/* AND.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5006;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel5006: ;
}
/* AND.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5007;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel5007: ;
}
/* AND.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5008;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 6);
endlabel5008: ;
}
/* AND.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0ba_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5009;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel5009: ;
}
/* AND.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0bb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5010;
	}
{{	uae_s32 src = get_word_ce (srca) << 16; src |= get_word_ce (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpc (regs, 4);
endlabel5010: ;
}
/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_c0bc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src  = get_word_ce_prefetch (regs, 4) << 16;
	src |= get_word_ce_prefetch (regs, 6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 6);
}
/* MULU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c0c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}
/* MULU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c0d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5013;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}}endlabel5013: ;
}
/* MULU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c0d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5014;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}}endlabel5014: ;
}
/* MULU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5015;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 2);
}}}}}}endlabel5015: ;
}
/* MULU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5016;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}}endlabel5016: ;
}
/* MULU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5017;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}}endlabel5017: ;
}
/* MULU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5018;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}}endlabel5018: ;
}
/* MULU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5019;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 6);
}}}}}}endlabel5019: ;
}
/* MULU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5020;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}}endlabel5020: ;
}
/* MULU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5021;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}}endlabel5021: ;
}
/* MULU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c0fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpc (regs, 4);
}}}}}
/* ABCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c100_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpc (regs, 2);
}
/* ABCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_c108_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + GET_XFLG (&regs->ccrflags);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (&regs->ccrflags, cflg ? 1 : 0);
	COPY_CARRY (&regs->ccrflags);
	SET_ZFLG (&regs->ccrflags, GET_ZFLG (&regs->ccrflags) & ((((uae_s8)(newv)) == 0) ? 1 : 0));
	SET_NFLG (&regs->ccrflags, (((uae_s8)(newv)) < 0) ? 1 : 0);
	SET_VFLG (&regs->ccrflags, ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0) ? 1 : 0);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	put_byte_ce (dsta,newv);
}}}}}}	m68k_incpc (regs, 2);
}
/* AND.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_c110_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* AND.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_c118_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* AND.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_c120_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 2);
}
/* AND.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_c128_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_c130_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_c138_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 4);
}
/* AND.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_c139_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
{	uae_s8 dst = get_byte_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s8)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s8)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_byte_ce (dsta,src);
}}}}	m68k_incpc (regs, 6);
}
/* EXG.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_c140_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
}
/* EXG.L An,An */
void REGPARAM2 CPUFUNC(op_c148_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_areg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
}
/* AND.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_c150_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5034;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel5034: ;
}
/* AND.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_c158_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5035;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel5035: ;
}
/* AND.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_c160_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5036;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 2);
endlabel5036: ;
}
/* AND.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_c168_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5037;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel5037: ;
}
/* AND.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_c170_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5038;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel5038: ;
}
/* AND.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_c178_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5039;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 4);
endlabel5039: ;
}
/* AND.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_c179_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5040;
	}
{{	uae_s16 dst = get_word_ce (dsta);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s16)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s16)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta,src);
}}}}}	m68k_incpc (regs, 6);
endlabel5040: ;
}
/* EXG.L Dn,An */
void REGPARAM2 CPUFUNC(op_c188_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpc (regs, 2);
}
/* AND.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_c190_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5042;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel5042: ;
}
/* AND.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_c198_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5043;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel5043: ;
}
/* AND.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_c1a0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5044;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 2);
endlabel5044: ;
}
/* AND.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_c1a8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5045;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel5045: ;
}
/* AND.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_c1b0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (regs, m68k_areg (regs, dstreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5046;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel5046: ;
}
/* AND.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_c1b8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5047;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 4);
endlabel5047: ;
}
/* AND.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_c1b9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta  = get_word_ce_prefetch (regs, 4) << 16;
	dsta |= get_word_ce_prefetch (regs, 6);
	if (dsta & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, dsta);
		goto endlabel5048;
	}
{{	uae_s32 dst = get_word_ce (dsta) << 16; dst |= get_word_ce (dsta + 2);
	src &= dst;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(src)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(src)) < 0) ? 1 : 0);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
	put_word_ce (dsta, src >> 16); put_word_ce (dsta + 2, src);
}}}}}	m68k_incpc (regs, 6);
endlabel5048: ;
}
/* MULS.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c1c0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 2);
}
/* MULS.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c1d0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5050;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel5050: ;
}
/* MULS.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c1d8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5051;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel5051: ;
}
/* MULS.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c1e0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5052;
	}
{{	uae_s16 src = get_word_ce (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 2);
endlabel5052: ;
}
/* MULS.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c1e8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5053;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel5053: ;
}
/* MULS.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c1f0_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (regs, m68k_areg (regs, srcreg), get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5054;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel5054: ;
}
/* MULS.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c1f8_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5055;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel5055: ;
}
/* MULS.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c1f9_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca  = get_word_ce_prefetch (regs, 4) << 16;
	srca |= get_word_ce_prefetch (regs, 6);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5056;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 8);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 6);
endlabel5056: ;
}
/* MULS.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c1fa_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca = m68k_getpc (regs) + 2;
	srca += (uae_s32)(uae_s16)get_word_ce_prefetch (regs, 4);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5057;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel5057: ;
}
/* MULS.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c1fb_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpc (regs) + 2;
	srca = get_disp_ea_000 (regs, tmppc, get_word_ce_prefetch (regs, 4));
	do_cycles_ce (CYCLE_UNIT / 2 * 2);
	if (srca & 1) {
		exception3 (opcode, m68k_getpc (regs) + 2, srca);
		goto endlabel5058;
	}
{{	uae_s16 src = get_word_ce (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpc (regs, 4);
endlabel5058: ;
}
/* MULS.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c1fc_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce_prefetch (regs, 4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int cycles = 36 * CYCLE_UNIT / 2, bits;
	uae_u32 usrc;
	CLEAR_CZNV (&regs->ccrflags);
	SET_ZFLG   (&regs->ccrflags, (((uae_s32)(newv)) == 0) ? 1 : 0);
	SET_NFLG   (&regs->ccrflags, (((uae_s32)(newv)) < 0) ? 1 : 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) cycles += 2 * CYCLE_UNIT / 2;
	if (cycles > 0) do_cycles_ce (cycles);
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpc (regs, 4);
}
/* ADD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_d000_6)(uae_u32 opcode, struct regstruct *regs)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs->ir = regs->irc;
	get_word_ce_prefetch (regs, 4);
{{uae_u32