from datetime import time, datetime


def convert_string_to_time(string):
    args = [int(x) for x in string.split(":")]
    return time(*args)


class Time:
    def __init__(self):
        self.now = datetime.now().time()

    def between(self, low, high):
        low = convert_string_to_time(low)
        high = convert_string_to_time(high)
        return low <= self.now <= high


def sample():
    return {"time": Time()}
exporting = set(("time", ))
