from threading import Thread
from opcode import HAVE_ARGUMENT, opmap
LOAD_GLOBAL = opmap["LOAD_GLOBAL"]

import osso


def extract_globals(f):
    globals = set()
    co = f.func_code
    newcode = map(ord, co.co_code)

    i = 0
    while i < len(newcode):
        opcode = newcode[i]
        if opcode == LOAD_GLOBAL:
            oparg = newcode[i+1] + (newcode[i+2] << 8)
            name = co.co_names[oparg]
            globals.add(name)
        i += 1
        if opcode >= HAVE_ARGUMENT:
            i += 2
    return globals


osso_context = osso.Context("dwimd", "1.0", False)
