import py

from dwimd.engine import run_config_modules, run_functions, PlanningException, act
from dwimd.plugins import reload_plugins, get_plugin, init_plugins, get_pluginnames, \
        add_plugin, del_plugin
from dwimd.values import make_descriptor


def setup_module():
    reload_plugins()
    init_plugins()
    class TestModule(object):
        @staticmethod
        def act(value):
            print "testaction", value
    add_plugin("actions", "testaction", TestModule)

def teardown_module():
    del_plugin("actions", "testaction")

def test_run_config_modules():
    run_config_modules()

def test_require():
    def mytestfunc():
        require(wifi, on)
        require(wifi, off)
    py.test.raises(PlanningException, "run_functions([mytestfunc])")

def test_force_require():
    def mytestfunc():
        require(wifi, on)
        require(wifi, on)
    def mytestfunc2():
        require(wifi, on)
        force(wifi, on)
    def mytestfunc3():
        require(wifi, on)
        force(wifi, off)
    assert run_functions([mytestfunc, mytestfunc2]).plan.values[make_descriptor("wifi")]
    print run_functions([mytestfunc3])

def test_force_require_2():
    def mytestfunc4():
        force(wifi, off)
    def mytestfunc5():
        require(wifi, on)
    py.test.raises(PlanningException, "run_functions([mytestfunc4, mytestfunc5])")

def test_gestalt():
    def func():
        define_gestalt("Test", wifi=off)
        force("Test")
        vote(wifi, on)
    py.test.raises(PlanningException, "run_functions([func])")

def test_vote():
    def func():
        vote(wifi, off)
        vote(wifi, off)
        suggest(wifi, on)
        vote(wifi, on)
    run_functions([func]).plan.values[make_descriptor("wifi")] == False

def test_respect_manual_override():
    class TestModuleAction(object):
        set_count = 0
        read_value = False
        @staticmethod
        def act(value):
            TestModuleAction.set_count += 1
            assert TestModuleAction.set_count < 2 # because reading returns another value
        @staticmethod
        def read():
            return TestModuleAction.read_value
    class TestModuleSensor(object):
        count = 0
        @staticmethod
        def sample():
            TestModuleSensor.count += 1
            return {"count": TestModuleSensor.count}

    def func():
        if count < 100:
            force(test, on)
        else:
            force(test, off)
    add_plugin("actions", "test", TestModuleAction)
    add_plugin("sensors", "test", TestModuleSensor)

    try:
        plan = run_functions([func])
        act(plan)

        plan = run_functions([func], plan)
        act(plan) # is not set, action is disabled

        TestModuleSensor.count = 200
        plan = run_functions([func], plan)
        act(plan) # action is still disabled, even though read value matches

        TestModuleSensor.count = 200
        plan = run_functions([func], plan)
        act(plan) # action is still disabled

        TestModuleSensor.count = 0
        plan = run_functions([func], plan)
        act(plan) # action is not enabled, value is not set

        TestModuleAction.read_value = True # user sets value to old written value
        plan = run_functions([func], plan)
        act(plan) # action is enabled, value is not set because its already equal

        TestModuleAction.set_count = 0 # allow new sets
        TestModuleSensor.count = 200
        plan = run_functions([func], plan)
        act(plan) # action is enabled, value is set
        assert TestModuleAction.set_count == 1
    finally:
        del_plugin("actions", "test")
        del_plugin("sensors", "test")


def test_respect_manual_override():
    class TestModuleSensor(object):
        count = 0
        @staticmethod
        def sample():
            TestModuleSensor.count += 1
            return {"count": TestModuleSensor.count}
        exporting = "count".split()

    def func():
        if count < 100:
            force(testaction, on)
    def func2():
        force(testaction, on)
    add_plugin("sensors", "test", TestModuleSensor)

    try:
        plan = run_functions([func])
        act(plan)
        assert TestModuleSensor.count == 1

        plan = run_functions([func2], plan)
        act(plan)
        assert TestModuleSensor.count == 1
    finally:
        del_plugin("sensors", "test")

