import logging

from dwimd.main import SAMPLING_DELAY
from dwimd.sensors.history import sampler as history


def get_rotation():
    f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", "r")
    coords = [int(w) for w in f.readline().split()]
    f.close()
    return coords


try:
    get_rotation()
except IOError:
    raise ImportError("Only works on n900")


SAMPLING_TIME = 30
SAMPLE_AMOUNT = SAMPLING_TIME / SAMPLING_DELAY
MOVING_LIMIT = 300
class State:
    values = [get_rotation()] * SAMPLE_AMOUNT


def sample():
    State.values.pop(0)
    State.values.append(get_rotation())
    avg_x = sum(float(x) for (x, y, z) in State.values) / SAMPLE_AMOUNT
    avg_y = sum(float(y) for (x, y, z) in State.values) / SAMPLE_AMOUNT
    avg_z = sum(float(z) for (x, y, z) in State.values) / SAMPLE_AMOUNT
    var_x = sum(float(x - avg_x)**2 for (x, y, z) in State.values) / SAMPLE_AMOUNT
    var_y = sum(float(y - avg_y)**2 for (x, y, z) in State.values) / SAMPLE_AMOUNT
    var_z = sum(float(z - avg_z)**2 for (x, y, z) in State.values) / SAMPLE_AMOUNT
    logging.debug("VAR %f %f %f" % (var_x, var_y, var_z))
    moving = ((var_x > MOVING_LIMIT) + (var_y > MOVING_LIMIT) +
              (var_z > MOVING_LIMIT)) >= 2
    historical_move = max(history("historical_move", 300 / SAMPLING_TIME, moving)) is False
    return {"moving": moving, "not_moving_for_5min": historical_move}
exporting = "moving not_moving_for_5min".split()

def test():
    logging.basicConfig(level=logging.DEBUG)
    import time
    while True:
        time.sleep(1)
        print sample()


if __name__ == "__main__":
    test()
