import sys
import logging
import time

import glib
from dbus.mainloop.glib import DBusGMainLoop
import gobject

from dwimd.plugins import reload_plugins, init_plugins
from dwimd.engine import run_config_modules, act


SAMPLING_DELAY = 30 # seconds
env = None


def run(args):
    sys.path.append("/etc/dwimd/")
    if "-d" in args:
        logging.basicConfig(level=logging.DEBUG)

    DBusGMainLoop(set_as_default=True)
    glib.idle_add(startup)
    loop = gobject.MainLoop()
    loop.run()

def startup():
    global env
    logging.debug("Loading plugins ...")
    reload_plugins()
    init_plugins()
    logging.debug("Done loading and initing plugins.")

    try:
        env = run_config_modules()
    except Exception:
        import traceback
        traceback.print_exc()
        raise SystemExit(-1)
    glib.timeout_add_seconds(SAMPLING_DELAY, sampling_func)
    return False


def sampling_func():
    run_config_modules(env)
    act(env)
    return True


if __name__ == "__main__":
    sys.exit(run(sys.argv[1:]))
