import clutter
import os, sys, gobject
#from pygame import mixer, init as pginit, error as pgerror, get_error as pgget_error
import pygame
from pygame.locals import *
global stage
stage = clutter.Stage()


FREQ = 48000   # play with this for best sound
BITSIZE = -16  # here unsigned 16 bit
CHANNELS = 2   # 1 is mono, 2 is stereo, not the same as playbackchannels
BUFFER = 1024 # audio buffer size, number of samples
global RECLIST, SOURCE_ID, MODE, METRO, METRO_SPEED, drums
RECLIST = [[False, False, False, False, False, False]]
MODE = "n"
METRO = False
METRO_SPEED = 100
drums = [None, None, None, None, None, None]

def load_sound(name):
    class NoneSound:
        def play(self): pass
    if not pygame.mixer:
        return NoneSound()
    fullname = os.path.join('data', name)
    try:
        sound = pygame.mixer.Sound(fullname)
    except pygame.error, message:
        #print 'Cannot load sound:', wav
        raise SystemExit, message
    return sound

##############  SOUND VOODOO  ###############
pygame.mixer.pre_init(FREQ, BITSIZE, CHANNELS, BUFFER)
pygame.init()
pygame.init()
#pginit()
pygame.mixer.set_num_channels(50)
#############################################

global crash_sound, snare_sound, hitom_sound, metom_sound, lotom_sound, bass_sound, metro_sound

crash_sound = load_sound("/home/user/MyDocs/Drummer/crash.wav")
snare_sound = load_sound("/home/user/MyDocs/Drummer/snare.wav")
hitom_sound = load_sound("/home/user/MyDocs/Drummer/tom_high.wav")
metom_sound = load_sound("/home/user/MyDocs/Drummer/tom_med.wav")
lotom_sound = load_sound("/home/user/MyDocs/Drummer/tom_low.wav")
bass_sound = load_sound("/home/user/MyDocs/Drummer/bass.wav")
metro_sound = load_sound("/home/kipepeleon/Desktop/Drumer/metronome.wav")


class drum(object):
	def __init__(self, image, sound, index):
		self.box = clutter.Texture()
		self.box.set_from_file(image)
		self.sound = sound
		self.index = index
		drums[index] = self
		stage.add(self.box)
		self.box.set_reactive(True)
		self.box.connect("button-press-event", self.hit)
	def hit(self, box, event):
		self.sound.play()
		RECLIST[-1][self.index] = True
		

floor = clutter.Texture()
floor.set_from_file("floor.png")
floor.set_size(800, 480)
stage.add(floor)

crash = drum("crash_cymbal.png", crash_sound, 0)
crash.box.set_size(256, 144)
crash.box.set_position(5, 0)


liltom = drum("tom_small.png", hitom_sound, 1)
liltom.box.set_position(230,50)
liltom.box.set_size(196, 196)
medtom = drum("tom_med.png", metom_sound, 2)
medtom.box.set_position(375,5)
medtom.box.set_size(256, 256)
bigtom = drum("tom_big.png", lotom_sound, 3)
bigtom.box.set_position(525,100)
bigtom.box.set_size(325, 325)

bass = drum("bass.png", bass_sound, 4)
bass.box.set_position(275, 200)

snare = drum("snare.png", snare_sound, 5)
snare.box.set_position(25, 150)


def recorder():
	global RECLIST, MODE, METRO, METRO_SPEED
	RECLIST.append([False, False, False, False, False, False])
	if METRO and len(RECLIST)%METRO_SPEED==0:
		metro_sound.play()
	if MODE=="r":
		return True
	else:
		return False
		
def player():
	global RECLIST, MODE, INDEX, drums
	try:
		for i in range(len(RECLIST[INDEX])):
			if RECLIST[INDEX][i]:
				drums[i].hit(None, None)
		if MODE=="p" and INDEX<(len(RECLIST)):
			INDEX = INDEX+1
			return True
		else:
			play.set_from_file("play.png")
			return False
	except IndexError:
		MODE="n"
		play.set_from_file("play.png")
		return False
		
	
def do_record(box, event):
	global RECLIST, SOURCE_ID, MODE
	RECLIST = [[False, False, False, False, False, False]]
	SOURCE_ID = gobject.timeout_add(5, recorder)
	play.set_from_file("stop.png")
	MODE = "r"

def do_playstop(box, event):
	global MODE
	print MODE
	if MODE=="r" or MODE=="p":
		MODE="n"
		play.set_from_file("play.png")
		RECLIST[-1] = [False, False, False, False, False, False]
	else:
		MODE = "p"
		play.set_from_file("stop.png")
		global INDEX
		INDEX = 0
		SOURCE_ID = gobject.timeout_add(5, player)
		
		
def do_metro(box, event):
	global METRO
	METRO = not METRO
	if METRO:
		metro.set_from_file("metronome_pressed.png")
	else:
		metro.set_from_file("metronome_unpressed.png")
		
		
def turn_off(box, event):
	off.set_from_file("power_off.png")
	clutter.main_quit()

########Controls#########
record = clutter.Texture()
record.set_from_file("record.png")
record.set_position(0, 416)
record.set_reactive(True)
record.connect("button-press-event", do_record)
stage.add(record)
global play
play = clutter.Texture()
play.set_from_file("play.png")
play.set_position(64, 416)
play.set_reactive(True)
play.connect("button-press-event", do_playstop)
stage.add(play)
metro = clutter.Texture()
metro.set_from_file("metronome_unpressed.png")
metro.set_position(128, 416)
metro.set_reactive(True)
metro.connect("button-press-event", do_metro)
stage.add(metro)

buffero = clutter.Texture()
buffero.set_from_file("plain.png")
buffero.set_position(192, 416)
buffero.set_size(544, 64)
stage.add(buffero)

off = clutter.Texture()
off.set_from_file("power_on.png")
off.set_position(736, 416)
off.set_reactive(True)
off.connect("button-press-event", turn_off)
stage.add(off)


stage.set_size(800, 480)

stage.show_all()
stage.set_fullscreen(True)

stage.connect("destroy", clutter.main_quit)
clutter.main()
