#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

# HACK
# Add the current module's directory to sys.path to bypass
# problems when running as widget.
# Restore the path at the end of the imports
import sys
import os

orig_path=sys.path[:]
tmp_path=os.path.dirname( os.path.realpath( __file__ ) )
sys.path.append(tmp_path)

# End of hack

import gtk
import gobject
import hildon
from hildondesktop import *
from gtk import gdk
from math import pi
import cairo
import time

from subprocess import Popen,PIPE

from portrait import FremantleRotation
import launcher
from xdg.IconTheme import getIconPath
from win_config import WinConfig

import config
import apps
from icon import Icon
from icongrid import IconGrid
from sig import Disconnector

# Restore path
sys.path=orig_path

# IconGrid must be before HomePluginItem for its connect()
# and do_button_*() to override those of HomePluginItem
class DrlaunchPlugin(IconGrid, HomePluginItem, FremantleRotation, Disconnector):
    def __init__(self):
	IconGrid.__init__(self)
	HomePluginItem.__init__(self)
	FremantleRotation.__init__(self, 'DrlaunchPlugin',
	    mode=FremantleRotation.AUTOMATIC, dontrotate=True)
	Disconnector.__init__(self)

	self.winConfig=None

	self.set_settings(True)

	self.id=None
	self.config=None

	self.reset_mode()

    def get_id0(self):
	"""If this is called from the constructor then the program
	core dumps """
	aid=self.get_applet_id()

	# Get desktop activity if D.A.M. is present
	
	act="/usr/bin/activity"

	if os.path.exists(act):
	    r=Popen([act, "current"], stdout=PIPE).communicate()
	    activity=r[0].strip()
	else:
	    activity=""

	ret="%s-%s" % (aid, activity)

	return(ret)

    def get_id(self):
	if self.id==None:
	    self.id=self.get_id0()

	return(self.id)

    def get_config(self):
	if self.config==None:
	    id=self.get_id()
	    self.config=config.Config(id)

	return(self.config)

    def do_realize(self):
	launcher.init()
	config=self.get_config()
	config.load()

	IconGrid.do_realize(self, config)

	self.setSize(config.getSize())
	self.reloadIcons()

	screen=self.get_screen()
	self.set_colormap(screen.get_rgba_colormap())
	self.set_app_paintable(True)

	self.c(self, 'show-settings', self.slot_show_settings)
	self.c(self, 'long-press', self.signalLongpress)
	self.c(self, 'click', self.signalClick)
	self.c(self, 'notify', self.signalNotify)

	HomePluginItem.do_realize(self)

    def on_orientation_changed(self, orientation):
	# Avoid bugs
	if orientation==None or len(orientation)==0:
	    return

	# Get the first character of the string (l/p)
	o=orientation[0]
	self.setMode(o)
#	self.queue_draw()

    def do_expose_event(self, event):
	IconGrid.do_expose_event(self, event)
	HomePluginItem.do_expose_event(self, event)
	self.reset_mode()

    def slot_show_settings(self, dt):
	if self.winConfig!=None:
	    # Doesn't work
	    # self.winConfig.show_all()
	    return

	s=WinConfig(self.get_config())
	s.show_all()
	#s.c(s, 'delete-event', self.slotConfigDestroy)
	self.c(s, 'delete-event', self.slotConfigDestroy)
	#s.connect('destroy', self.slotConfigDestroy)
	self.winConfig=s

    def slotConfigDestroy(self, sender, event):
#	print "Sender:", sender
	dt=sender.getData()

	# Disconnect signals for that object in order to be deleted
	self.dis_finish(self.winConfig)
	#self.winConfig.finish()
	#self.winConfig.destroy()

	self.winConfig=None

	cfg=self.get_config()

	cfg.setSize(dt['size'])
	cfg.setApps(dt['apps'])
	cfg.setIndiv(dt['indiv'])
	cfg.setLongpress(dt['longpress'])
	cfg.setAnimate(dt['animate'])
	cfg.setNoBg(dt['nobg'])
	cfg.setThemeBg(dt['themebg'])
	cfg.setIconSize(dt['iconsize'])
	cfg.setIconPadding(dt['iconpadding'])
	cfg.setIconMargin(dt['iconmargin'])
	cfg.save()
	
	# Resize widget
	self.setSize(dt['size'])
	self.reloadIcons()
	self.icons.resizeMax()

	# Free memory that is used for animations if animations are disabled
	if not dt['animate']:
	    self.clearAnimationCache()

	# Free memory of backgrounds in case they changed
	self.clearBgCache()

	self.queue_draw()

#	print "slot-config-destroy-end"

	return(False)

    def handle_click(self, sender, icon):
	""" common handler for longpress and click """
	if icon.appname!=None and icon.appname!='':
	    launcher.launch(icon.appname)

    def signalLongpress(self, sender, icon):
	self.handle_click(sender, icon)

    def signalClick(self, sender, icon):
	config=self.get_config()

	if not config.getLongpress():
	    self.handle_click(sender, icon)

    def signalNotify(self, sender, property):
	if property.name=='is-on-current-desktop':
	    v=self.get_property(property.name)
	    if v and self.draw_pending:
		self.queue_draw()

    def resize2(self):
	config=self.get_config()

	w=(self.size[0] * config.iconsize) + \
	    (self.size[0] * config.getIconSpace())
	h=(self.size[1] * config.iconsize) + \
	    (self.size[1] * config.getIconSpace())
	self.set_size_request(w, h)
	self.resize(w, h)

    def setSize(self, size):
	IconGrid.setSize(self, size)
	self.resize2()

hd_plugin_type = DrlaunchPlugin

if __name__=="__main__":
    gobject.type_register(hd_plugin_type)
    obj=gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()



# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

