#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

from icon import Icon, getIcon
import apps

import gtk
import cairo
from gtk import gdk
import gobject

class IconWidget(gtk.Widget):
    def __init__(self, isconfig, config):
	gtk.Widget.__init__(self)

	self.config=config
	self.icon=Icon(isconfig, config)

    def getMaxIconSizeFull(self):
	c=self.config
	w=c.getIconSizeRange()[1] + 2*c.getIconPaddingRange()[1] + \
	    2*c.getIconMarginRange()[1]

	return(w)

    def resetSize(self):
	w=self.getMaxIconSizeFull()
	self.set_size_request(2*w, 2*w)

    def do_realize(self):
	screen=self.get_screen()
	self.set_colormap(screen.get_rgba_colormap())
	self.set_app_paintable(True)

	self.set_flags(self.flags() | gtk.REALIZED)

	self.window=gdk.Window(
	    self.get_parent_window(),
	    width=self.allocation.width,
	    height=self.allocation.height,
	    window_type=gdk.WINDOW_CHILD,
	    wclass=gdk.INPUT_OUTPUT,
	    event_mask=self.get_events() | gdk.EXPOSURE_MASK)

	self.window.set_user_data(self)

	self.window.move_resize(*self.allocation)

#	style=self.get_style()
#	style.set_background(self.window, gtk.STATE_NORMAL)
#	self.gc=style.bg_gc[gtk.STATE_NORMAL]

	self.icon.setWindow(self.window)
	self.resetSize()

    def do_unrealize(self):
	self.window.destroy()
	self.window.set_user_data(None)

    def do_expose_event(self, event):
	cr=self.window.cairo_create()

	cr.rectangle(event.area.x, event.area.y,
	    event.area.width, event.area.height)

	cr.clip()

	cr.save()
	# Paint the background
	style=self.get_style()
	col=style.bg[gtk.STATE_NORMAL]
	cr.set_source_color(col)
	cr.paint()

	x2=self.config.getIconSizeFull()

#	col=style.fg[gtk.STATE_ACTIVE]
#	cr.set_source_color(col)
#	#cr.set_source_rgba(0,1,1,0.5)
#	cr.rectangle(1,1,x2+x2+2,x2+2)
#	cr.stroke()
#	cr.restore()

	self.icon.draw(cr, 0, 0)
	self.icon.draw(cr, x2, 0)
	self.icon.draw(cr, 0, x2)
	self.icon.draw(cr, x2, x2)

    def setApp(self, app):
	self.app=app
	self.refresh()

    def refresh(self):
	if self.app!=None:
	    app=apps.readOne(self.app)
	    app['icon2']=getIcon(app['icon'], self.config.getIconSize())
	    self.icon.setApp(app)

	self.queue_draw()

gobject.type_register(IconWidget)

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

