#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of wifieye.
#
# wifieye is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# wifieye is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with wifieye.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

#import config
import apps
import icon
from icon import getIcon, Icon
from sig import Disconnector

import gobject
import gtk

class IconIter:
    def __init__(self, items):
	self.iter=items.__iter__()

    def __iter__(self):
	ret=self.iter.__iter__()
	return(ret)

    def next(self):
	ret=self.iter.next()
	return(ret)

class Icons(gobject.GObject, Disconnector):
#class Icons(gtk.Widget, Disconnector):

    #__gsignals__=Icon.gsignals
    def __init__(self, isconfig, config):
	self.__gobject_init__()
	#gobject.GObject.__init__(self)
	#gtk.Widget.__init__(self)
	Disconnector.__init__(self)

	self.icons={}
	self.allicons={}
	self.size=0
	self.isconfig=isconfig
	self.config=config

	# signal handlers
	self.handlers={}

	self.maxsz=(0,0)

	# setup allicons
	self.resizeMax()

#	print "icons-init"

    def finish(self):
	self.dis_finish()
	return
#	self.icons=None
#	self.allicons=None
#	print "icons-finish"

#    def __del__(self):
#	print "icons-del"

    def resizeMax(self):
	sz=self.maxsz
	maxsz=self.config.getMaxSize()

	# Create new entries in x
	if maxsz[0]>sz[0]:
	    for x in xrange(maxsz[0]-sz[0]):
		for y in xrange(sz[1]):
		    k=(x+sz[0],y)
		    ico=Icon(self.isconfig, self.config)
		    self.allicons[k]=ico
		    self.connect_one(ico)
	    sz=(maxsz[0], sz[1])
	elif maxsz[0]<sz[0]:
	    for x in xrange(sz[0]-maxsz[0]):
		for y in xrange(sz[1]):
		    k=(maxsz[0]+x,y)
		    t=self.allicons.pop(k)
		    self.disconnect_one(t)
	    sz=(maxsz[0], sz[1])

	# Create new entries in y
	if maxsz[1]>sz[1]:
	    for y in xrange(maxsz[1]-sz[1]):
		for x in xrange(sz[0]):
		    k=(x,y+sz[1])
		    ico=Icon(self.isconfig, self.config)
		    self.allicons[k]=ico
		    self.connect_one(ico)
	    sz=(sz[0], maxsz[1])
	elif maxsz[1]<sz[1]:
	    for y in xrange(sz[1]-maxsz[1]):
		for x in xrange(sz[0]):
		    k=(x,y+maxsz[1])
		    t=self.allicons.pop(k)
		    self.disconnect_one(t)
	    sz=(sz[0], maxsz[1])

	self.maxsz=sz

    @classmethod
    def register_signals(cls):
	signals=Icon.gsignals
	for s in signals:
	    ss=signals[s]
	    gobject.signal_new(s, cls, ss[0], ss[1], (Icon,))
#	    gobject.SIGNAL_RUN_FIRST,
#		gobject.TYPE_NONE, (Icon,))

    def __iter__(self):
	return(IconIter(self.icons))

    def connect_one(self, which):
	self.handlers[which]={
	    'longpress':    self.c(which, 'long-press', self.signalLongpress),
	    'click':	    self.c(which, 'click', self.signalClick),
	    'tripple':	    self.c(which, 'tripple-click',
				self.signalTrippleClick)
	    }

    def disconnect_one(self, which):
	for i in self.handlers[which]:
	    which.disconnect(self.handlers[which][i])
	self.handlers.pop(which)
#	which.disconnect(self.h[which]_longpress)
#	which.disconnect(self.h_click)
#	which.disconnect(self.h_tripple)

    def setSize(self, sz):
#	print "sz:", sz, self.size

	if sz==self.size:
	    return

	old=self.icons
	self.icons={}

	for x in xrange(sz[0]):
	    for y in xrange(sz[1]):
		k=(x,y)
		ico=self.allicons[k]
		self.icons[k]=ico
#		if old.has_key(k):
#		    old.pop(k)	# Re-used
#		else:
#		    self.connect_one(ico)

	# Disconnect signals
#	for i in old:
#	    self.disconnect_one(old[i])

	self.size=sz

    def getSize(self):
	return(self.size)

    def setWindow(self, win):
	""" Set the window for all icons """

	for i in self.icons:
	    ic=self.icons[i]
	    ic.setWindow(win)

    def signalLongpress(self, icon):
	#print "signalLongpress()", icon
	self.emit('long-press', icon)

    def signalClick(self, icon):
	#print "signalClick()", icon
	self.emit('click', icon)

    def signalTrippleClick(self, icon):
	#print "signalTrippleClick()", icon
	self.emit('tripple-click', icon)

    def get(self, x, y):
	k=(x,y)
	if self.icons.has_key(k):
	    ret=self.icons[k]
	else:
	    ret=None

	return(ret)

    def load(self):
#	x=0
#	y=0
#	fn=["maegirls", "wifieye", 'battery-eye', 'image-viewer',
#	    'tecnoballz', 'ncalc', 'rtcom-call-ui', 'rtcom-messaging-ui',
#	    'extcalllog', 'browser', 'modest', 'osso-addressbook']

	wapps=self.config.getApps()
	#sz=self.config.getSize()
	sz=self.getSize()

	for k in wapps:
	    x,y=k
	    if x>=sz or y>=sz:
		continue

	    appname=wapps[k]
	    if appname!=None:
		app=apps.readOne(appname)
		if app!=None:
		    app['icon2']=getIcon(app['icon'], self.config.getIconSize())
		    self.get(x,y).setApp(app)
	    else:
		ic=self.get(x,y)
		ic.setApp(None)

	# Reload icons to make sure backgrounds, etc are valid
	for x in xrange(sz[0]):
	    for y in xrange(sz[1]):
		ic=self.get(x,y)
		ic.reload()


#	for f in fn:
#	    dt=apps.readOne(f)
#	    dt['icon2']=getIcon(dt['icon'])
#	    print x, y, dt
#	    self.get(x,y).setApp(dt)
#	    x+=1
#	    if x>=config.getSize(getSize()):
#		x=0
#		y+=1
##	    self.icons.append(p)

gobject.type_register(Icons)
Icons.register_signals()

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

